/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.table;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.component.table.TGTableBodyLayout;
import org.herac.tuxguitar.app.view.component.table.TGTableDividerHelper;
import org.herac.tuxguitar.app.view.component.table.TGTableHeader;
import org.herac.tuxguitar.app.view.component.table.TGTableHeaderLabel;
import org.herac.tuxguitar.app.view.component.table.TGTableHeaderMeasures;
import org.herac.tuxguitar.app.view.component.table.TGTableRow;
import org.herac.tuxguitar.app.view.component.table.TGTableViewer;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDivider;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.util.TGContext;

public class TGTable {
    private static final float DIVIDER_WIDTH = 2.0f;
    private final TGTableViewer viewer;
    private TGContext context;
    private UIPanel table;
    private UIPanel columnControl;
    private UIPanel rowControl;
    private TGTableHeaderLabel columnNumber;
    private TGTableHeaderLabel columnSoloMute;
    private TGTableHeaderLabel columnName;
    private TGTableHeaderLabel columnInstrument;
    private TGTableHeaderMeasures columnCanvas;
    private List<TGTableRow> rows;

    public TGTable(TGContext context, TGTableViewer viewer, UILayoutContainer parent) {
        this.context = context;
        this.viewer = viewer;
        this.rows = new ArrayList<TGTableRow>();
        this.newTable(parent);
    }

    public void newTable(UILayoutContainer parent) {
        UIFactory uiFactory = this.getUIFactory();
        this.table = uiFactory.createPanel((UIContainer)parent, false);
        this.columnControl = uiFactory.createPanel((UIContainer)this.table, false);
        this.columnNumber = new TGTableHeaderLabel(this);
        this.columnSoloMute = new TGTableHeaderLabel(this);
        this.columnName = new TGTableHeaderLabel(this);
        this.columnInstrument = new TGTableHeaderLabel(this);
        this.columnCanvas = new TGTableHeaderMeasures(this);
        this.rowControl = uiFactory.createPanel((UIContainer)this.table, false);
        this.rowControl.setLayout((UILayout)new TGTableBodyLayout());
        this.createTableLayout();
        this.createColumnLayout();
    }

    public boolean rowsAreInitialized() {
        return ((TGTableBodyLayout)this.rowControl.getLayout()).isInitialized();
    }

    public UIPanel getControl() {
        return this.table;
    }

    public TGTableViewer getViewer() {
        return this.viewer;
    }

    public void createTableLayout() {
        UITableLayout uiLayout = new UITableLayout(Float.valueOf(0.0f));
        uiLayout.set((UIControl)this.columnControl, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        uiLayout.set((UIControl)this.rowControl, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        this.table.setLayout((UILayout)uiLayout);
    }

    public void createColumnLayout() {
        TGTableDividerHelper dividerHelper = new TGTableDividerHelper(this);
        UITableLayout uiLayout = new UITableLayout(Float.valueOf(0.0f));
        int columnIndex = 0;
        this.createColumnHeaderLayout(uiLayout, this.columnNumber, ++columnIndex, false, null);
        this.createColumnHeaderLayout(uiLayout, this.columnSoloMute, ++columnIndex, false, null);
        this.createColumnHeaderLayout(uiLayout, this.columnName, ++columnIndex, false, Float.valueOf(250.0f));
        this.createColumnDividerLayout(uiLayout, dividerHelper.createDivider(this.columnName, this.columnInstrument, false), ++columnIndex);
        this.createColumnHeaderLayout(uiLayout, this.columnInstrument, ++columnIndex, false, Float.valueOf(250.0f));
        this.createColumnDividerLayout(uiLayout, dividerHelper.createDivider(this.columnInstrument, this.columnCanvas, true), ++columnIndex);
        this.createColumnHeaderLayout(uiLayout, this.columnCanvas, ++columnIndex, true, null);
        this.columnControl.setLayout((UILayout)uiLayout);
    }

    public void createColumnDividerLayout(UITableLayout uiLayout, UIDivider divider, int columnIndex) {
        uiLayout.set((UIControl)divider, Integer.valueOf(1), Integer.valueOf(columnIndex), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        uiLayout.set((UIControl)divider, "packed_width", (Object)Float.valueOf(2.0f));
        uiLayout.set((UIControl)divider, "margin", (Object)Float.valueOf(0.0f));
    }

    private void createColumnHeaderLayout(UITableLayout uiLayout, TGTableHeader column, int columnIndex, Boolean fillX, Float minimumPackedWidth) {
        uiLayout.set(column.getControl(), Integer.valueOf(1), Integer.valueOf(columnIndex), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, fillX, Boolean.valueOf(false));
        uiLayout.set(column.getControl(), "minimum_packed_width", (Object)minimumPackedWidth);
        uiLayout.set(column.getControl(), "margin", (Object)Float.valueOf(0.0f));
    }

    public void createRow() {
        this.rows.add(new TGTableRow(this));
    }

    public int getRowIndex(TGTableRow row) {
        return this.rows.indexOf(row);
    }

    public float getRowHeight() {
        return ((TGTableBodyLayout)this.rowControl.getLayout()).getRowHeight();
    }

    public float getMinHeight() {
        return this.table.getPackedSize().getHeight();
    }

    public UIPanel getColumnControl() {
        return this.columnControl;
    }

    public UIPanel getRowControl() {
        return this.rowControl;
    }

    public TGTableHeaderLabel getColumnInstrument() {
        return this.columnInstrument;
    }

    public TGTableHeaderLabel getColumnName() {
        return this.columnName;
    }

    public TGTableHeaderLabel getColumnNumber() {
        return this.columnNumber;
    }

    public TGTableHeaderLabel getColumnSoloMute() {
        return this.columnSoloMute;
    }

    public TGTableHeaderMeasures getColumnCanvas() {
        return this.columnCanvas;
    }

    public TGTableRow getRow(int index) {
        if (index >= 0 && index < this.rows.size()) {
            return this.rows.get(index);
        }
        return null;
    }

    public void removeRowsAfter(int index) {
        while (index < this.rows.size()) {
            TGTableRow row = this.rows.get(index);
            row.dispose();
            this.rows.remove(index);
        }
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public void appendListeners(UIControl control) {
        TuxGuitar.getInstance().getKeyBindingManager().appendListenersTo(control);
    }

    public void update() {
        this.table.layout();
    }

    public TGContext getContext() {
        return this.context;
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context).getFactory();
    }
}

