/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.tabfolder;

import org.herac.tuxguitar.app.view.component.tab.TGControl;
import org.herac.tuxguitar.app.view.component.tabfolder.TGTabFolder;
import org.herac.tuxguitar.editor.util.TGSyncProcessLocked;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.util.TGContext;

public class TGTabEventListener
implements TGEventListener {
    private TGContext context;
    private TGSyncProcessLocked redrawProcess;
    private TGSyncProcessLocked redrawPlayModeProcess;

    public TGTabEventListener(TGContext context) {
        this.context = context;
        this.createSyncProcesses();
    }

    public TGControl findTabControl() {
        return TGTabFolder.getInstance(this.context).findSelectedControl();
    }

    public void redraw() {
        TGControl control = this.findTabControl();
        if (control != null) {
            control.redraw();
        }
    }

    public void redrawPlayingMode() {
        TGControl control = this.findTabControl();
        if (control != null) {
            control.redrawPlayingMode();
        }
    }

    public void createSyncProcesses() {
        this.redrawProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGTabEventListener.this.redraw();
            }
        });
        this.redrawPlayModeProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGTabEventListener.this.redrawPlayingMode();
            }
        });
    }

    public void processRedrawEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("redrawMode");
        if (type == 1) {
            this.redrawProcess.process();
        } else if (type == 3) {
            this.redrawPlayModeProcess.process();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-redraw".equals(event.getEventType())) {
            this.processRedrawEvent(event);
        }
    }
}

