/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.tab;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.keybindings.KeyBindingActionManager;
import org.herac.tuxguitar.app.transport.TGTransport;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.component.tab.TGControlPaintListener;
import org.herac.tuxguitar.app.view.component.tab.Tablature;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.util.TGBufferedPainterListenerLocked;
import org.herac.tuxguitar.graphics.control.TGBeatImpl;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UIFocusEvent;
import org.herac.tuxguitar.ui.event.UIFocusGainedListener;
import org.herac.tuxguitar.ui.event.UIMouseDownListener;
import org.herac.tuxguitar.ui.event.UIMouseDragListener;
import org.herac.tuxguitar.ui.event.UIMouseExitListener;
import org.herac.tuxguitar.ui.event.UIMouseMoveListener;
import org.herac.tuxguitar.ui.event.UIMouseUpListener;
import org.herac.tuxguitar.ui.event.UIPaintListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.event.UIZoomListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIPainter;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.widget.UICanvas;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIScrollBar;
import org.herac.tuxguitar.ui.widget.UIScrollBarPanel;
import org.herac.tuxguitar.util.TGContext;

public class TGControl {
    private static final int SCROLL_INCREMENT = 50;
    private TGContext context;
    private UIScrollBarPanel container;
    private UICanvas canvas;
    private UIScrollBar hScroll;
    private UIScrollBar vScroll;
    private Tablature tablature;
    private int width;
    private int height;
    private int scrollX;
    private int scrollY;
    private int lastScrollX;
    private int lastScrollY;
    private TGMeasureImpl lastPaintedPlayedMeasure = null;
    private TGBeatImpl lastPaintedPLayedBeat = null;
    private float lastCanvasWidth;
    private float lastCanvasHeight;
    private float lastScale;
    private int lastLayoutStyle;
    private int lastLayoutMode;
    private boolean painting;
    private boolean wasPlaying;

    public TGControl(TGContext context, UIContainer parent) {
        this.context = context;
        this.tablature = TablatureEditor.getInstance(this.context).getTablature();
        this.initialize(parent);
    }

    private void initialize(UIContainer parent) {
        UIFactory factory = TGApplication.getInstance(this.context).getFactory();
        UITableLayout layout = new UITableLayout(Float.valueOf(0.0f));
        this.container = factory.createScrollBarPanel(parent, true, true, false);
        this.container.setLayout((UILayout)layout);
        this.container.addFocusGainedListener(new UIFocusGainedListener(){

            public void onFocusGained(UIFocusEvent event) {
                TGControl.this.setFocus();
            }
        });
        this.canvas = factory.createCanvas((UIContainer)this.container, false);
        this.hScroll = this.container.getHScroll();
        this.vScroll = this.container.getVScroll();
        this.canvas.addPaintListener((UIPaintListener)new TGBufferedPainterListenerLocked(this.context, new TGControlPaintListener(this)));
        this.canvas.addMouseDownListener((UIMouseDownListener)this.tablature.getEditorKit().getMouseKit());
        this.canvas.addMouseUpListener((UIMouseUpListener)this.tablature.getEditorKit().getMouseKit());
        this.canvas.addMouseMoveListener((UIMouseMoveListener)this.tablature.getEditorKit().getMouseKit());
        this.canvas.addMouseExitListener((UIMouseExitListener)this.tablature.getEditorKit().getMouseKit());
        this.canvas.addMouseDragListener((UIMouseDragListener)this.tablature.getEditorKit().getMouseKit());
        this.canvas.addZoomListener((UIZoomListener)this.tablature.getEditorKit().getMouseKit());
        this.hScroll.setIncrement(50);
        this.hScroll.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGControl.this.redraw();
            }
        });
        this.vScroll.setIncrement(50);
        this.vScroll.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGControl.this.redraw();
            }
        });
        KeyBindingActionManager.getInstance(this.context).appendListenersTo((UIControl)this.canvas);
        this.canvas.setPopupMenu(TuxGuitar.getInstance().getItemManager().getPopupMenu());
        this.canvas.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGControl.this.canvas.setPopupMenu(null);
            }
        });
        layout.set((UIControl)this.canvas, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
    }

    public void paintTablature(UIPainter painter) {
        boolean moved = false;
        TGMeasureImpl playedMeasure = null;
        this.painting = true;
        try {
            TGBeatImpl playedBeat;
            boolean isPlaying = MidiPlayer.getInstance((TGContext)this.context).isRunning();
            float canvasWidth = this.canvas.getBounds().getWidth();
            float canvasHeight = this.canvas.getBounds().getHeight();
            float scale = this.tablature.getScale().floatValue();
            if (isPlaying) {
                playedMeasure = TGTransport.getInstance(this.context).getCache().getPlayMeasure();
                this.scrollX = this.hScroll.getValue();
                this.scrollY = this.vScroll.getValue();
                if (this.scrollX == this.lastScrollX && this.scrollY == this.lastScrollY && playedMeasure != null && playedMeasure.hasTrack(this.tablature.getCaret().getTrack().getNumber())) {
                    this.moveTo(playedMeasure);
                }
            } else if (!this.wasPlaying) {
                if (this.tablature.getCaret().hasChanges()) {
                    this.tablature.getCaret().setChanges(false);
                    this.moveTo(this.tablature.getCaret().getMeasure());
                    moved = true;
                } else {
                    this.scrollX = this.hScroll.getValue();
                    this.scrollY = this.vScroll.getValue();
                }
            }
            if (!isPlaying || this.scrollX != this.lastScrollX || this.scrollY != this.lastScrollY || playedMeasure != this.lastPaintedPlayedMeasure || canvasWidth != this.lastCanvasWidth || canvasHeight != this.lastCanvasHeight || scale != this.lastScale || this.tablature.getViewLayout().getStyle() != this.lastLayoutStyle || this.tablature.getViewLayout().getMode() != this.lastLayoutMode) {
                int lastWidth = this.width;
                int lastHeight = this.height;
                this.tablature.paintTablature(painter, this.canvas.getBounds(), -this.scrollX, -this.scrollY);
                this.width = Math.round(this.tablature.getViewLayout().getWidth());
                this.height = Math.round(this.tablature.getViewLayout().getHeight());
                this.lastPaintedPlayedMeasure = playedMeasure;
                if (moved && scale != this.lastScale || lastWidth != this.width || lastHeight != this.height) {
                    this.moveTo(this.tablature.getCaret().getMeasure());
                    this.tablature.paintTablature(painter, this.canvas.getBounds(), -this.scrollX, -this.scrollY);
                }
            }
            if (playedMeasure != null && playedMeasure.hasTrack(this.tablature.getCaret().getTrack().getNumber()) && !playedMeasure.isOutOfBounds() && (playedBeat = TGTransport.getInstance(this.context).getCache().getPlayBeat()) != this.lastPaintedPLayedBeat) {
                this.tablature.getViewLayout().paintPlayMode(painter, playedMeasure, playedBeat);
                this.lastPaintedPLayedBeat = playedBeat;
            }
            this.updateScrollBars();
            if (this.wasPlaying || moved) {
                this.hScroll.setValue(this.scrollX);
                this.vScroll.setValue(this.scrollY);
            }
            this.lastScale = scale;
            this.lastCanvasWidth = canvasWidth;
            this.lastCanvasHeight = canvasHeight;
            this.lastScrollX = this.scrollX;
            this.lastScrollY = this.scrollY;
            if (!isPlaying) {
                this.lastPaintedPlayedMeasure = null;
                this.lastPaintedPLayedBeat = null;
            }
            this.lastLayoutStyle = this.tablature.getViewLayout().getStyle();
            this.lastLayoutMode = this.tablature.getViewLayout().getMode();
            this.wasPlaying = isPlaying;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.painting = false;
    }

    private void updateScrollBars() {
        UIRectangle bounds = this.canvas.getBounds();
        int hMax = Math.max(Math.round((float)this.width - bounds.getWidth()), 0);
        int hThumb = Math.round(bounds.getWidth());
        if (hMax > 0) {
            this.hScroll.setVisible(true);
            if (this.hScroll.getMaximum() != hMax) {
                this.hScroll.setMaximum(hMax);
            }
            if (this.hScroll.getThumb() != hThumb) {
                this.hScroll.setThumb(hThumb);
            }
        } else {
            this.hScroll.setVisible(false);
            this.scrollX = 0;
        }
        int vMax = Math.max(Math.round((float)this.height - bounds.getHeight()), 0);
        int vThumb = Math.round(bounds.getHeight());
        if (vMax > 0) {
            this.vScroll.setVisible(true);
            if (this.vScroll.getMaximum() != vMax) {
                this.vScroll.setMaximum(vMax);
            }
            if (this.vScroll.getThumb() != vThumb) {
                this.vScroll.setThumb(vThumb);
            }
        } else {
            this.vScroll.setVisible(false);
            this.scrollY = 0;
        }
    }

    private void moveTo(TGMeasureImpl measure) {
        if (measure != null && measure.getTs() != null) {
            Integer vScrollValue;
            int mX = Math.round(measure.getPosX());
            int mY = Math.round(measure.getPosY());
            int mWidth = Math.round(measure.getWidth(this.tablature.getViewLayout()));
            int mHeight = Math.round(measure.getTs().getSize());
            int marginWidth = Math.round(this.tablature.getViewLayout().getFirstMeasureSpacing());
            int marginHeight = Math.round(this.tablature.getViewLayout().getFirstTrackSpacing());
            boolean playMode = MidiPlayer.getInstance((TGContext)this.context).isRunning();
            Integer hScrollValue = this.computeScrollValue(this.scrollX, mX, mWidth, marginWidth, Math.round(this.canvas.getBounds().getWidth()), this.width, playMode);
            if (hScrollValue != null) {
                this.scrollX = hScrollValue;
            }
            if ((vScrollValue = this.computeScrollValue(this.scrollY, mY, mHeight, marginHeight, Math.round(this.canvas.getBounds().getHeight()), this.height, playMode)) != null) {
                this.scrollY = vScrollValue;
            }
        }
    }

    private Integer computeScrollValue(int scrollPos, int mPos, int mSize, int mMargin, int areaSize, int fullSize, boolean playMode) {
        Integer value = null;
        if (mPos < 0 && (areaSize >= mSize + mMargin || mPos + mSize - mMargin <= 0)) {
            value = scrollPos + mPos - mMargin;
        } else if (mPos + mSize > areaSize && (areaSize >= mSize + mMargin || mPos > areaSize)) {
            value = scrollPos + mPos + mSize + mMargin - areaSize;
            if (playMode) {
                value = value + Math.min(fullSize - (scrollPos + mPos + mSize + mMargin), areaSize - mSize - mMargin * 2);
            }
        }
        return value != null ? Integer.valueOf(Math.max(value, 0)) : null;
    }

    public void setFocus() {
        if (!this.isDisposed()) {
            this.canvas.setFocus();
        }
    }

    public void redraw() {
        if (!this.isDisposed()) {
            this.painting = true;
            this.canvas.redraw();
        }
    }

    public void redrawPlayingMode() {
        if (!this.isDisposed() && !this.painting && MidiPlayer.getInstance((TGContext)this.context).isRunning()) {
            this.redraw();
        }
    }

    public UICanvas getCanvas() {
        return this.canvas;
    }

    public boolean isDisposed() {
        return this.container == null || this.container.isDisposed() || this.canvas == null || this.canvas.isDisposed();
    }
}

