/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.tab;

import java.util.ArrayList;
import java.util.Collection;
import org.herac.tuxguitar.app.document.TGDocument;
import org.herac.tuxguitar.app.document.TGDocumentListManager;
import org.herac.tuxguitar.app.view.component.tab.Tablature;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGTrackImpl;
import org.herac.tuxguitar.song.helpers.TGBeatRangeIterator;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.ui.resource.UIPainter;
import org.herac.tuxguitar.util.TGBeatRange;
import org.herac.tuxguitar.util.TGNoteRange;

public class Selector {
    private final Tablature tablature;
    private TGBeat initial;
    private TGBeat start;
    private TGBeat end;
    private boolean active;

    public Selector(Tablature tablature) {
        this.tablature = tablature;
    }

    public void initializeSelection(TGBeat beat) {
        this.initial = beat;
        this.start = beat;
        this.end = beat;
        this.active = false;
        this.saveState();
    }

    public void updateSelection(TGBeat beat) {
        if (this.initial == null || beat == null) {
            this.initializeSelection(beat);
        } else {
            this.active = true;
            if (this.initial.getMeasure().getNumber() < beat.getMeasure().getNumber() || this.initialIsEarlierInTheSameMeasure(beat)) {
                this.start = this.initial;
                this.end = beat;
            } else {
                this.start = beat;
                this.end = this.initial;
            }
            this.saveState();
        }
    }

    public void clearSelection() {
        this.initializeSelection(null);
    }

    private boolean initialIsEarlierInTheSameMeasure(TGBeat beat) {
        return this.initial.getMeasure().getNumber() == beat.getMeasure().getNumber() && this.initial.getStart() < beat.getStart();
    }

    public TGBeat getInitialBeat() {
        return this.initial;
    }

    public TGBeat getStartBeat() {
        return this.start;
    }

    public TGBeat getEndBeat() {
        return this.end;
    }

    public boolean isActive() {
        return this.active;
    }

    public void paintSelectedArea(TGLayout viewLayout, UIPainter painter) {
        if (this.isActive()) {
            int activeTrackNumber = this.tablature.getTrackSelection();
            TGTrackImpl track = (TGTrackImpl)this.initial.getMeasure().getTrack();
            if (activeTrackNumber < 0 || activeTrackNumber == track.getNumber()) {
                track.paintBeatSelection(viewLayout, painter, this.start, this.end);
            }
        }
    }

    public TGNoteRange getNoteRange(Collection<Integer> voices) {
        return new TGNoteRange(this.start, this.end, voices);
    }

    public TGBeatRange getBeatRange() {
        if (!this.isActive()) {
            return TGBeatRange.empty();
        }
        ArrayList<TGBeat> beats = new ArrayList<TGBeat>();
        TGBeatRangeIterator it = new TGBeatRangeIterator(this.start, this.end);
        while (it.hasNext()) {
            beats.add(it.next());
        }
        return new TGBeatRange(beats);
    }

    private void saveState() {
        TGDocument document;
        TGDocumentListManager documents = TGDocumentListManager.getInstance(this.tablature.getContext());
        TGDocument tGDocument = document = this.initial == null ? documents.findCurrentDocument() : documents.findDocument(this.initial.getMeasure().getTrack().getSong());
        if (this.isActive()) {
            document.setSelectionStart(this.getStartBeat());
            document.setSelectionEnd(this.getEndBeat());
        } else {
            document.setSelectionStart(null);
            document.setSelectionEnd(null);
        }
    }

    public void restoreStateFrom(TGDocument document) {
        TGBeat start = document.getSelectionStart();
        TGBeat end = document.getSelectionEnd();
        if (start != null && end != null) {
            this.initializeSelection(start);
            this.updateSelection(end);
        } else {
            this.clearSelection();
        }
    }
}

