/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.util;

import org.herac.tuxguitar.app.util.TGContinuousControl;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TGContinousControlSelectionListener
implements UISelectionListener,
Runnable {
    private static final int DEFAULT_STABILIZATION_DELAY_MS = 500;
    private long stabilizationDelayMs;
    private TGContinuousControl control;
    private long startTime;
    private boolean running;
    private Object mutex = new Object();

    public TGContinousControlSelectionListener(TGContinuousControl control, int stabilisationDelayMs) {
        this.control = control;
        this.stabilizationDelayMs = stabilisationDelayMs;
    }

    public TGContinousControlSelectionListener(TGContinuousControl control) {
        this(control, 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSelect(UISelectionEvent event) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                Thread thread = new Thread(this);
                thread.start();
            }
            this.startTime = System.currentTimeMillis();
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long timeToWait = this.stabilizationDelayMs;
            while (this.running) {
                Object object = this.mutex;
                synchronized (object) {
                    timeToWait = this.startTime + this.stabilizationDelayMs - System.currentTimeMillis();
                    boolean bl = this.running = timeToWait > 0L;
                    if (this.running) {
                        this.mutex.wait(timeToWait);
                    }
                }
            }
            this.doActionSynchronized();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void doActionSynchronized() throws Throwable {
        TGSynchronizer.getInstance((TGContext)this.control.getContext()).executeLater(new Runnable(){

            @Override
            public void run() throws TGException {
                TGContinousControlSelectionListener.this.doAction();
            }
        });
    }

    private void doAction() {
        this.control.doActionWhenStable();
    }
}

