/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.util;

import org.herac.tuxguitar.document.TGDocumentManager;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.player.base.MidiRepeatController;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class MidiTickUtil {
    public static long getStart(TGContext context, long tick) {
        long startPoint;
        long start = startPoint = MidiTickUtil.getStartPoint(context);
        long length = 0L;
        TGSong song = TGDocumentManager.getInstance((TGContext)context).getSong();
        MidiRepeatController controller = new MidiRepeatController(song, MidiTickUtil.getSHeader(context), MidiTickUtil.getEHeader(context));
        while (!controller.finished()) {
            TGMeasureHeader header = song.getMeasureHeader(controller.getIndex());
            controller.process();
            if (!controller.shouldPlay() || tick < (start += (length = header.getLength())) || tick >= start + length) continue;
            return header.getStart() + (tick - start);
        }
        return tick < startPoint ? startPoint : start;
    }

    public static long getTick(TGContext context, long start) {
        long startPoint;
        long tick = startPoint = MidiTickUtil.getStartPoint(context);
        long length = 0L;
        TGSong song = TGDocumentManager.getInstance((TGContext)context).getSong();
        MidiRepeatController controller = new MidiRepeatController(song, MidiTickUtil.getSHeader(context), MidiTickUtil.getEHeader(context));
        while (!controller.finished()) {
            TGMeasureHeader header = song.getMeasureHeader(controller.getIndex());
            controller.process();
            if (!controller.shouldPlay()) continue;
            tick += length;
            length = header.getLength();
            if (start < header.getStart() || start >= header.getStart() + length) continue;
            return tick;
        }
        return start < startPoint ? startPoint : tick;
    }

    private static long getStartPoint(TGContext context) {
        MidiPlayer midiPlayer = MidiPlayer.getInstance((TGContext)context);
        midiPlayer.updateLoop(false);
        return midiPlayer.getLoopSPosition();
    }

    public static int getSHeader(TGContext context) {
        return MidiPlayer.getInstance((TGContext)context).getLoopSHeader();
    }

    public static int getEHeader(TGContext context) {
        return MidiPlayer.getInstance((TGContext)context).getLoopEHeader();
    }
}

