/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.browser.filesystem;

import java.io.File;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserFactorySettingsHandler;
import org.herac.tuxguitar.app.tools.browser.filesystem.TGBrowserSettingsModel;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.app.view.dialog.browser.main.TGBrowserDialog;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.chooser.UIDirectoryChooser;
import org.herac.tuxguitar.ui.chooser.UIDirectoryChooserHandler;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UITextField;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

public class TGBrowserDataDialog {
    private TGContext context;
    private TGBrowserFactorySettingsHandler handler;

    public TGBrowserDataDialog(TGContext context, TGBrowserFactorySettingsHandler handler) {
        this.context = context;
        this.handler = handler;
    }

    public void open() {
        TGBrowserDialog browser = TGBrowserDialog.getInstance(this.context);
        this.open(!browser.isDisposed() ? browser.getWindow() : TGWindow.getInstance(this.context).getWindow());
    }

    public void open(UIWindow parent) {
        final UIFactory uiFactory = TGApplication.getInstance(this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(parent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("browser.collection.fs.editor-title"));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty("browser.collection.fs.editor-tip"));
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(420.0f), null, null);
        UILabel titleLabel = uiFactory.createLabel((UIContainer)group);
        titleLabel.setText(TuxGuitar.getProperty("browser.collection.fs.name") + ":");
        groupLayout.set((UIControl)titleLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField titleValue = uiFactory.createTextField((UIContainer)group);
        groupLayout.set((UIControl)titleValue, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
        UILabel pathLabel = uiFactory.createLabel((UIContainer)group);
        pathLabel.setText(TuxGuitar.getProperty("browser.collection.fs.path") + ":");
        groupLayout.set((UIControl)pathLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField pathValue = uiFactory.createTextField((UIContainer)group);
        groupLayout.set((UIControl)pathValue, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UIButton pathChooser = uiFactory.createButton((UIContainer)group);
        pathChooser.setImage(TuxGuitar.getInstance().getIconManager().getFileOpen());
        pathChooser.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGBrowserDataDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                String defaultPath = pathValue.getText();
                UIDirectoryChooser chooser = uiFactory.createDirectoryChooser(dialog);
                chooser.setDefaultPath(defaultPath != null ? new File(defaultPath) : null);
                chooser.choose(new UIDirectoryChooserHandler(){

                    public void onSelectDirectory(File file) {
                        if (file != null) {
                            pathValue.setText(file.getAbsolutePath());
                        }
                    }
                });
            }
        });
        groupLayout.set((UIControl)pathChooser, Integer.valueOf(2), Integer.valueOf(3), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGBrowserDataDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                String selectedTitle = titleValue.getText();
                String selectedPath = pathValue.getText();
                if (!this.this$0.isValidPath(selectedPath)) {
                    TGMessageDialogUtil.errorMessage(this.this$0.context, dialog, TuxGuitar.getProperty("browser.collection.fs.invalid-path"));
                    return;
                }
                if (this.this$0.isBlank(selectedTitle)) {
                    selectedTitle = selectedPath;
                }
                dialog.dispose();
                this.this$0.handler.onCreateSettings(new TGBrowserSettingsModel(selectedTitle, selectedPath).toBrowserSettings());
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGBrowserDataDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(dialog, 5);
    }

    public boolean isBlank(String s) {
        return s == null || s.length() == 0;
    }

    public boolean isValidPath(String path) {
        if (!this.isBlank(path)) {
            File file = new File(path);
            return file.exists() && file.isDirectory();
        }
        return false;
    }
}

