/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.system.icons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.herac.tuxguitar.app.system.icons.TGIconTheme;
import org.herac.tuxguitar.app.system.icons.TGSkinManager;
import org.herac.tuxguitar.app.util.TGFileUtils;
import org.herac.tuxguitar.song.models.TGDivisionType;
import org.herac.tuxguitar.ui.resource.UIImage;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGIconManager {
    private TGContext context;
    private TGIconTheme theme;
    private Map<String, TGIconTheme> themeCache;
    private UIImage[] durations;
    private UIImage editCut;
    private UIImage editCopy;
    private UIImage editPaste;
    private UIImage editRepeat;
    private UIImage editUndo;
    private UIImage editRedo;
    private UIImage editVoice1;
    private UIImage editVoice2;
    private UIImage editModeSelection;
    private UIImage editModeEdition;
    private UIImage editModeEditionNotNatural;
    private UIImage helpDoc;
    private UIImage helpAbout;
    private UIImage goHome;
    private UIImage layoutPage;
    private UIImage layoutLinear;
    private UIImage layoutMultitrack;
    private UIImage layoutScore;
    private UIImage layoutTablature;
    private UIImage layoutCompact;
    private UIImage layoutHighlightPlayedBeat;
    private UIImage transport;
    private UIImage transportFirst;
    private UIImage transportLast;
    private UIImage transportPrevious;
    private UIImage transportNext;
    private UIImage transportStop;
    private UIImage transportPlay;
    private UIImage transportPause;
    private UIImage transportIconFirst;
    private UIImage transportIconLast;
    private UIImage transportIconPrevious;
    private UIImage transportIconNext;
    private UIImage transportIconStop;
    private UIImage transportIconPlay;
    private UIImage transportIconPause;
    private UIImage transportMetronome;
    private UIImage transportCountIn;
    private UIImage transportMode;
    private UIImage transportLoopStart;
    private UIImage transportLoopEnd;
    private UIImage markerList;
    private UIImage marker;
    private UIImage markerAdd;
    private UIImage markerFirst;
    private UIImage markerLast;
    private UIImage markerPrevious;
    private UIImage markerNext;
    private UIImage measureFirst;
    private UIImage measureLast;
    private UIImage measurePrevious;
    private UIImage measureNext;
    private UIImage measureAdd;
    private UIImage measureClean;
    private UIImage measureRemove;
    private UIImage measureCopy;
    private UIImage measurePaste;
    private UIImage aboutDescription;
    private UIImage aboutLicense;
    private UIImage aboutAuthors;
    private UIImage appIcon;
    private UIImage appSplash;
    private UIImage optionMain;
    private UIImage optionStyle;
    private UIImage optionSound;
    private UIImage optionLanguage;
    private UIImage optionSkin;
    private UIImage trackFirst;
    private UIImage trackLast;
    private UIImage trackPrevious;
    private UIImage trackNext;
    private UIImage trackAdd;
    private UIImage trackClone;
    private UIImage trackRemove;
    private UIImage trackSolo;
    private UIImage trackMute;
    private UIImage fretboard;
    private UIImage fretboardFirstFret;
    private UIImage fretboardFret;
    private UIImage fretboardSmaller;
    private UIImage fretboardBigger;
    private UIImage compositionTimeSignature;
    private UIImage compositionTempo;
    private UIImage compositionClef;
    private UIImage compositionKeySignature;
    private UIImage compositionTripletFeel;
    private UIImage compositionRepeatOpen;
    private UIImage compositionRepeatClose;
    private UIImage compositionRepeatAlternative;
    private UIImage songProperties;
    private UIImage durationDotted;
    private UIImage durationDoubleDotted;
    private Map<Integer, UIImage> divisionTypes;
    private UIImage fileNew;
    private UIImage fileOpen;
    private UIImage fileClose;
    private UIImage fileSave;
    private UIImage fileSaveAs;
    private UIImage fileImport;
    private UIImage fileExport;
    private UIImage filePrint;
    private UIImage filePrintPreview;
    private UIImage fileHistory;
    private UIImage fileExit;
    private UIImage chord;
    private UIImage text;
    private UIImage noteTied;
    private UIImage instruments;
    private UIImage matrix;
    private UIImage piano;
    private UIImage dynamicPPP;
    private UIImage dynamicPP;
    private UIImage dynamicP;
    private UIImage dynamicMP;
    private UIImage dynamicMF;
    private UIImage dynamicF;
    private UIImage dynamicFF;
    private UIImage dynamicFFF;
    private UIImage effectDead;
    private UIImage effectGhost;
    private UIImage effectAccentuated;
    private UIImage effectHeavyAccentuated;
    private UIImage effectLetRing;
    private UIImage effectHarmonic;
    private UIImage effectGrace;
    private UIImage effectBend;
    private UIImage effectTremoloBar;
    private UIImage effectSlide;
    private UIImage effectHammer;
    private UIImage effectVibrato;
    private UIImage effectTrill;
    private UIImage effectTremoloPicking;
    private UIImage effectPalmMute;
    private UIImage effectStaccato;
    private UIImage effectTapping;
    private UIImage effectSlapping;
    private UIImage effectPopping;
    private UIImage effectFadeIn;
    private UIImage browserNew;
    private UIImage browserFile;
    private UIImage browserFolder;
    private UIImage browserFolderRemote;
    private UIImage browserCollection;
    private UIImage browserRoot;
    private UIImage browserBack;
    private UIImage browserRefresh;
    private UIImage arrowUp;
    private UIImage arrowDown;
    private UIImage arrowLeft;
    private UIImage arrowRight;
    private UIImage statusQuestion;
    private UIImage statusError;
    private UIImage statusWarning;
    private UIImage statusInfo;
    private UIImage strokeUp;
    private UIImage strokeDown;
    private UIImage settings;
    private UIImage toolbarMain;
    private UIImage toolbarEdit;
    private UIImage tableViewer;
    private UIImage listAdd;
    private UIImage listEdit;
    private UIImage listRemove;
    private UIImage solo;
    private UIImage soloDisabled;
    private UIImage soloDim;
    private UIImage soloDisabledDim;
    private UIImage toolsPlugins;
    private UIImage toolsShortcuts;
    private UIImage toolsSettings;
    private UIImage mute;
    private UIImage muteDisabled;
    private UIImage muteDim;
    private UIImage muteDisabledDim;
    private UIImage listMoveUp;
    private UIImage listMoveDown;
    private UIImage zoomOut;
    private UIImage zoomReset;
    private UIImage zoomIn;

    private TGIconManager(TGContext context) {
        this.context = context;
        this.themeCache = new HashMap<String, TGIconTheme>();
        this.loadIcons();
    }

    public TGIconTheme findIconTheme(String theme) {
        if (this.themeCache.containsKey(theme)) {
            return this.themeCache.get(theme);
        }
        this.themeCache.put(theme, new TGIconTheme(theme));
        return this.findIconTheme(theme);
    }

    public String findConfiguredThemeName() {
        return TGSkinManager.getInstance(this.context).getCurrentSkin();
    }

    public void loadIcons() {
        this.theme = this.findIconTheme(this.findConfiguredThemeName());
        this.durations = new UIImage[]{this.loadIcon("1.png"), this.loadIcon("2.png"), this.loadIcon("4.png"), this.loadIcon("8.png"), this.loadIcon("16.png"), this.loadIcon("32.png"), this.loadIcon("64.png")};
        this.layoutPage = this.loadIcon("layout_page.png");
        this.layoutLinear = this.loadIcon("layout_linear.png");
        this.layoutMultitrack = this.loadIcon("layout_multitrack.png");
        this.layoutScore = this.loadIcon("layout_score.png");
        this.layoutTablature = this.loadIcon("layout_tablature.png");
        this.layoutCompact = this.loadIcon("layout_compact.png");
        this.layoutHighlightPlayedBeat = this.loadIcon("highlight_played_beat.png");
        this.fileNew = this.loadIcon("new.png");
        this.fileOpen = this.loadIcon("open.png");
        this.fileClose = this.loadIcon("close.png");
        this.fileSave = this.loadIcon("save.png");
        this.fileSaveAs = this.loadIcon("save-as.png");
        this.fileImport = this.loadIcon("import.png");
        this.fileExport = this.loadIcon("export.png");
        this.filePrint = this.loadIcon("print.png");
        this.filePrintPreview = this.loadIcon("print-preview.png");
        this.fileHistory = this.loadIcon("history.png");
        this.fileExit = this.loadIcon("exit.png");
        this.editCut = this.loadIcon("edit_cut.png");
        this.editCopy = this.loadIcon("edit_copy.png");
        this.editPaste = this.loadIcon("edit_paste.png");
        this.editRepeat = this.loadIcon("edit_repeat.png");
        this.editUndo = this.loadIcon("edit_undo.png");
        this.editRedo = this.loadIcon("edit_redo.png");
        this.editVoice1 = this.loadIcon("edit_voice_1.png");
        this.editVoice2 = this.loadIcon("edit_voice_2.png");
        this.editModeSelection = this.loadIcon("edit_mode_selection.png");
        this.editModeEdition = this.loadIcon("edit_mode_edition.png");
        this.editModeEditionNotNatural = this.loadIcon("edit_mode_edition_no_natural.png");
        this.helpDoc = this.loadIcon("help_doc.png");
        this.helpAbout = this.loadIcon("help_about.png");
        this.goHome = this.loadIcon("browser_root.png");
        this.appIcon = this.loadIcon("icon.png");
        this.appSplash = this.loadIcon("splash.png");
        this.aboutDescription = this.loadIcon("about_description.png");
        this.aboutLicense = this.loadIcon("about_license.png");
        this.aboutAuthors = this.loadIcon("about_authors.png");
        this.optionMain = this.loadIcon("option_view.png");
        this.optionStyle = this.loadIcon("option_style.png");
        this.optionSound = this.loadIcon("option_sound.png");
        this.optionSkin = this.loadIcon("option_skin.png");
        this.optionLanguage = this.loadIcon("option_language.png");
        this.compositionTimeSignature = this.loadIcon("timesignature.png");
        this.compositionTempo = this.loadIcon("tempoicon.png");
        this.compositionClef = this.loadIcon("clef.png");
        this.compositionKeySignature = this.loadIcon("keysignature.png");
        this.compositionTripletFeel = this.loadIcon("tripletfeel.png");
        this.compositionRepeatOpen = this.loadIcon("openrepeat.png");
        this.compositionRepeatClose = this.loadIcon("closerepeat.png");
        this.compositionRepeatAlternative = this.loadIcon("repeat_alternative.png");
        this.songProperties = this.loadIcon("song_properties.png");
        this.trackFirst = this.loadIcon("track_first.png");
        this.trackLast = this.loadIcon("track_last.png");
        this.trackPrevious = this.loadIcon("track_previous.png");
        this.trackNext = this.loadIcon("track_next.png");
        this.trackAdd = this.loadIcon("track_add.png");
        this.trackClone = this.loadIcon("track_clone.png");
        this.trackRemove = this.loadIcon("track_remove.png");
        this.trackSolo = this.loadIcon("track_solo.png");
        this.trackMute = this.loadIcon("track_mute.png");
        this.durationDotted = this.loadIcon("dotted.png");
        this.durationDoubleDotted = this.loadIcon("doubledotted.png");
        this.divisionTypes = new HashMap<Integer, UIImage>();
        for (int i = 0; i < TGDivisionType.DIVISION_TYPES.length; ++i) {
            Integer enters = TGDivisionType.DIVISION_TYPES[i].getEnters();
            this.divisionTypes.put(enters, this.loadIcon("division-type-" + String.valueOf(enters) + ".png"));
        }
        this.fretboard = this.loadIcon("fretboard.png");
        this.fretboardFirstFret = this.loadIcon("firstfret.png");
        this.fretboardFret = this.loadIcon("fret.png");
        this.fretboardSmaller = this.loadIcon("fretboard_smaller.png");
        this.fretboardBigger = this.loadIcon("fretboard_bigger.png");
        this.chord = this.loadIcon("chord.png");
        this.text = this.loadIcon("text.png");
        this.noteTied = this.loadIcon("tiednote.png");
        this.transport = this.loadIcon("transport.png");
        this.transportFirst = this.loadIcon("transport_first.png");
        this.transportLast = this.loadIcon("transport_last.png");
        this.transportPrevious = this.loadIcon("transport_previous.png");
        this.transportNext = this.loadIcon("transport_next.png");
        this.transportStop = this.loadIcon("transport_stop.png");
        this.transportPlay = this.loadIcon("transport_play.png");
        this.transportPause = this.loadIcon("transport_pause.png");
        this.transportIconFirst = this.loadIcon("transport_icon_first.png");
        this.transportIconLast = this.loadIcon("transport_icon_last.png");
        this.transportIconPrevious = this.loadIcon("transport_icon_previous.png");
        this.transportIconNext = this.loadIcon("transport_icon_next.png");
        this.transportIconStop = this.loadIcon("transport_icon_stop.png");
        this.transportIconPlay = this.loadIcon("transport_icon_play.png");
        this.transportIconPause = this.loadIcon("transport_icon_pause.png");
        this.transportMetronome = this.loadIcon("transport_metronome.png");
        this.transportCountIn = this.loadIcon("transport_count_in.png");
        this.transportMode = this.loadIcon("transport_mode.png");
        this.transportLoopStart = this.loadIcon("transport_loop_start.png");
        this.transportLoopEnd = this.loadIcon("transport_loop_end.png");
        this.markerList = this.loadIcon("marker_list.png");
        this.marker = this.loadIcon("marker.png");
        this.markerAdd = this.loadIcon("marker_add.png");
        this.markerFirst = this.loadIcon("marker_first.png");
        this.markerLast = this.loadIcon("marker_last.png");
        this.markerPrevious = this.loadIcon("marker_previous.png");
        this.markerNext = this.loadIcon("marker_next.png");
        this.measureFirst = this.loadIcon("measure_first.png");
        this.measureLast = this.loadIcon("measure_last.png");
        this.measurePrevious = this.loadIcon("measure_previous.png");
        this.measureNext = this.loadIcon("measure_next.png");
        this.measureAdd = this.loadIcon("measure_add.png");
        this.measureClean = this.loadIcon("measure_clean.png");
        this.measureRemove = this.loadIcon("measure_remove.png");
        this.measureCopy = this.loadIcon("measure_copy.png");
        this.measurePaste = this.loadIcon("measure_paste.png");
        this.instruments = this.loadIcon("mixer.png");
        this.matrix = this.loadIcon("matrix.png");
        this.piano = this.loadIcon("piano.png");
        this.dynamicPPP = this.loadIcon("dynamic_ppp.png");
        this.dynamicPP = this.loadIcon("dynamic_pp.png");
        this.dynamicP = this.loadIcon("dynamic_p.png");
        this.dynamicMP = this.loadIcon("dynamic_mp.png");
        this.dynamicMF = this.loadIcon("dynamic_mf.png");
        this.dynamicF = this.loadIcon("dynamic_f.png");
        this.dynamicFF = this.loadIcon("dynamic_ff.png");
        this.dynamicFFF = this.loadIcon("dynamic_fff.png");
        this.effectDead = this.loadIcon("effect_dead.png");
        this.effectGhost = this.loadIcon("effect_ghost.png");
        this.effectAccentuated = this.loadIcon("effect_accentuated.png");
        this.effectHeavyAccentuated = this.loadIcon("effect_heavy_accentuated.png");
        this.effectLetRing = this.loadIcon("effect_let_ring.png");
        this.effectHarmonic = this.loadIcon("effect_harmonic.png");
        this.effectGrace = this.loadIcon("effect_grace.png");
        this.effectBend = this.loadIcon("effect_bend.png");
        this.effectTremoloBar = this.loadIcon("effect_tremolo_bar.png");
        this.effectSlide = this.loadIcon("effect_slide.png");
        this.effectHammer = this.loadIcon("effect_hammer.png");
        this.effectVibrato = this.loadIcon("effect_vibrato.png");
        this.effectTrill = this.loadIcon("effect_trill.png");
        this.effectTremoloPicking = this.loadIcon("effect_tremolo_picking.png");
        this.effectPalmMute = this.loadIcon("effect_palm_mute.png");
        this.effectStaccato = this.loadIcon("effect_staccato.png");
        this.effectTapping = this.loadIcon("effect_tapping.png");
        this.effectSlapping = this.loadIcon("effect_slapping.png");
        this.effectPopping = this.loadIcon("effect_popping.png");
        this.effectFadeIn = this.loadIcon("effect_fade_in.png");
        this.browserNew = this.loadIcon("browser_new.png");
        this.browserFile = this.loadIcon("browser_file.png");
        this.browserFolder = this.loadIcon("browser_folder.png");
        this.browserFolderRemote = this.loadIcon("browser_folder_remote.png");
        this.browserCollection = this.loadIcon("browser_collection.png");
        this.browserRoot = this.loadIcon("browser_root.png");
        this.browserBack = this.loadIcon("browser_back.png");
        this.browserRefresh = this.loadIcon("browser_refresh.png");
        this.arrowUp = this.loadIcon("arrow_up.png");
        this.arrowDown = this.loadIcon("arrow_down.png");
        this.arrowLeft = this.loadIcon("arrow_left.png");
        this.arrowRight = this.loadIcon("arrow_right.png");
        this.statusQuestion = this.loadIcon("status_question.png");
        this.statusError = this.loadIcon("status_error.png");
        this.statusWarning = this.loadIcon("status_warning.png");
        this.statusInfo = this.loadIcon("status_info.png");
        this.strokeUp = this.loadIcon("stroke_up.png");
        this.strokeDown = this.loadIcon("stroke_down.png");
        this.settings = this.loadIcon("settings.png");
        this.toolbarMain = this.loadIcon("toolbar_main.png");
        this.toolbarEdit = this.loadIcon("toolbar_edit.png");
        this.tableViewer = this.loadIcon("table_viewer.png");
        this.listAdd = this.loadIcon("list_add.png");
        this.listEdit = this.loadIcon("list_edit.png");
        this.listRemove = this.loadIcon("list_remove.png");
        this.solo = this.loadIcon("solo.png");
        this.soloDisabled = this.loadIcon("solo-disabled.png");
        this.soloDim = this.loadIcon("solo-dim.png");
        this.soloDisabledDim = this.loadIcon("solo-disabled-dim.png");
        this.toolsPlugins = this.loadIcon("tools_plugins.png");
        this.toolsShortcuts = this.loadIcon("tools_shortcuts.png");
        this.toolsSettings = this.loadIcon("tools_settings.png");
        this.mute = this.loadIcon("mute.png");
        this.muteDisabled = this.loadIcon("mute-disabled.png");
        this.muteDim = this.loadIcon("mute-dim.png");
        this.muteDisabledDim = this.loadIcon("mute-disabled-dim.png");
        this.listMoveUp = this.loadIcon("list_move_up.png");
        this.listMoveDown = this.loadIcon("list_move_down.png");
        this.zoomOut = this.loadIcon("zoom_out.png");
        this.zoomReset = this.loadIcon("zoom_original.png");
        this.zoomIn = this.loadIcon("zoom_in.png");
    }

    private UIImage loadIcon(String name) {
        UIImage image = this.theme.getResource(name);
        if (image == null) {
            image = TGFileUtils.loadImage(this.context, this.theme.getName(), name);
            this.theme.setResource(name, image);
        }
        return image;
    }

    public void disposeThemes() {
        ArrayList<String> themes = new ArrayList<String>(this.themeCache.keySet());
        for (String theme : themes) {
            this.disposeTheme(this.themeCache.remove(theme));
        }
    }

    public void disposeTheme(TGIconTheme theme) {
        ArrayList<UIImage> uiImages = new ArrayList<UIImage>(theme.getResources().values());
        for (UIImage uiImage : uiImages) {
            uiImage.dispose();
        }
    }

    public void onSkinDisposed() {
        this.disposeThemes();
    }

    public void onSkinChange() {
        this.loadIcons();
    }

    public UIImage getDuration(int value) {
        switch (value) {
            case 1: {
                return this.durations[0];
            }
            case 2: {
                return this.durations[1];
            }
            case 4: {
                return this.durations[2];
            }
            case 8: {
                return this.durations[3];
            }
            case 16: {
                return this.durations[4];
            }
            case 32: {
                return this.durations[5];
            }
            case 64: {
                return this.durations[6];
            }
        }
        return null;
    }

    public UIImage getAboutAuthors() {
        return this.aboutAuthors;
    }

    public UIImage getAboutDescription() {
        return this.aboutDescription;
    }

    public UIImage getAboutLicense() {
        return this.aboutLicense;
    }

    public UIImage getAppIcon() {
        return this.appIcon;
    }

    public UIImage getAppSplash() {
        return this.appSplash;
    }

    public UIImage getChord() {
        return this.chord;
    }

    public UIImage getText() {
        return this.text;
    }

    public UIImage getCompositionRepeatClose() {
        return this.compositionRepeatClose;
    }

    public UIImage getCompositionRepeatAlternative() {
        return this.compositionRepeatAlternative;
    }

    public UIImage getCompositionRepeatOpen() {
        return this.compositionRepeatOpen;
    }

    public UIImage getCompositionTempo() {
        return this.compositionTempo;
    }

    public UIImage getCompositionClef() {
        return this.compositionClef;
    }

    public UIImage getCompositionKeySignature() {
        return this.compositionKeySignature;
    }

    public UIImage getCompositionTripletFeel() {
        return this.compositionTripletFeel;
    }

    public UIImage getCompositionTimeSignature() {
        return this.compositionTimeSignature;
    }

    public UIImage getDurationDotted() {
        return this.durationDotted;
    }

    public UIImage getDurationDoubleDotted() {
        return this.durationDoubleDotted;
    }

    public UIImage getDivisionType(int divisionTypeEnters) {
        return this.divisionTypes.get(divisionTypeEnters);
    }

    public UIImage getDynamicF() {
        return this.dynamicF;
    }

    public UIImage getDynamicFF() {
        return this.dynamicFF;
    }

    public UIImage getDynamicFFF() {
        return this.dynamicFFF;
    }

    public UIImage getDynamicMF() {
        return this.dynamicMF;
    }

    public UIImage getDynamicMP() {
        return this.dynamicMP;
    }

    public UIImage getDynamicP() {
        return this.dynamicP;
    }

    public UIImage getDynamicPP() {
        return this.dynamicPP;
    }

    public UIImage getDynamicPPP() {
        return this.dynamicPPP;
    }

    public UIImage getEditModeEdition() {
        return this.editModeEdition;
    }

    public UIImage getEditModeEditionNotNatural() {
        return this.editModeEditionNotNatural;
    }

    public UIImage getEditModeSelection() {
        return this.editModeSelection;
    }

    public UIImage getEditCut() {
        return this.editCut;
    }

    public UIImage getEditCopy() {
        return this.editCopy;
    }

    public UIImage getEditPaste() {
        return this.editPaste;
    }

    public UIImage getEditRepeat() {
        return this.editRepeat;
    }

    public UIImage getEditRedo() {
        return this.editRedo;
    }

    public UIImage getEditUndo() {
        return this.editUndo;
    }

    public UIImage getEditVoice1() {
        return this.editVoice1;
    }

    public UIImage getEditVoice2() {
        return this.editVoice2;
    }

    public UIImage getHelpDoc() {
        return this.helpDoc;
    }

    public UIImage getHelpAbout() {
        return this.helpAbout;
    }

    public UIImage getGoHome() {
        return this.goHome;
    }

    public UIImage getEffectAccentuated() {
        return this.effectAccentuated;
    }

    public UIImage getEffectBend() {
        return this.effectBend;
    }

    public UIImage getEffectDead() {
        return this.effectDead;
    }

    public UIImage getEffectFadeIn() {
        return this.effectFadeIn;
    }

    public UIImage getEffectGhost() {
        return this.effectGhost;
    }

    public UIImage getEffectGrace() {
        return this.effectGrace;
    }

    public UIImage getEffectHammer() {
        return this.effectHammer;
    }

    public UIImage getEffectHarmonic() {
        return this.effectHarmonic;
    }

    public UIImage getEffectHeavyAccentuated() {
        return this.effectHeavyAccentuated;
    }

    public UIImage getEffectLetRing() {
        return this.effectLetRing;
    }

    public UIImage getEffectPalmMute() {
        return this.effectPalmMute;
    }

    public UIImage getEffectPopping() {
        return this.effectPopping;
    }

    public UIImage getEffectSlapping() {
        return this.effectSlapping;
    }

    public UIImage getEffectSlide() {
        return this.effectSlide;
    }

    public UIImage getEffectStaccato() {
        return this.effectStaccato;
    }

    public UIImage getEffectTapping() {
        return this.effectTapping;
    }

    public UIImage getEffectTremoloBar() {
        return this.effectTremoloBar;
    }

    public UIImage getEffectTremoloPicking() {
        return this.effectTremoloPicking;
    }

    public UIImage getEffectTrill() {
        return this.effectTrill;
    }

    public UIImage getEffectVibrato() {
        return this.effectVibrato;
    }

    public UIImage getFileNew() {
        return this.fileNew;
    }

    public UIImage getFileOpen() {
        return this.fileOpen;
    }

    public UIImage getFileClose() {
        return this.fileClose;
    }

    public UIImage getFilePrint() {
        return this.filePrint;
    }

    public UIImage getFilePrintPreview() {
        return this.filePrintPreview;
    }

    public UIImage getFileHistory() {
        return this.fileHistory;
    }

    public UIImage getFileExit() {
        return this.fileExit;
    }

    public UIImage getFileSave() {
        return this.fileSave;
    }

    public UIImage getFileSaveAs() {
        return this.fileSaveAs;
    }

    public UIImage getFileImport() {
        return this.fileImport;
    }

    public UIImage getFileExport() {
        return this.fileExport;
    }

    public UIImage getFretboard() {
        return this.fretboard;
    }

    public UIImage getFretboardFirstFret() {
        return this.fretboardFirstFret;
    }

    public UIImage getFretboardFret() {
        return this.fretboardFret;
    }

    public UIImage getFretboardSmaller() {
        return this.fretboardSmaller;
    }

    public UIImage getFretboardBigger() {
        return this.fretboardBigger;
    }

    public UIImage getLayoutLinear() {
        return this.layoutLinear;
    }

    public UIImage getLayoutMultitrack() {
        return this.layoutMultitrack;
    }

    public UIImage getLayoutPage() {
        return this.layoutPage;
    }

    public UIImage getLayoutScore() {
        return this.layoutScore;
    }

    public UIImage getLayoutTablature() {
        return this.layoutTablature;
    }

    public UIImage getLayoutCompact() {
        return this.layoutCompact;
    }

    public UIImage getLayoutHighlightPlayedBeat() {
        return this.layoutHighlightPlayedBeat;
    }

    public UIImage getMarkerAdd() {
        return this.markerAdd;
    }

    public UIImage getMarkerFirst() {
        return this.markerFirst;
    }

    public UIImage getMarkerLast() {
        return this.markerLast;
    }

    public UIImage getMarkerList() {
        return this.markerList;
    }

    public UIImage getMarker() {
        return this.marker;
    }

    public UIImage getMarkerPrevious() {
        return this.markerPrevious;
    }

    public UIImage getMarkerNext() {
        return this.markerNext;
    }

    public UIImage getMeasureFirst() {
        return this.measureFirst;
    }

    public UIImage getMeasureLast() {
        return this.measureLast;
    }

    public UIImage getMeasurePrevious() {
        return this.measurePrevious;
    }

    public UIImage getMeasureNext() {
        return this.measureNext;
    }

    public UIImage getMeasureAdd() {
        return this.measureAdd;
    }

    public UIImage getMeasureClean() {
        return this.measureClean;
    }

    public UIImage getMeasureRemove() {
        return this.measureRemove;
    }

    public UIImage getMeasureCopy() {
        return this.measureCopy;
    }

    public UIImage getMeasurePaste() {
        return this.measurePaste;
    }

    public UIImage getInstruments() {
        return this.instruments;
    }

    public UIImage getMatrix() {
        return this.matrix;
    }

    public UIImage getPiano() {
        return this.piano;
    }

    public UIImage getNoteTied() {
        return this.noteTied;
    }

    public UIImage getOptionLanguage() {
        return this.optionLanguage;
    }

    public UIImage getOptionMain() {
        return this.optionMain;
    }

    public UIImage getOptionSound() {
        return this.optionSound;
    }

    public UIImage getOptionStyle() {
        return this.optionStyle;
    }

    public UIImage getOptionSkin() {
        return this.optionSkin;
    }

    public UIImage getSongProperties() {
        return this.songProperties;
    }

    public UIImage getTrackFirst() {
        return this.trackFirst;
    }

    public UIImage getTrackLast() {
        return this.trackLast;
    }

    public UIImage getTrackPrevious() {
        return this.trackPrevious;
    }

    public UIImage getTrackNext() {
        return this.trackNext;
    }

    public UIImage getTrackAdd() {
        return this.trackAdd;
    }

    public UIImage getTrackClone() {
        return this.trackClone;
    }

    public UIImage getTrackRemove() {
        return this.trackRemove;
    }

    public UIImage getTrackSolo() {
        return this.trackSolo;
    }

    public UIImage getTrackMute() {
        return this.trackMute;
    }

    public UIImage getTransport() {
        return this.transport;
    }

    public UIImage getTransportFirst() {
        return this.transportFirst;
    }

    public UIImage getTransportIconFirst() {
        return this.transportIconFirst;
    }

    public UIImage getTransportIconLast() {
        return this.transportIconLast;
    }

    public UIImage getTransportIconNext() {
        return this.transportIconNext;
    }

    public UIImage getTransportIconPause() {
        return this.transportIconPause;
    }

    public UIImage getTransportIconPlay() {
        return this.transportIconPlay;
    }

    public UIImage getTransportIconPrevious() {
        return this.transportIconPrevious;
    }

    public UIImage getTransportIconStop() {
        return this.transportIconStop;
    }

    public UIImage getTransportLast() {
        return this.transportLast;
    }

    public UIImage getTransportNext() {
        return this.transportNext;
    }

    public UIImage getTransportPause() {
        return this.transportPause;
    }

    public UIImage getTransportPlay() {
        return this.transportPlay;
    }

    public UIImage getTransportPrevious() {
        return this.transportPrevious;
    }

    public UIImage getTransportStop() {
        return this.transportStop;
    }

    public UIImage getTransportMetronome() {
        return this.transportMetronome;
    }

    public UIImage getTransportCountIn() {
        return this.transportCountIn;
    }

    public UIImage getTransportMode() {
        return this.transportMode;
    }

    public UIImage getTransportLoopStart() {
        return this.transportLoopStart;
    }

    public UIImage getTransportLoopEnd() {
        return this.transportLoopEnd;
    }

    public UIImage getBrowserBack() {
        return this.browserBack;
    }

    public UIImage getBrowserFile() {
        return this.browserFile;
    }

    public UIImage getBrowserFolder() {
        return this.browserFolder;
    }

    public UIImage getBrowserFolderRemote() {
        return this.browserFolderRemote;
    }

    public UIImage getBrowserCollection() {
        return this.browserCollection;
    }

    public UIImage getBrowserRefresh() {
        return this.browserRefresh;
    }

    public UIImage getBrowserRoot() {
        return this.browserRoot;
    }

    public UIImage getBrowserNew() {
        return this.browserNew;
    }

    public UIImage getStrokeUp() {
        return this.strokeUp;
    }

    public UIImage getStrokeDown() {
        return this.strokeDown;
    }

    public UIImage getSettings() {
        return this.settings;
    }

    public UIImage getToolbarMain() {
        return this.toolbarMain;
    }

    public UIImage getToolbarEdit() {
        return this.toolbarEdit;
    }

    public UIImage getTableViewer() {
        return this.tableViewer;
    }

    public UIImage getArrowUp() {
        return this.arrowUp;
    }

    public UIImage getArrowDown() {
        return this.arrowDown;
    }

    public UIImage getArrowLeft() {
        return this.arrowLeft;
    }

    public UIImage getArrowRight() {
        return this.arrowRight;
    }

    public UIImage getStatusQuestion() {
        return this.statusQuestion;
    }

    public UIImage getStatusError() {
        return this.statusError;
    }

    public UIImage getStatusWarning() {
        return this.statusWarning;
    }

    public UIImage getStatusInfo() {
        return this.statusInfo;
    }

    public UIImage getListAdd() {
        return this.listAdd;
    }

    public UIImage getListEdit() {
        return this.listEdit;
    }

    public UIImage getListRemove() {
        return this.listRemove;
    }

    public UIImage getSolo() {
        return this.solo;
    }

    public UIImage getSoloDisabled() {
        return this.soloDisabled;
    }

    public UIImage getSoloDim() {
        return this.soloDim;
    }

    public UIImage getSoloDisabledDim() {
        return this.soloDisabledDim;
    }

    public UIImage getToolsPlugins() {
        return this.toolsPlugins;
    }

    public UIImage getToolsShortcuts() {
        return this.toolsShortcuts;
    }

    public UIImage getToolsSettings() {
        return this.toolsSettings;
    }

    public UIImage getMute() {
        return this.mute;
    }

    public UIImage getMuteDisabled() {
        return this.muteDisabled;
    }

    public UIImage getMuteDim() {
        return this.muteDim;
    }

    public UIImage getMuteDisabledDim() {
        return this.muteDisabledDim;
    }

    public UIImage getListMoveUp() {
        return this.listMoveUp;
    }

    public UIImage getListMoveDown() {
        return this.listMoveDown;
    }

    public UIImage getZoomOut() {
        return this.zoomOut;
    }

    public UIImage getZoomReset() {
        return this.zoomReset;
    }

    public UIImage getZoomIn() {
        return this.zoomIn;
    }

    public static TGIconManager getInstance(TGContext context) {
        return (TGIconManager)TGSingletonUtil.getInstance((TGContext)context, (String)TGIconManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGIconManager>(){

            public TGIconManager createInstance(TGContext context) {
                return new TGIconManager(context);
            }
        });
    }
}

