/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.system.config;

import java.util.List;
import org.herac.tuxguitar.app.system.config.TGConfigDefaults;
import org.herac.tuxguitar.app.system.properties.TGPropertiesUIUtil;
import org.herac.tuxguitar.ui.resource.UIColorModel;
import org.herac.tuxguitar.ui.resource.UIFontModel;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGVersion;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGConfigManager
extends org.herac.tuxguitar.util.configuration.TGConfigManager {
    public static final String CONFIGURATION_MODULE = "tuxguitar";

    private TGConfigManager(TGContext context, List<String> validKeys) {
        super(context, CONFIGURATION_MODULE, validKeys);
    }

    public void setValue(String key, UIColorModel model) {
        TGPropertiesUIUtil.setValue(this.getProperties(), key, model);
    }

    public void setValue(String key, UIFontModel fm) {
        TGPropertiesUIUtil.setValue(this.getProperties(), key, fm);
    }

    public UIFontModel getFontModelConfigValue(String key) {
        return TGPropertiesUIUtil.getFontModelValue(this.getProperties(), key);
    }

    public UIColorModel getColorModelConfigValue(String key) {
        return TGPropertiesUIUtil.getColorModelValue(this.getContext(), this.getProperties(), key);
    }

    public void save() {
        this.setValue("config.app.version", TGVersion.CURRENT.toString());
        super.save();
    }

    public void load() {
        super.load();
        TGVersion configAppVersion = new TGVersion(this.getStringValue("config.app.version"));
        if (configAppVersion.compareTo(new TGVersion(1, 6, 3)) < 0) {
            int style = this.getIntegerValue("layout.style");
            this.getProperties().setValue("layout.style", String.valueOf(style |= 0x80));
        }
    }

    public static TGConfigManager getInstance(TGContext context) {
        return (TGConfigManager)((Object)TGSingletonUtil.getInstance((TGContext)context, (String)TGConfigManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGConfigManager>(){

            public TGConfigManager createInstance(TGContext context) {
                return new TGConfigManager(context, TGConfigDefaults.getKeys());
            }
        }));
    }
}

