/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.io.persistence;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.action.TGActionInterceptor;
import org.herac.tuxguitar.action.TGActionManager;
import org.herac.tuxguitar.app.io.persistence.TGPersistenceSettingsHandler;
import org.herac.tuxguitar.app.io.persistence.TGPersistenceSettingsInterceptor;
import org.herac.tuxguitar.app.io.persistence.TGPersistenceSettingsMode;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGPersistenceSettingsManager {
    private TGContext context;
    private List<TGPersistenceSettingsHandler> handlers;

    private TGPersistenceSettingsManager(TGContext context) {
        this.context = context;
        this.handlers = new ArrayList<TGPersistenceSettingsHandler>();
        this.appendListeners();
    }

    public TGContext getContext() {
        return this.context;
    }

    public void addSettingsHandler(TGPersistenceSettingsHandler handler) {
        this.handlers.add(handler);
    }

    public void removeSettingsHandler(TGPersistenceSettingsHandler handler) {
        if (this.handlers.contains(handler)) {
            this.handlers.remove(handler);
        }
    }

    public TGPersistenceSettingsHandler findSettingsHandler(TGFileFormat fileFormat, TGPersistenceSettingsMode mode) {
        for (TGPersistenceSettingsHandler handler : this.handlers) {
            if (!handler.getFileFormat().equals((Object)fileFormat) || !handler.getMode().supports(mode)) continue;
            return handler;
        }
        return null;
    }

    public void appendListeners() {
        TGActionManager.getInstance((TGContext)this.getContext()).addInterceptor((TGActionInterceptor)new TGPersistenceSettingsInterceptor(this.context));
    }

    public static TGPersistenceSettingsManager getInstance(TGContext context) {
        return (TGPersistenceSettingsManager)TGSingletonUtil.getInstance((TGContext)context, (String)TGPersistenceSettingsManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGPersistenceSettingsManager>(){

            public TGPersistenceSettingsManager createInstance(TGContext context) {
                return new TGPersistenceSettingsManager(context);
            }
        });
    }
}

