/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.action.impl.selector;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.action.TGActionManager;
import org.herac.tuxguitar.app.view.component.tab.Caret;
import org.herac.tuxguitar.app.view.component.tab.Selector;
import org.herac.tuxguitar.app.view.component.tab.Tablature;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.graphics.control.TGBeatImpl;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.song.managers.TGMeasureManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.util.TGContext;

public class TGExtendSelectionNextAction
extends TGActionBase {
    public static final String NAME = "action.selection.extend-next";

    public TGExtendSelectionNextAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext context) {
        Tablature tablature = TablatureEditor.getInstance(this.getContext()).getTablature();
        Selector selector = tablature.getSelector();
        Caret caret = tablature.getCaret();
        if (!selector.isActive()) {
            selector.initializeSelection((TGBeat)caret.getSelectedBeat());
        }
        TGMeasureImpl currentMeasure = caret.getMeasure();
        TGMeasureManager measureManager = this.getSongManager(context).getMeasureManager();
        TGBeat lastBeat = measureManager.getLastBeat(currentMeasure.getBeats());
        TGBeatImpl currentBeat = caret.getSelectedBeat();
        context.setAttribute("keep-selection", (Object)true);
        TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)this.getContext());
        if (currentBeat == lastBeat) {
            tgActionManager.execute("action.measure.go-next", context);
            if (caret.getSelectedBeat().getStart() >= selector.getInitialBeat().getStart()) {
                this.moveToMeasureEnd(context, caret);
            }
        } else {
            this.moveToMeasureEnd(context, caret);
            if (!this.getSongManager(context).getTrackManager().isLastMeasure((TGMeasure)caret.getMeasure()) && caret.getSelectedBeat().getStart() < selector.getInitialBeat().getStart()) {
                caret.moveRight();
            }
        }
        selector.updateSelection((TGBeat)caret.getSelectedBeat());
    }

    private void moveToMeasureEnd(TGActionContext context, Caret caret) {
        TGMeasureImpl measure = caret.getMeasure();
        TGBeat lastBeat = this.getSongManager(context).getMeasureManager().getLastBeat(measure.getBeats());
        caret.moveTo(caret.getTrack(), measure, lastBeat, caret.getSelectedString().getNumber());
    }
}

