/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.action.impl.measure;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.action.TGActionManager;
import org.herac.tuxguitar.app.transport.TGTransport;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;

public class TGGoFirstMeasureAction
extends TGActionBase {
    public static final String NAME = "action.measure.go-first";

    public TGGoFirstMeasureAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext context) {
        if (MidiPlayer.getInstance((TGContext)this.getContext()).isRunning()) {
            TGTransport.getInstance(this.getContext()).gotoFirst();
        } else {
            if (!Boolean.TRUE.equals(context.getAttribute("keep-selection"))) {
                TablatureEditor.getInstance(this.getContext()).getTablature().getSelector().clearSelection();
            }
            TGTrack track = (TGTrack)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
            TGMeasure firstMeasure = this.getSongManager(context).getTrackManager().getFirstMeasure(track);
            if (firstMeasure != null) {
                context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)firstMeasure);
                context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)firstMeasure.getBeat(0));
                TGActionManager.getInstance((TGContext)this.getContext()).execute("action.caret.move-to", context);
            }
        }
    }
}

