/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.action.impl.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.action.TGActionException;
import org.herac.tuxguitar.action.TGActionManager;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.editor.action.file.TGWriteSongAction;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.io.base.TGFileFormatUtils;
import org.herac.tuxguitar.util.TGContext;

public class TGWriteFileAction
extends TGActionBase {
    public static final String NAME = "action.file.write";
    public static final String ATTRIBUTE_FILE_NAME = "fileName";
    public static final String ATTRIBUTE_NATIVE_FILE_FORMAT = "nativeFileFormat";

    public TGWriteFileAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext context) {
        try {
            String fileName = (String)context.getAttribute(ATTRIBUTE_FILE_NAME);
            context.setAttribute(TGWriteSongAction.ATTRIBUTE_OUTPUT_STREAM, (Object)new FileOutputStream(new File(fileName)));
            String formatCode = TGFileFormatUtils.getFileFormatCode((String)fileName);
            context.setAttribute("formatCode", (Object)formatCode);
            TGFileFormat fileFormat = (TGFileFormat)context.getAttribute(TGWriteSongAction.ATTRIBUTE_FORMAT);
            boolean isNativeFormat = fileFormat != null ? TGFileFormatManager.getInstance((TGContext)this.getContext()).isNativeFileFormat(fileFormat) : TGFileFormatManager.getInstance((TGContext)this.getContext()).isNativeFileFormat(formatCode);
            context.setAttribute(ATTRIBUTE_NATIVE_FILE_FORMAT, (Object)isNativeFormat);
            TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)this.getContext());
            tgActionManager.execute("action.song.write", context);
        }
        catch (FileNotFoundException e) {
            throw new TGActionException((Throwable)e);
        }
    }
}

