/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.action.impl.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.action.TGActionManager;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionContextImpl;
import org.herac.tuxguitar.app.document.TGDocumentFileManager;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.app.view.dialog.file.TGFileChooserHandler;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.editor.action.file.TGReadSongAction;
import org.herac.tuxguitar.editor.event.TGUpdateEvent;
import org.herac.tuxguitar.editor.template.TGTemplate;
import org.herac.tuxguitar.editor.template.TGTemplateManager;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventManager;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGAbstractContext;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGUserFileUtils;

public class TGCustomTemplateSelectAction
extends TGActionBase {
    public static final String NAME = "action.custom-template.select";

    public TGCustomTemplateSelectAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext actionContext) {
        List<TGFileFormat> fileFormats = this.createFileFormats(actionContext);
        TGDocumentFileManager tgDocumentFileManager = TGDocumentFileManager.getInstance(this.getContext());
        tgDocumentFileManager.chooseFileNameForOpen(fileFormats, new TGFileChooserHandler(){

            @Override
            public void updateFileName(String fileName) {
                File file = new File(fileName);
                TGTemplate userTemplate = new TGTemplate();
                userTemplate.setName(new String());
                userTemplate.setResource(file.getAbsolutePath());
                userTemplate.setUserTemplate();
                TGSong song = TGTemplateManager.getInstance((TGContext)TGCustomTemplateSelectAction.this.getContext()).getTemplateAsSong(userTemplate);
                if (song == null) {
                    UIWindow window = TGWindow.getInstance(TGCustomTemplateSelectAction.this.getContext()).getWindow();
                    TGMessageDialogUtil.errorMessage(TGCustomTemplateSelectAction.this.getContext(), window, TuxGuitar.getProperty("file.custom-template.error"));
                } else {
                    TGUserFileUtils.setUserTemplate((File)file);
                    TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)TGCustomTemplateSelectAction.this.getContext());
                    tgActionManager.execute("action.song.new", (TGActionContext)new TGActionContextImpl());
                    TGEventManager.getInstance((TGContext)TGCustomTemplateSelectAction.this.getContext()).fireEvent((TGEvent)new TGUpdateEvent(6, (TGAbstractContext)TGCustomTemplateSelectAction.this.getContext()));
                }
            }
        });
    }

    public List<TGFileFormat> createFileFormats(TGActionContext context) {
        TGFileFormatManager fileFormatManager = TGFileFormatManager.getInstance((TGContext)this.getContext());
        TGFileFormat fileFormat = (TGFileFormat)context.getAttribute(TGReadSongAction.ATTRIBUTE_FORMAT);
        if (fileFormat == null) {
            return fileFormatManager.findReadFileFormats(Boolean.valueOf(true));
        }
        ArrayList<TGFileFormat> fileFormats = new ArrayList<TGFileFormat>();
        fileFormats.add(fileFormat);
        return fileFormats;
    }
}

