/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.action.impl.file;

import java.util.List;
import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.action.TGActionManager;
import org.herac.tuxguitar.app.document.TGDocument;
import org.herac.tuxguitar.app.document.TGDocumentListManager;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.util.TGContext;

public class TGCloseDocumentsAction
extends TGActionBase {
    public static final String NAME = "action.file.close-documents";

    public TGCloseDocumentsAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext context) {
        TGActionManager actionManager = TGActionManager.getInstance((TGContext)this.getContext());
        TGDocumentListManager documentManager = TGDocumentListManager.getInstance(this.getContext());
        TGDocument currentDocument = documentManager.findCurrentDocument();
        int currentIndex = documentManager.findCurrentDocumentIndex();
        List documentsToClose = (List)context.getAttribute("documents");
        documentManager.removeDocuments(documentsToClose);
        if (!documentManager.containsDocument(currentDocument)) {
            TGDocument next = this.findNextDocument(documentManager, currentIndex);
            if (next != null) {
                context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)next.getSong());
                context.setAttribute("unwanted", (Object)next.isUnwanted());
                actionManager.execute("action.song.load", context);
            } else {
                context.setAttribute("unwanted", (Object)true);
                actionManager.execute("action.song.new", context);
            }
        }
    }

    private TGDocument findNextDocument(TGDocumentListManager documentManager, int removedIndex) {
        int startIndex;
        List<TGDocument> documents = documentManager.getDocuments();
        for (int i = startIndex = removedIndex >= 0 ? removedIndex : 0; i >= 0; --i) {
            if (documents.size() <= i) continue;
            return documents.get(i);
        }
        return null;
    }
}

