/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.action.impl.edit;

import java.util.List;
import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.action.TGActionManager;
import org.herac.tuxguitar.app.view.component.tab.Selector;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.editor.clipboard.TGClipboard;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.helpers.TGStoredBeatList;
import org.herac.tuxguitar.song.managers.TGMeasureManager;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.managers.TGTrackManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;

public class TGPasteAction
extends TGActionBase {
    public static final String NAME = "action.edit.paste";

    public TGPasteAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext tgActionContext) {
        TGClipboard clipboard = TGClipboard.getInstance((TGContext)this.getContext());
        TGStoredBeatList beatList = TGClipboard.getInstance((TGContext)this.getContext()).getBeats();
        if (clipboard.getSegment() != null) {
            TGActionManager.getInstance((TGContext)this.getContext()).execute("action.gui.open-measure-paste-dialog", tgActionContext);
        } else if (beatList != null && beatList.getBeats().size() > 0) {
            TGFactory factory = this.getSongManager(tgActionContext).getFactory();
            TGSongManager songManager = this.getSongManager(tgActionContext);
            TGTrackManager trackManager = songManager.getTrackManager();
            TGBeat start = (TGBeat)tgActionContext.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
            TGTrack destTrack = (TGTrack)tgActionContext.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
            if (beatList.isPercussionTrack() == destTrack.isPercussion()) {
                TGStoredBeatList beatsListToPaste = beatList.clone(factory);
                trackManager.allocateNotesToStrings(beatsListToPaste.getStringValues(), beatsListToPaste.getBeats(), destTrack.getStrings(), destTrack.getMaxFret());
                List newBeats = trackManager.replaceBeats(destTrack, beatsListToPaste.getBeats(), start.getStart());
                if (beatsListToPaste.getBeats().size() > newBeats.size()) {
                    TGMeasureManager measureManager = songManager.getMeasureManager();
                    TGSong song = (TGSong)tgActionContext.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
                    TGMeasureHeader newHeader = songManager.addNewMeasureBeforeEnd(song);
                    TGMeasure newMeasure = destTrack.getMeasure(newHeader.getNumber() - 1);
                    long beatStart = newHeader.getStart();
                    for (int i = newBeats.size(); i < beatsListToPaste.getBeats().size(); ++i) {
                        TGBeat beatToInsert = (TGBeat)beatsListToPaste.getBeats().get(i);
                        beatToInsert.setStart(beatStart);
                        beatStart += beatToInsert.getShortestVoiceDurationTime();
                        measureManager.addBeat(newMeasure, beatToInsert);
                        newBeats.add(beatToInsert);
                    }
                    trackManager.moveOutOfBoundsBeatsToNewMeasure(destTrack, newHeader.getStart());
                }
                if (newBeats != null && newBeats.size() > 0) {
                    Selector selector = TablatureEditor.getInstance(this.getContext()).getTablature().getSelector();
                    selector.initializeSelection((TGBeat)newBeats.get(0));
                    selector.updateSelection((TGBeat)newBeats.get(newBeats.size() - 1));
                }
            }
        }
    }
}

