/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.pdf;

import java.util.Map;
import org.herac.tuxguitar.io.pdf.PDFSettings;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.configuration.TGConfigManager;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class PDFSettingsManager {
    private TGConfigManager configMgr;
    private PDFSettings settings = new PDFSettings();

    public PDFSettingsManager(TGContext context) {
        this.configMgr = new TGConfigManager(context, "tuxguitar-pdf");
        this.loadSettings();
    }

    private void loadSettings() {
        Map<String, Float> map = this.settings.getSettingsMap();
        for (String key : map.keySet()) {
            map.put(key, Float.valueOf(this.configMgr.getFloatValue(key, map.get(key).floatValue())));
        }
    }

    public PDFSettings getSettings() {
        return this.settings;
    }

    public float getSetting(String key) {
        return this.settings.getSettingsMap().get(key).floatValue();
    }

    public void setSetting(String key, float value) {
        this.settings.getSettingsMap().put(key, Float.valueOf(value));
    }

    public void saveSettings() {
        Map<String, Float> map = this.settings.getSettingsMap();
        for (String key : map.keySet()) {
            this.configMgr.setValue(key, map.get(key).floatValue());
        }
        this.configMgr.save();
    }

    public static PDFSettingsManager getInstance(TGContext context) {
        return (PDFSettingsManager)TGSingletonUtil.getInstance((TGContext)context, (String)PDFSettingsManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<PDFSettingsManager>(){

            public PDFSettingsManager createInstance(TGContext context) {
                return new PDFSettingsManager(context);
            }
        });
    }
}

