/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.util.base64;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class Base64Decoder {
    private static final int BUFFER_SIZE = 1024;

    private static int get1(byte[] buf, int off) {
        return (buf[off] & 0x3F) << 2 | (buf[off + 1] & 0x30) >>> 4;
    }

    private static int get2(byte[] buf, int off) {
        return (buf[off + 1] & 0xF) << 4 | (buf[off + 2] & 0x3C) >>> 2;
    }

    private static int get3(byte[] buf, int off) {
        return (buf[off + 2] & 3) << 6 | buf[off + 3] & 0x3F;
    }

    private static int check(int ch) {
        if (ch >= 65 && ch <= 90) {
            return ch - 65;
        }
        if (ch >= 97 && ch <= 122) {
            return ch - 97 + 26;
        }
        if (ch >= 48 && ch <= 57) {
            return ch - 48 + 52;
        }
        switch (ch) {
            case 61: {
                return 65;
            }
            case 43: {
                return 62;
            }
            case 47: {
                return 63;
            }
        }
        return -1;
    }

    public static byte[] decode(byte[] bytes) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            byte[] chunk = new byte[4];
            int got = -1;
            int ready = 0;
            block2: while ((got = in.read(buffer)) > 0) {
                int skipped = 0;
                while (skipped < got) {
                    while (ready < 4) {
                        int ch;
                        if (skipped >= got) continue block2;
                        if ((ch = Base64Decoder.check(buffer[skipped++])) < 0) continue;
                        chunk[ready++] = (byte)ch;
                    }
                    if (chunk[2] == 65) {
                        out.write(Base64Decoder.get1(chunk, 0));
                        return out.toByteArray();
                    }
                    if (chunk[3] == 65) {
                        out.write(Base64Decoder.get1(chunk, 0));
                        out.write(Base64Decoder.get2(chunk, 0));
                        return out.toByteArray();
                    }
                    out.write(Base64Decoder.get1(chunk, 0));
                    out.write(Base64Decoder.get2(chunk, 0));
                    out.write(Base64Decoder.get3(chunk, 0));
                    ready = 0;
                }
            }
            if (ready == 0) {
                out.flush();
                return out.toByteArray();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bytes;
    }
}

