/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.util;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class TGUserFileUtils {
    private static final String TG_HOME_PATH = "tuxguitar.home.path";
    private static final String TG_USER_SHARE_PATH = "tuxguitar.user-share.path";
    private static final String TG_CONFIG_PATH = "tuxguitar.config.path";
    public static final String PATH_HOME = TGUserFileUtils.getHomePath();
    public static final String PATH_USER_DIR = TGUserFileUtils.getDefaultUserAppDir();
    public static final String PATH_USER_CONFIG = TGUserFileUtils.getUserConfigDir();
    public static final String PATH_USER_PLUGINS_CONFIG = TGUserFileUtils.getUserPluginsConfigDir();
    public static final String PATH_USER_SHARE_PATH = TGUserFileUtils.getUserSharedPath();
    public static final String PATH_USER_TEMPLATE = TGUserFileUtils.getUserTemplatePath();
    public static final String PATH_USER_TUNINGS = TGUserFileUtils.getUserTuningsPath();

    private static String getHomePath() {
        File file;
        String homePath = System.getProperty(TG_HOME_PATH);
        if (homePath != null && TGUserFileUtils.isExistentAndReadable(file = new File(homePath).getAbsoluteFile()) && TGUserFileUtils.isDirectoryAndReadable(file)) {
            return file.getAbsolutePath();
        }
        homePath = System.getProperty("user.dir");
        if (homePath != null && TGUserFileUtils.isExistentAndReadable(file = new File(homePath).getAbsoluteFile()) && TGUserFileUtils.isDirectoryAndReadable(file)) {
            return file.getAbsolutePath();
        }
        return new File(".").getAbsolutePath();
    }

    private static String getUserTemplatePath() {
        String path = TGUserFileUtils.getUserConfigDir() + File.separator + "templates";
        File directory = new File(path);
        if (!TGUserFileUtils.isDirectoryAndReadable(directory)) {
            TGUserFileUtils.tryCreateDirectory(directory);
        }
        return path + File.separator + "user-template.tg";
    }

    private static String getUserConfigDir() {
        File file;
        Object configPath = System.getProperty(TG_CONFIG_PATH);
        if (configPath == null) {
            configPath = TGUserFileUtils.getDefaultUserAppDir() + File.separator + "config";
        }
        if (!TGUserFileUtils.isExistentAndReadable(file = new File((String)configPath))) {
            TGUserFileUtils.tryCreateDirectory(file);
        }
        return configPath;
    }

    private static String getDefaultUserAppDir() {
        String home = System.getProperty("user.home");
        String folderName = "tuxguitar";
        String os = System.getProperty("os.name");
        if (os.equals("Mac OS X")) {
            return TGUserFileUtils.joinPath(home, "Library", "Application Support", folderName);
        }
        if (os.contains("Windows")) {
            return TGUserFileUtils.joinPath(home, "AppData", "Roaming", folderName);
        }
        return TGUserFileUtils.joinPath(home, ".config", folderName);
    }

    private static String getUserPluginsConfigDir() {
        String configPluginsPath = TGUserFileUtils.getUserConfigDir() + File.separator + "plugins";
        File file = new File(configPluginsPath);
        if (!TGUserFileUtils.isExistentAndReadable(file)) {
            TGUserFileUtils.tryCreateDirectory(file);
        }
        return configPluginsPath;
    }

    private static String getUserSharedPath() {
        File file;
        Object userSharePath = System.getProperty(TG_USER_SHARE_PATH);
        if (userSharePath == null) {
            userSharePath = TGUserFileUtils.getDefaultUserAppDir() + File.separator + "cache";
        }
        if (!TGUserFileUtils.isExistentAndReadable(file = new File((String)userSharePath))) {
            TGUserFileUtils.tryCreateDirectory(file);
        }
        return userSharePath;
    }

    public static boolean isExistentAndReadable(File file) {
        try {
            return file.exists();
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public static boolean tryCreateDirectory(File file) {
        try {
            return file.mkdirs();
        }
        catch (SecurityException se) {
            return false;
        }
    }

    private static String joinPath(String base, String ... entries) {
        File file = new File(base);
        for (String entry : entries) {
            file = new File(file, entry);
        }
        return file.toString();
    }

    public static boolean isDirectoryAndReadable(File file) {
        try {
            return file.isDirectory();
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public static boolean isUserTemplateReadable() {
        return TGUserFileUtils.isExistentAndReadable(new File(PATH_USER_TEMPLATE));
    }

    public static boolean setUserTemplate(File srcFile) {
        try {
            Path src = srcFile.toPath();
            Path dst = new File(PATH_USER_TEMPLATE).toPath();
            Files.copy(src, dst, StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean deleteUserTemplate() {
        return new File(PATH_USER_TEMPLATE).delete();
    }

    private static String getUserTuningsPath() {
        return TGUserFileUtils.getUserConfigDir() + File.separator + "tunings.xml";
    }
}

