/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;

public class TGBeatRange {
    private List<TGBeat> beats;
    private List<TGMeasure> measures;

    public TGBeatRange(List<TGBeat> beats) {
        TreeSet<TGMeasure> measures = new TreeSet<TGMeasure>(Comparator.comparingLong(a -> a.getHeader().getNumber()));
        this.beats = beats;
        for (TGBeat beat : beats) {
            measures.add(beat.getMeasure());
        }
        this.measures = new ArrayList<TGMeasure>(measures);
    }

    public boolean isEmpty() {
        return this.beats.isEmpty();
    }

    public List<TGBeat> getBeats() {
        return this.beats;
    }

    public List<TGMeasure> getMeasures() {
        return this.measures;
    }

    public TGMeasure firstMeasure() {
        return this.measures.get(0);
    }

    public TGMeasure lastMeasure() {
        return this.measures.get(this.measures.size() - 1);
    }

    public boolean containsMeasure(TGMeasure measure) {
        int index = Collections.binarySearch(this.measures, measure, Comparator.comparingLong(a -> a.getHeader().getNumber()));
        return index >= 0 && index < this.measures.size() && this.measures.get(index) == measure;
    }

    public static TGBeatRange single(TGBeat note) {
        return new TGBeatRange(Collections.singletonList(note));
    }

    public static TGBeatRange empty() {
        return new TGBeatRange(Collections.emptyList());
    }
}

