/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.thread;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.thread.TGExclusiveThreadHandler;
import org.herac.tuxguitar.thread.TGPooledThreadHandler;
import org.herac.tuxguitar.thread.TGThreadHandler;
import org.herac.tuxguitar.thread.TGThreadLoop;
import org.herac.tuxguitar.thread.TGThreadPriority;

public class TGMultiThreadHandler
implements TGThreadHandler {
    private TGThreadHandler defaultHandler = new TGPooledThreadHandler();
    private TGThreadHandler exclusiveHandler = new TGExclusiveThreadHandler();
    private List<Object> exclusiveThreads = new ArrayList<Object>();

    private Object getInternalThreadId() {
        return Thread.currentThread().getId();
    }

    private TGThreadHandler getTargetHandler() {
        return this.exclusiveThreads.contains(this.getInternalThreadId()) ? this.exclusiveHandler : this.defaultHandler;
    }

    private void markAsExclusive() {
        Object threadId = this.getInternalThreadId();
        if (!this.exclusiveThreads.contains(threadId)) {
            this.exclusiveThreads.add(threadId);
        }
    }

    private void unmarkAsExclusive() {
        Object threadId = this.getInternalThreadId();
        if (this.exclusiveThreads.contains(threadId)) {
            this.exclusiveThreads.remove(threadId);
        }
    }

    @Override
    public void start(TGThreadPriority priority, Runnable runnable) {
        if (priority == TGThreadPriority.HIGH) {
            this.exclusiveHandler.start(priority, new TGExclusiveRunnable(this, runnable));
        } else {
            this.defaultHandler.start(priority, runnable);
        }
    }

    @Override
    public void loop(TGThreadLoop loop) {
        this.getTargetHandler().loop(loop);
    }

    @Override
    public void yield() {
        this.getTargetHandler().yield();
    }

    @Override
    public void dispose() {
        this.getTargetHandler().dispose();
    }

    @Override
    public Object getThreadId() {
        return this.getTargetHandler().getThreadId();
    }

    private static class TGExclusiveRunnable
    implements Runnable {
        private TGMultiThreadHandler handler;
        private Runnable target;

        public TGExclusiveRunnable(TGMultiThreadHandler handler, Runnable target) {
            this.handler = handler;
            this.target = target;
        }

        @Override
        public void run() {
            this.handler.markAsExclusive();
            this.target.run();
            this.handler.unmarkAsExclusive();
        }
    }
}

