/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGDuration;

public abstract class TGTimeSignature {
    private TGDuration denominator;
    private int numerator = 4;

    public TGTimeSignature(TGFactory factory) {
        this.denominator = factory.newDuration();
    }

    public int getNumerator() {
        return this.numerator;
    }

    public void setNumerator(int numerator) {
        this.numerator = numerator;
    }

    public TGDuration getDenominator() {
        return this.denominator;
    }

    public void setDenominator(TGDuration denominator) {
        this.denominator = denominator;
    }

    public float getQuartersInSignature() {
        return (float)this.numerator * 4.0f / (float)this.denominator.getValue();
    }

    public TGTimeSignature clone(TGFactory factory) {
        TGTimeSignature tgTimeSignature = factory.newTimeSignature();
        tgTimeSignature.copyFrom(this);
        return tgTimeSignature;
    }

    public void copyFrom(TGTimeSignature timeSignature) {
        this.setNumerator(timeSignature.getNumerator());
        this.getDenominator().copyFrom(timeSignature.getDenominator());
    }

    public boolean isEqual(TGTimeSignature ts) {
        return this.getNumerator() == ts.getNumerator() && this.getDenominator().isEqual(ts.getDenominator());
    }
}

