/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import java.util.HashMap;
import java.util.Map;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGDivisionType;

public abstract class TGDuration {
    public static final long QUARTER_TIME = 960L;
    public static final int WHOLE = 1;
    public static final int HALF = 2;
    public static final int QUARTER = 4;
    public static final int EIGHTH = 8;
    public static final int SIXTEENTH = 16;
    public static final int THIRTY_SECOND = 32;
    public static final int SIXTY_FOURTH = 64;
    public static final int SHORTEST = 64;
    private int value = 4;
    private boolean dotted = false;
    private boolean doubleDotted = false;
    private TGDivisionType divisionType;
    private static final Map<Long, TGDuration> durationMap = TGDuration.createDurationMap();

    public TGDuration(TGFactory factory) {
        this.divisionType = factory.newDivisionType();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public boolean isDotted() {
        return this.dotted;
    }

    public void setDotted(boolean dotted) {
        this.dotted = dotted;
    }

    public boolean isDoubleDotted() {
        return this.doubleDotted;
    }

    public void setDoubleDotted(boolean doubleDotted) {
        this.doubleDotted = doubleDotted;
    }

    public TGDivisionType getDivision() {
        return this.divisionType;
    }

    public long getTime() {
        long time = (long)(960.0f * (4.0f / (float)this.value));
        if (this.dotted) {
            time += time / 2L;
        } else if (this.doubleDotted) {
            time += time / 4L * 3L;
        }
        return this.divisionType.convertTime(time);
    }

    public static TGDuration getShortestDuration(TGFactory factory) {
        TGDuration minimum = factory.newDuration();
        minimum.setValue(64);
        minimum.setDotted(false);
        minimum.setDoubleDotted(false);
        minimum.getDivision().setEnters(7);
        minimum.getDivision().setTimes(4);
        return minimum;
    }

    public static TGDuration fromTime(TGFactory factory, long time) {
        TGDuration duration = TGDuration.getShortestDuration(factory);
        return TGDuration.fromTime(factory, time, duration);
    }

    public static TGDuration fromTime(TGFactory factory, long time, TGDuration minDuration) {
        int threshold = 0;
        long quaterTimeConstant = 960L;
        if (quaterTimeConstant == 960L) {
            if (time < 60L) {
                threshold = 2;
            } else if (time == 95L) {
                threshold = 3;
            } else if (time == 138L) {
                threshold = 1;
            } else if (time == 177L) {
                threshold = 3;
            } else if (time == 748L) {
                threshold = 2;
            } else if (time == 854L) {
                threshold = 1;
            }
        }
        return TGDuration.fromTime(factory, time, minDuration, (short)threshold);
    }

    public static TGDuration fromTime(TGFactory factory, long time, TGDuration minimum, short threshold) {
        TGDuration durationFound = null;
        for (int i = 0; i <= threshold; ++i) {
            durationFound = durationMap.get(time - (long)i);
            if (durationFound == null) continue;
            return durationFound.clone(factory);
        }
        durationFound = factory.newDuration();
        for (int v = 1; v <= 64; v *= 2) {
            durationFound.setValue(v);
            if (time < durationFound.getTime()) continue;
            return durationFound.clone(factory);
        }
        return minimum.clone(factory);
    }

    public int getIndex() {
        int index = 0;
        int value = this.value;
        while ((value >>= 1) > 0) {
            ++index;
        }
        return index;
    }

    public boolean isEqual(TGDuration d) {
        return this.getValue() == d.getValue() && this.isDotted() == d.isDotted() && this.isDoubleDotted() == d.isDoubleDotted() && this.getDivision().isEqual(d.getDivision());
    }

    public TGDuration clone(TGFactory factory) {
        TGDuration tgDuration = factory.newDuration();
        tgDuration.copyFrom(this);
        return tgDuration;
    }

    public void copyFrom(TGDuration duration) {
        this.setValue(duration.getValue());
        this.setDotted(duration.isDotted());
        this.setDoubleDotted(duration.isDoubleDotted());
        this.getDivision().copyFrom(duration.getDivision());
    }

    private static Map<Long, TGDuration> createDurationMap() {
        TGFactory factory = new TGFactory();
        HashMap<Long, TGDuration> durationHashMap = new HashMap<Long, TGDuration>();
        for (TGDivisionType tmpDivisionType : TGDivisionType.DIVISION_TYPES) {
            for (int i = 0; i < 3; ++i) {
                for (int v = 1; v <= 64; v *= 2) {
                    TGDuration tmpDuration = factory.newDuration();
                    if (i == 1) {
                        tmpDuration.setDotted(true);
                        tmpDuration.setDoubleDotted(false);
                    } else if (i == 2) {
                        tmpDuration.setDotted(false);
                        tmpDuration.setDoubleDotted(true);
                    } else {
                        tmpDuration.setDotted(false);
                        tmpDuration.setDoubleDotted(false);
                    }
                    tmpDuration.setValue(v);
                    tmpDuration.getDivision().setEnters(tmpDivisionType.getEnters());
                    tmpDuration.getDivision().setTimes(tmpDivisionType.getTimes());
                    TGDuration entry = tmpDuration;
                    long key = entry.getTime();
                    if (durationHashMap.containsKey(key)) continue;
                    durationHashMap.put(key, entry);
                }
            }
        }
        return durationHashMap;
    }
}

