/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGStroke;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGVoice;

public abstract class TGBeat {
    public static final int MAX_VOICES = 2;
    private long start = 960L;
    private TGMeasure measure;
    private TGChord chord;
    private TGText text;
    private TGVoice[] voices;
    private TGStroke stroke;

    public TGBeat(TGFactory factory) {
        this.stroke = factory.newStroke();
        this.voices = new TGVoice[2];
        for (int i = 0; i < 2; ++i) {
            this.setVoice(i, factory.newVoice(i));
        }
    }

    public TGMeasure getMeasure() {
        return this.measure;
    }

    public void setMeasure(TGMeasure measure) {
        this.measure = measure;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public void setVoice(int index, TGVoice voice) {
        if (index >= 0 && index < this.voices.length) {
            this.voices[index] = voice;
            this.voices[index].setBeat(this);
        }
    }

    public TGVoice getVoice(int index) {
        if (index >= 0 && index < this.voices.length) {
            return this.voices[index];
        }
        return null;
    }

    public int countVoices() {
        return this.voices.length;
    }

    public void setChord(TGChord chord) {
        this.chord = chord;
        this.chord.setBeat(this);
    }

    public TGChord getChord() {
        return this.chord;
    }

    public void removeChord() {
        this.chord = null;
    }

    public TGText getText() {
        return this.text;
    }

    public void setText(TGText text) {
        this.text = text;
        this.text.setBeat(this);
    }

    public void removeText() {
        this.text = null;
    }

    public boolean isChordBeat() {
        return this.chord != null;
    }

    public boolean isTextBeat() {
        return this.text != null;
    }

    public TGStroke getStroke() {
        return this.stroke;
    }

    public boolean isRestBeat() {
        for (int v = 0; v < this.countVoices(); ++v) {
            TGVoice voice = this.getVoice(v);
            if (voice.isEmpty() || voice.isRestVoice()) continue;
            return false;
        }
        return true;
    }

    public long getShortestVoiceDurationTime() {
        long time = -1L;
        for (int v = 0; v < this.countVoices(); ++v) {
            TGVoice voice = this.getVoice(v);
            if (voice.isEmpty() || time >= 0L && voice.getDuration().getTime() >= time) continue;
            time = voice.getDuration().getTime();
        }
        return time;
    }

    public long getDurationTime() {
        long time = 0L;
        for (int v = 0; v < this.countVoices(); ++v) {
            TGVoice voice = this.getVoice(v);
            if (voice.isEmpty() || voice.getDuration().getTime() <= time) continue;
            time = voice.getDuration().getTime();
        }
        return time;
    }

    public long getEnd() {
        return this.getStart() + this.getDurationTime();
    }

    public void copyFrom(TGBeat beat, TGFactory factory) {
        this.setStart(beat.getStart());
        this.getStroke().copyFrom(beat.getStroke());
        for (int i = 0; i < beat.voices.length; ++i) {
            this.setVoice(i, beat.voices[i].clone(factory));
        }
        if (beat.chord != null) {
            this.setChord(beat.chord.clone(factory));
        }
        if (beat.text != null) {
            this.setText(beat.text.clone(factory));
        }
    }

    public TGBeat clone(TGFactory factory) {
        TGBeat beat = factory.newBeat();
        beat.copyFrom(this, factory);
        return beat;
    }
}

