/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import org.herac.tuxguitar.song.models.effects.TGEffectTrill;

public class TGMeasureManager {
    private TGSongManager songManager;

    public TGMeasureManager(TGSongManager songManager) {
        this.songManager = songManager;
    }

    public TGSongManager getSongManager() {
        return this.songManager;
    }

    public void orderBeats(TGMeasure measure) {
        for (int i = 0; i < measure.countBeats(); ++i) {
            TGBeat minBeat = null;
            for (int j = i; j < measure.countBeats(); ++j) {
                TGBeat beat = measure.getBeat(j);
                if (minBeat != null && beat.getStart() >= minBeat.getStart()) continue;
                minBeat = beat;
            }
            measure.moveBeat(i, minBeat);
        }
    }

    public void addBeat(TGMeasure measure, TGBeat beat) {
        measure.addBeat(beat);
    }

    public void removeBeat(TGBeat beat) {
        beat.getMeasure().removeBeat(beat);
    }

    public void removeBeat(TGMeasure measure, long start, boolean moveNextComponents) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            this.removeBeat(beat, moveNextComponents);
        }
    }

    public void removeBeat(TGBeat beat, boolean moveNextBeats) {
        TGMeasure measure = beat.getMeasure();
        this.removeBeat(beat);
        if (moveNextBeats) {
            TGDuration minimumDuration = this.getMinimumDuration(beat);
            long start = beat.getStart();
            long length = minimumDuration != null ? minimumDuration.getTime() : 0L;
            TGBeat next = this.getNextBeat(measure.getBeats(), beat);
            if (next != null) {
                length = next.getStart() - start;
            }
            this.moveBeatsInMeasure(beat.getMeasure(), start + length, -length, minimumDuration);
        }
    }

    public void removeEmptyBeats(TGMeasure measure) {
        ArrayList<TGBeat> beats = new ArrayList<TGBeat>();
        for (TGBeat beat : measure.getBeats()) {
            boolean emptyBeat = true;
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                if (voice.isEmpty()) continue;
                emptyBeat = false;
            }
            if (!emptyBeat) continue;
            beats.add(beat);
        }
        for (TGBeat beat : beats) {
            this.removeBeat(beat);
        }
    }

    public void removeBeatsBeforeEnd(TGMeasure measure, long fromStart) {
        List<TGBeat> beats = this.getBeatsBeforeEnd(measure.getBeats(), fromStart);
        for (TGBeat beat : beats) {
            this.removeBeat(beat);
        }
    }

    public void removeBeatsBetween(TGMeasure measure, long p1, long p2) {
        List<TGBeat> beats = this.getBeatsBeetween(measure.getBeats(), p1, p2);
        for (TGBeat beat : beats) {
            this.removeBeat(beat);
        }
    }

    public void addNote(TGMeasure measure, long start, TGNote note, TGDuration duration, int voice) {
        TGBeat beat = this.getBeatIn(measure, start);
        if (beat != null) {
            this.addNote(beat, note, duration, start, voice);
        }
    }

    public void addNote(TGBeat beat, TGNote note, TGDuration duration, int voice) {
        this.addNote(beat, note, duration, beat.getStart(), voice);
    }

    public void addNote(TGBeat beat, TGNote note, TGDuration duration, long start, int voice) {
        boolean emptyVoice = beat.getVoice(voice).isEmpty();
        if (emptyVoice) {
            beat.getVoice(voice).setEmpty(false);
        }
        if (this.validateDuration(beat.getMeasure(), beat, voice, duration, true, true)) {
            TGVoice beatIn;
            for (int v = 0; v < beat.countVoices(); ++v) {
                this.removeNote(beat.getMeasure(), beat.getStart(), v, note.getString(), false);
            }
            beat.getVoice(voice).getDuration().copyFrom(duration);
            this.tryChangeSilenceAfter(beat.getMeasure(), beat.getVoice(voice));
            TGVoice realVoice = beat.getVoice(voice);
            if (realVoice.getBeat().getStart() != start && (beatIn = this.getVoiceIn(realVoice.getBeat().getMeasure(), start, voice)) != null) {
                realVoice = beatIn;
            }
            realVoice.addNote(note);
        } else {
            beat.getVoice(voice).setEmpty(emptyVoice);
        }
    }

    public void removeNote(TGNote note, boolean checkRestBeat) {
        TGVoice voice = note.getVoice();
        if (voice != null) {
            voice.removeNote(note);
            TGBeat beat = voice.getBeat();
            if (checkRestBeat && beat.isRestBeat()) {
                beat.getStroke().setDirection(0);
                if (beat.getMeasure() != null) {
                    this.removeChord(beat.getMeasure(), beat.getStart());
                }
            }
        }
    }

    public void removeNote(TGNote note) {
        this.removeNote(note, true);
    }

    public void removeNote(TGMeasure measure, long start, int voiceIndex, int string) {
        this.removeNote(measure, start, voiceIndex, string, true);
    }

    public void removeNote(TGMeasure measure, long start, int voiceIndex, int string, boolean checkRestBeat) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            TGVoice voice = beat.getVoice(voiceIndex);
            for (int i = 0; i < voice.countNotes(); ++i) {
                TGNote note = voice.getNote(i);
                if (note.getString() != string) continue;
                this.removeNote(note, checkRestBeat);
                return;
            }
        }
    }

    public void removeNotesAfterString(TGMeasure measure, int string) {
        ArrayList<TGNote> notesToRemove = new ArrayList<TGNote>();
        for (TGBeat beat : measure.getBeats()) {
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                for (TGNote note : voice.getNotes()) {
                    if (note.getString() <= string) continue;
                    notesToRemove.add(note);
                }
            }
        }
        for (TGNote note : notesToRemove) {
            this.removeNote(note);
        }
    }

    public List<TGNote> getNotes(TGMeasure measure, long start) {
        ArrayList<TGNote> notes = new ArrayList<TGNote>();
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                for (TGNote note : voice.getNotes()) {
                    notes.add(note);
                }
            }
        }
        return notes;
    }

    public List<TGNote> getNotes(TGBeat beat) {
        ArrayList<TGNote> notes = new ArrayList<TGNote>();
        if (beat != null) {
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                if (voice.isEmpty() || voice.isRestVoice()) continue;
                for (TGNote note : voice.getNotes()) {
                    notes.add(note);
                }
            }
        }
        return notes;
    }

    public TGNote getNote(TGMeasure measure, long start, int string) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            return this.getNote(beat, string);
        }
        return null;
    }

    public TGNote getNote(TGBeat beat, int string) {
        for (int v = 0; v < beat.countVoices(); ++v) {
            TGNote note;
            TGVoice voice = beat.getVoice(v);
            if (voice.isEmpty() || (note = this.getNote(voice, string)) == null) continue;
            return note;
        }
        return null;
    }

    public TGNote getNote(TGVoice voice, int string) {
        for (TGNote note : voice.getNotes()) {
            if (note.getString() != string) continue;
            return note;
        }
        return null;
    }

    public TGNote getPreviousNote(TGMeasure measure, long start, int voiceIndex, int string) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            TGBeat previous = this.getPreviousBeat(measure.getBeats(), beat);
            while (previous != null) {
                TGVoice voice = previous.getVoice(voiceIndex);
                if (!voice.isEmpty()) {
                    for (int i = 0; i < voice.countNotes(); ++i) {
                        TGNote current = voice.getNote(i);
                        if (current.getString() != string) continue;
                        return current;
                    }
                }
                previous = this.getPreviousBeat(measure.getBeats(), previous);
            }
        }
        return null;
    }

    public TGNote getNextNote(TGMeasure measure, long start, int voiceIndex, int string) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            TGBeat next = this.getNextBeat(measure.getBeats(), beat);
            while (next != null) {
                TGVoice voice = next.getVoice(voiceIndex);
                if (!voice.isEmpty()) {
                    for (int i = 0; i < voice.countNotes(); ++i) {
                        TGNote current = voice.getNote(i);
                        if (current.getString() != string) continue;
                        return current;
                    }
                }
                next = this.getNextBeat(measure.getBeats(), next);
            }
        }
        return null;
    }

    public TGDuration getMinimumDuration(TGBeat beat) {
        TGDuration minimumDuration = null;
        for (int v = 0; v < beat.countVoices(); ++v) {
            TGVoice voice = beat.getVoice(v);
            if (voice.isEmpty() || minimumDuration != null && voice.getDuration().getTime() >= minimumDuration.getTime()) continue;
            minimumDuration = voice.getDuration();
        }
        return minimumDuration;
    }

    public TGBeat getBeat(TGTrack track, long start) {
        Iterator<TGMeasure> measures = track.getMeasures();
        while (measures.hasNext()) {
            TGMeasure measure = measures.next();
            for (TGBeat beat : measure.getBeats()) {
                if (beat.getStart() != start) continue;
                return beat;
            }
        }
        return null;
    }

    public TGBeat getBeat(TGMeasure measure, long start) {
        for (TGBeat beat : measure.getBeats()) {
            if (beat.getStart() != start) continue;
            return beat;
        }
        return null;
    }

    public TGBeat getBeatIn(TGMeasure measure, long start) {
        TGBeat beatIn = null;
        for (TGBeat beat : measure.getBeats()) {
            TGDuration duration = this.getMinimumDuration(beat);
            if (beat.getStart() > start || beat.getStart() + duration.getTime() <= start || beatIn != null && beat.getStart() <= beatIn.getStart()) continue;
            beatIn = beat;
        }
        return beatIn;
    }

    public TGVoice getVoiceIn(TGMeasure measure, long start, int voiceIndex) {
        for (TGBeat beat : measure.getBeats()) {
            TGVoice voice = beat.getVoice(voiceIndex);
            if (voice.isEmpty() || beat.getStart() > start || beat.getStart() + voice.getDuration().getTime() <= start) continue;
            return voice;
        }
        return null;
    }

    public TGBeat getNextBeat(List<TGBeat> beats, TGBeat beat) {
        TGBeat next = null;
        for (int i = 0; i < beats.size(); ++i) {
            TGBeat current = beats.get(i);
            if (current.getStart() <= beat.getStart()) continue;
            if (next == null) {
                next = current;
                continue;
            }
            if (current.getStart() >= next.getStart()) continue;
            next = current;
        }
        return next;
    }

    public TGBeat getPreviousBeat(List<TGBeat> beats, TGBeat beat) {
        TGBeat previous = null;
        for (int i = 0; i < beats.size(); ++i) {
            TGBeat current = beats.get(i);
            if (current.getStart() >= beat.getStart()) continue;
            if (previous == null) {
                previous = current;
                continue;
            }
            if (current.getStart() <= previous.getStart()) continue;
            previous = current;
        }
        return previous;
    }

    public TGBeat getFirstBeat(List<TGBeat> components) {
        TGBeat first = null;
        for (int i = 0; i < components.size(); ++i) {
            TGBeat component = components.get(i);
            if (first != null && component.getStart() >= first.getStart()) continue;
            first = component;
        }
        return first;
    }

    public TGBeat getLastBeat(List<TGBeat> components) {
        TGBeat last = null;
        for (int i = 0; i < components.size(); ++i) {
            TGBeat component = components.get(i);
            if (last != null && last.getStart() >= component.getStart()) continue;
            last = component;
        }
        return last;
    }

    public List<TGBeat> getBeatsBeforeEnd(List<TGBeat> beats, long fromStart) {
        ArrayList<TGBeat> list = new ArrayList<TGBeat>();
        for (TGBeat current : beats) {
            if (current.getStart() < fromStart) continue;
            list.add(current);
        }
        return list;
    }

    public List<TGBeat> getBeatsBeetween(List<TGBeat> beats, long p1, long p2) {
        ArrayList<TGBeat> list = new ArrayList<TGBeat>();
        for (TGBeat current : beats) {
            if (current.getStart() < p1 || current.getStart() >= p2) continue;
            list.add(current);
        }
        return list;
    }

    public void locateBeat(TGBeat beat, TGTrack track, boolean newMeasureAlsoForRestBeats) {
        TGMeasure newMeasure;
        if (beat.getMeasure() != null) {
            beat.getMeasure().removeBeat(beat);
            beat.setMeasure(null);
        }
        if ((newMeasure = this.getSongManager().getTrackManager().getMeasureAt(track, beat.getStart())) == null) {
            boolean createNewMeasure = newMeasureAlsoForRestBeats;
            if (!createNewMeasure) {
                boolean bl = createNewMeasure = !beat.isRestBeat() || beat.isTextBeat();
            }
            if (createNewMeasure) {
                while (newMeasure == null && beat.getStart() >= 960L) {
                    this.getSongManager().addNewMeasureBeforeEnd(track.getSong());
                    newMeasure = this.getSongManager().getTrackManager().getMeasureAt(track, beat.getStart());
                }
            }
        }
        if (newMeasure != null) {
            long mStart = newMeasure.getStart();
            long mLength = newMeasure.getLength();
            long bStart = beat.getStart();
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGDuration newVoiceDuration;
                TGDuration duration;
                long vTiedDuration;
                TGVoice voice = beat.getVoice(v);
                long vDuration = voice.getDuration().getTime();
                if (voice.isEmpty() || bStart + vDuration <= mStart + mLength) continue;
                if ((vDuration -= (vTiedDuration = bStart + vDuration - (mStart + mLength))) > 0L && (duration = TGDuration.fromTime(this.getSongManager().getFactory(), vDuration)) != null) {
                    voice.getDuration().copyFrom(duration);
                }
                if (vTiedDuration <= 0L || (newVoiceDuration = TGDuration.fromTime(this.getSongManager().getFactory(), vTiedDuration)) == null) continue;
                long newBeatStart = bStart + vDuration;
                TGBeat newBeat = this.getBeat(track, newBeatStart);
                if (newBeat == null) {
                    newBeat = this.getSongManager().getFactory().newBeat();
                    newBeat.setStart(bStart + vDuration);
                }
                TGVoice newVoice = newBeat.getVoice(v);
                for (int n = 0; n < voice.countNotes(); ++n) {
                    TGNote note = voice.getNote(n);
                    TGNote newNote = this.getSongManager().getFactory().newNote();
                    newNote.setTiedNote(true);
                    newNote.setValue(note.getValue());
                    newNote.setString(note.getString());
                    newNote.setVelocity(note.getVelocity());
                    newVoice.addNote(newNote);
                }
                newVoice.setEmpty(false);
                newVoice.getDuration().copyFrom(newVoiceDuration);
                this.locateBeat(newBeat, track, newMeasureAlsoForRestBeats);
            }
            newMeasure.addBeat(beat);
        }
    }

    public void moveOutOfBoundsBeatsToNewMeasure(TGMeasure measure) {
        this.moveOutOfBoundsBeatsToNewMeasure(measure, true);
    }

    public void moveOutOfBoundsBeatsToNewMeasure(TGMeasure measure, boolean newMeasureAlsoForRestBeats) {
        ArrayList<TGBeat> beats = new ArrayList<TGBeat>();
        long mStart = measure.getStart();
        long mLength = measure.getLength();
        for (int i = 0; i < measure.countBeats(); ++i) {
            TGBeat beat = measure.getBeat(i);
            if (beat.getStart() < mStart || beat.getStart() >= mStart + mLength) {
                beats.add(beat);
                continue;
            }
            long bStart = beat.getStart();
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                long vDuration = voice.getDuration().getTime();
                if (voice.isEmpty() || bStart + vDuration <= mStart + mLength) continue;
                beats.add(beat);
            }
        }
        while (!beats.isEmpty()) {
            TGBeat beat = (TGBeat)beats.get(0);
            if (beat.getMeasure() != null) {
                beat.getMeasure().removeBeat(beat);
                beat.setMeasure(null);
            }
            this.locateBeat(beat, measure.getTrack(), newMeasureAlsoForRestBeats);
            beats.remove(0);
        }
    }

    public boolean moveBeatsInMeasure(TGMeasure measure, long start, long theMove, TGDuration fillDuration) {
        if (theMove == 0L) {
            return false;
        }
        boolean success = true;
        long measureStart = measure.getStart();
        long measureEnd = measureStart + measure.getLength();
        List<TGBeat> beatsToMove = this.getBeatsBeforeEnd(measure.getBeats(), start);
        this.moveBeats(beatsToMove, theMove);
        if (success) {
            TGDuration lastDuration;
            ArrayList<TGBeat> beatsToRemove = new ArrayList<TGBeat>();
            ArrayList<TGBeat> beats = new ArrayList<TGBeat>(measure.getBeats());
            TGBeat first = this.getFirstBeat(beats);
            while (first != null && first.isRestBeat() && !first.isTextBeat() && first.getStart() < measureStart) {
                beats.remove(first);
                beatsToRemove.add(first);
                first = this.getNextBeat(beats, first);
            }
            TGBeat last = this.getLastBeat(beats);
            TGDuration tGDuration = lastDuration = last != null ? this.getMinimumDuration(last) : null;
            while (last != null && lastDuration != null && last.isRestBeat() && !last.isTextBeat() && last.getStart() + lastDuration.getTime() > measureEnd) {
                beats.remove(last);
                beatsToRemove.add(last);
                last = this.getPreviousBeat(beats, last);
                lastDuration = last != null ? this.getMinimumDuration(last) : null;
            }
            if (first != null && last != null && lastDuration != null && (first.getStart() < measureStart || last.getStart() + lastDuration.getTime() > measureEnd)) {
                success = false;
            }
            if (success) {
                for (TGBeat beat : beatsToRemove) {
                    this.removeBeat(beat);
                }
                if (fillDuration != null) {
                    TGBeat beat;
                    if (theMove < 0L) {
                        last = this.getLastBeat(measure.getBeats());
                        lastDuration = last != null ? this.getMinimumDuration(last) : null;
                        beat = this.getSongManager().getFactory().newBeat();
                        beat.setStart(last != null && lastDuration != null ? last.getStart() + lastDuration.getTime() : start);
                        if (beat.getStart() + fillDuration.getTime() <= measureEnd) {
                            for (int v = 0; v < beat.countVoices(); ++v) {
                                TGVoice voice = beat.getVoice(v);
                                voice.setEmpty(false);
                                voice.getDuration().copyFrom(fillDuration);
                            }
                            this.addBeat(measure, beat);
                        }
                    } else {
                        first = this.getFirstBeat(this.getBeatsBeforeEnd(measure.getBeats(), start));
                        beat = this.getSongManager().getFactory().newBeat();
                        beat.setStart(start);
                        if (beat.getStart() + fillDuration.getTime() <= (first != null ? first.getStart() : measureEnd)) {
                            for (int v = 0; v < beat.countVoices(); ++v) {
                                TGVoice voice = beat.getVoice(v);
                                voice.setEmpty(false);
                                voice.getDuration().copyFrom(fillDuration);
                            }
                            this.addBeat(measure, beat);
                        }
                    }
                }
            }
        }
        if (!success) {
            this.moveBeats(beatsToMove, -theMove);
        }
        return success;
    }

    public void moveAllBeats(TGMeasure measure, long theMove) {
        this.moveBeats(measure.getBeats(), theMove);
    }

    public void moveBeats(TGMeasure measure, long start, long theMove) {
        this.moveBeats(this.getBeatsBeforeEnd(measure.getBeats(), start), theMove);
    }

    private void moveBeats(List<TGBeat> beats, long theMove) {
        for (TGBeat beat : beats) {
            this.moveBeat(beat, theMove);
        }
    }

    private void moveBeat(TGBeat beat, long theMove) {
        long start = beat.getStart();
        beat.setStart(start + theMove);
    }

    public void cleanBeat(TGBeat beat) {
        beat.getStroke().setDirection(0);
        if (beat.getText() != null) {
            beat.removeText();
        }
        if (beat.getChord() != null) {
            beat.removeChord();
        }
        this.cleanBeatNotes(beat);
    }

    public void cleanBeatNotes(TGBeat beat) {
        for (int v = 0; v < beat.countVoices(); ++v) {
            this.cleanVoiceNotes(beat.getVoice(v));
        }
    }

    public void cleanBeatNotes(TGMeasure measure, long start) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            this.cleanBeatNotes(beat);
        }
    }

    public void cleanVoiceNotes(TGVoice voice) {
        if (!voice.isEmpty()) {
            while (voice.countNotes() > 0) {
                TGNote note = voice.getNote(0);
                this.removeNote(note);
            }
        }
    }

    public void addChord(TGMeasure measure, long start, TGChord chord) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            this.addChord(beat, chord);
        }
    }

    public void addChord(TGBeat beat, TGChord chord) {
        beat.removeChord();
        beat.setChord(chord);
    }

    public TGChord getChord(TGMeasure measure, long start) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            return beat.getChord();
        }
        return null;
    }

    public void removeChord(TGMeasure measure, long start) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            beat.removeChord();
        }
    }

    public void addText(TGMeasure measure, long start, TGText text) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            this.addText(beat, text);
        }
    }

    public void addText(TGBeat beat, TGText text) {
        beat.removeText();
        if (!text.isEmpty()) {
            beat.setText(text);
        }
    }

    public TGText getText(TGMeasure measure, long start) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            return beat.getText();
        }
        return null;
    }

    public void removeText(TGBeat beat) {
        beat.removeText();
    }

    public boolean removeText(TGMeasure measure, long start) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            this.removeText(beat);
            return true;
        }
        return false;
    }

    public void cleanMeasure(TGMeasure measure) {
        while (measure.countBeats() > 0) {
            this.removeBeat(measure.getBeat(0));
        }
    }

    public int shiftNoteUp(TGMeasure measure, long start, int string) {
        return this.shiftNote(measure, start, string, -1);
    }

    public int shiftNoteDown(TGMeasure measure, long start, int string) {
        return this.shiftNote(measure, start, string, 1);
    }

    private int shiftNote(TGMeasure measure, long start, int string, int move) {
        TGNote note = this.getNote(measure, start, string);
        if (note != null) {
            int nextStringNumber = note.getString() + move;
            TGTrack track = measure.getTrack();
            if (this.getNote(measure, start, nextStringNumber) == null && nextStringNumber >= 1 && nextStringNumber <= track.stringCount()) {
                TGString currentString = track.getString(note.getString());
                TGString nextString = track.getString(nextStringNumber);
                int noteValue = note.getValue() + currentString.getValue();
                boolean canMove = noteValue >= nextString.getValue();
                canMove &= nextString.getValue() + track.getMaxFret() >= noteValue || track.isPercussion();
                int graceValue = 0;
                if (note.getEffect().isGrace()) {
                    graceValue = note.getEffect().getGrace().getFret() + currentString.getValue();
                    canMove &= graceValue >= nextString.getValue();
                    canMove &= nextString.getValue() + track.getMaxFret() >= graceValue || track.isPercussion();
                }
                if (canMove) {
                    note.setValue(noteValue - nextString.getValue());
                    note.setString(nextString.getNumber());
                    if (note.getEffect().isGrace()) {
                        note.getEffect().getGrace().setFret(graceValue - nextString.getValue());
                    }
                    return note.getString();
                }
            }
        }
        return 0;
    }

    public boolean canMoveSemitoneUp(TGMeasure measure, long start, int string) {
        return this.moveSemitone(measure, start, string, 1, false);
    }

    public boolean moveSemitoneUp(TGMeasure measure, long start, int string) {
        return this.moveSemitone(measure, start, string, 1, true);
    }

    public boolean canMoveSemitoneDown(TGMeasure measure, long start, int string) {
        return this.moveSemitone(measure, start, string, -1, false);
    }

    public boolean moveSemitoneDown(TGMeasure measure, long start, int string) {
        return this.moveSemitone(measure, start, string, -1, true);
    }

    private boolean moveSemitone(TGMeasure measure, long start, int string, int semitones, boolean doAction) {
        int newValue;
        TGNote note = this.getNote(measure, start, string);
        if (note != null && (newValue = note.getValue() + semitones) >= 0 && (newValue <= measure.getTrack().getMaxFret() || measure.getTrack().isPercussion())) {
            if (doAction) {
                note.setValue(newValue);
            }
            return true;
        }
        return false;
    }

    public boolean setStroke(TGMeasure measure, long start, int value, int direction) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            beat.getStroke().setValue(value);
            beat.getStroke().setDirection(direction);
            return true;
        }
        return false;
    }

    public void autoCompleteSilences(TGMeasure measure) {
        TGBeat beat = this.getFirstBeat(measure.getBeats());
        if (beat == null) {
            this.createSilences(measure, measure.getStart(), measure.getLength(), 0);
            return;
        }
        boolean hasVoices = false;
        for (int v = 0; v < 2; ++v) {
            TGVoice voice = this.getFirstVoice(measure.getBeats(), v);
            if (voice != null && voice.getBeat().getStart() > measure.getStart()) {
                this.createSilences(measure, measure.getStart(), voice.getBeat().getStart() - measure.getStart(), v);
            }
            hasVoices = hasVoices || voice != null;
        }
        if (!hasVoices) {
            this.createSilences(measure, measure.getStart(), measure.getLength(), 0);
            return;
        }
        long[] start = new long[beat.countVoices()];
        long[] uncompletedLength = new long[beat.countVoices()];
        for (int v = 0; v < uncompletedLength.length; ++v) {
            start[v] = 0L;
            uncompletedLength[v] = 0L;
        }
        long[] voiceBeatStartOffset = new long[beat.countVoices()];
        while (beat != null) {
            int v;
            for (v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                if (voice.isEmpty()) continue;
                long beatRealStart = beat.getStart() + voiceBeatStartOffset[v];
                long voiceRealStart = this.getRealStart(measure, beatRealStart);
                if (voiceRealStart != beatRealStart) {
                    int n = v;
                    voiceBeatStartOffset[n] = voiceBeatStartOffset[n] + (voiceRealStart - beatRealStart);
                }
                long voiceRealEnd = this.getRealStart(measure, voiceRealStart + voice.getDuration().getTime());
                long voiceEnd = beat.getStart() + voice.getDuration().getTime();
                long nextPosition = measure.getStart() + measure.getLength();
                TGVoice nextVoice = this.getNextVoice(measure.getBeats(), beat, voice.getIndex());
                if (nextVoice != null) {
                    nextPosition = nextVoice.getBeat().getStart();
                }
                if (voiceRealEnd >= nextPosition) continue;
                start[v] = voiceEnd;
                uncompletedLength[v] = nextPosition - voiceEnd;
            }
            for (v = 0; v < uncompletedLength.length; ++v) {
                if (uncompletedLength[v] > 0L) {
                    this.createSilences(measure, start[v], uncompletedLength[v], v);
                }
                start[v] = 0L;
                uncompletedLength[v] = 0L;
            }
            beat = this.getNextBeat(measure.getBeats(), beat);
        }
    }

    private void createSilences(TGMeasure measure, long start, long length, int voiceIndex) {
        long nextStart = start;
        List<TGDuration> durations = TGMeasureManager.createDurations(this.getSongManager().getFactory(), length);
        for (TGDuration duration : durations) {
            boolean isNew = false;
            long beatStart = this.getRealStart(measure, nextStart);
            TGBeat beat = this.getBeat(measure, beatStart);
            if (beat == null) {
                beat = this.getSongManager().getFactory().newBeat();
                beat.setStart(this.getRealStart(measure, nextStart));
                isNew = true;
            }
            TGVoice voice = beat.getVoice(voiceIndex);
            voice.setEmpty(false);
            voice.getDuration().copyFrom(duration);
            if (isNew) {
                this.addBeat(measure, beat);
            }
            nextStart += duration.getTime();
        }
    }

    public long getRealStart(TGMeasure measure, long currStart) {
        long start = currStart;
        long offset = 480L;
        long threshold = 0L;
        long quaterTimeConstant = 960L;
        if (quaterTimeConstant == 960L) {
            threshold = 12L;
        }
        if (threshold == 0L) {
            return currStart;
        }
        long diff = (offset - start % offset) % offset;
        if (diff <= threshold) {
            start += diff;
        }
        return start;
    }

    public void changeTieNote(TGMeasure measure, long start, int string) {
        TGNote note = this.getNote(measure, start, string);
        if (note != null) {
            this.changeTieNote(note);
        }
    }

    public void changeTieNote(TGNote note) {
        note.setTiedNote(!note.isTiedNote());
        note.getEffect().setDeadNote(false);
    }

    public void setVibrato(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setVibrato(value);
        }
    }

    public void changeDeadNote(TGNote note) {
        note.getEffect().setDeadNote(!note.getEffect().isDeadNote());
        note.setTiedNote(false);
    }

    public void setDeadNote(TGNote note, boolean value) {
        boolean oldValue = note.getEffect().isDeadNote();
        note.getEffect().setDeadNote(value);
        if (value != oldValue) {
            note.setTiedNote(false);
        }
    }

    public void setSlideNote(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setSlide(value);
        }
    }

    public void setHammerNote(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setHammer(value);
        }
    }

    public void setPalmMute(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setPalmMute(value);
        }
    }

    public void setStaccato(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setStaccato(value);
        }
    }

    public void setLetRing(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setLetRing(value);
        }
    }

    public void setTapping(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setTapping(value);
        }
    }

    public void setSlapping(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setSlapping(value);
        }
    }

    public void setPopping(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setPopping(value);
        }
    }

    public void setBendNote(TGNote note, TGEffectBend bend) {
        if (note != null) {
            note.getEffect().setBend(bend);
        }
    }

    public void setTremoloBar(TGNote note, TGEffectTremoloBar tremoloBar) {
        if (note != null) {
            note.getEffect().setTremoloBar(tremoloBar);
        }
    }

    public void setGhostNote(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setGhostNote(value);
        }
    }

    public void setAccentuatedNote(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setAccentuatedNote(value);
        }
    }

    public void setHeavyAccentuatedNote(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setHeavyAccentuatedNote(value);
        }
    }

    public void setHarmonicNote(TGNote note, TGEffectHarmonic harmonic) {
        if (note != null) {
            note.getEffect().setHarmonic(harmonic);
        }
    }

    public void setGraceNote(TGNote note, TGEffectGrace grace) {
        if (note != null) {
            note.getEffect().setGrace(grace);
        }
    }

    public void setTrillNote(TGNote note, TGEffectTrill trill) {
        if (note != null) {
            note.getEffect().setTrill(trill);
        }
    }

    public void setTremoloPicking(TGNote note, TGEffectTremoloPicking tremoloPicking) {
        if (note != null) {
            note.getEffect().setTremoloPicking(tremoloPicking);
        }
    }

    public void setFadeIn(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setFadeIn(value);
        }
    }

    public void changeVelocity(int velocity, TGNote note) {
        if (note != null) {
            note.setVelocity(velocity);
        }
    }

    public static List<TGDuration> createDurations(TGFactory factory, long time) {
        TGDuration duration;
        ArrayList<TGDuration> durations = new ArrayList<TGDuration>();
        TGDuration minimum = TGDuration.getShortestDuration(factory);
        for (long missingTime = time; missingTime >= minimum.getTime(); missingTime -= duration.getTime()) {
            duration = TGDuration.fromTime(factory, missingTime, minimum);
            durations.add(duration.clone(factory));
        }
        return durations;
    }

    public TGVoice getNextVoice(List<TGBeat> beats, TGBeat beat, int index) {
        TGVoice next = null;
        for (int i = 0; i < beats.size(); ++i) {
            TGBeat current = beats.get(i);
            if (current.getStart() <= beat.getStart() || current.getVoice(index).isEmpty()) continue;
            if (next == null) {
                next = current.getVoice(index);
                continue;
            }
            if (current.getStart() >= next.getBeat().getStart()) continue;
            next = current.getVoice(index);
        }
        return next;
    }

    public TGVoice getPreviousVoice(List<TGBeat> beats, TGBeat beat, int index) {
        TGVoice previous = null;
        for (int i = 0; i < beats.size(); ++i) {
            TGBeat current = beats.get(i);
            if (current.getStart() >= beat.getStart() || current.getVoice(index).isEmpty()) continue;
            if (previous == null) {
                previous = current.getVoice(index);
                continue;
            }
            if (current.getStart() <= previous.getBeat().getStart()) continue;
            previous = current.getVoice(index);
        }
        return previous;
    }

    public TGVoice getFirstVoice(List<TGBeat> beats, int index) {
        TGVoice first = null;
        for (int i = 0; i < beats.size(); ++i) {
            TGBeat current = beats.get(i);
            if (first != null && current.getStart() >= first.getBeat().getStart() || current.getVoice(index).isEmpty()) continue;
            first = current.getVoice(index);
        }
        return first;
    }

    public TGVoice getLastVoice(List<TGBeat> beats, int index) {
        TGVoice last = null;
        for (int i = 0; i < beats.size(); ++i) {
            TGBeat current = beats.get(i);
            if (last != null && last.getBeat().getStart() >= current.getStart() || current.getVoice(index).isEmpty()) continue;
            last = current.getVoice(index);
        }
        return last;
    }

    public TGVoice getNextRestVoice(List<TGBeat> beats, TGVoice voice) {
        TGVoice next = this.getNextVoice(beats, voice.getBeat(), voice.getIndex());
        while (next != null && !next.isRestVoice()) {
            next = this.getNextVoice(beats, next.getBeat(), next.getIndex());
        }
        return next;
    }

    public List<TGVoice> getVoicesBeforeEnd(List<TGBeat> beats, long fromStart, int index) {
        ArrayList<TGVoice> list = new ArrayList<TGVoice>();
        for (TGBeat beat : beats) {
            TGVoice voice;
            if (beat.getStart() < fromStart || (voice = beat.getVoice(index)).isEmpty()) continue;
            list.add(voice);
        }
        return list;
    }

    public void addSilence(TGMeasure measure, long start, TGDuration duration, int voice) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            this.addSilence(beat, duration, voice);
        }
    }

    public void addSilence(TGBeat beat, TGDuration duration, int voice) {
        this.addSilence(beat, duration, beat.getStart(), voice);
    }

    public void addSilence(TGBeat beat, TGDuration duration, long start, int voice) {
        boolean emptyVoice = beat.getVoice(voice).isEmpty();
        if (emptyVoice) {
            beat.getVoice(voice).setEmpty(false);
        }
        if (this.validateDuration(beat.getMeasure(), beat, voice, duration, true, true)) {
            TGVoice beatIn;
            beat.getVoice(voice).getDuration().copyFrom(duration);
            this.tryChangeSilenceAfter(beat.getMeasure(), beat.getVoice(voice));
            TGVoice realVoice = beat.getVoice(voice);
            if (realVoice.getBeat().getStart() != start && (beatIn = this.getVoiceIn(realVoice.getBeat().getMeasure(), start, voice)) != null) {
                realVoice = beatIn;
            }
            realVoice.setEmpty(false);
        } else {
            beat.getVoice(voice).setEmpty(emptyVoice);
        }
    }

    public void removeVoice(TGVoice voice) {
        voice.setEmpty(true);
        TGBeat beat = voice.getBeat();
        for (int i = 0; i < beat.countVoices(); ++i) {
            if (beat.getVoice(i).isEmpty()) continue;
            return;
        }
        this.removeBeat(beat);
    }

    public void removeVoice(TGVoice voice, boolean moveNextVoices) {
        this.removeVoice(voice);
        if (moveNextVoices) {
            long start = voice.getBeat().getStart();
            long length = voice.getDuration().getTime();
            TGVoice next = this.getNextVoice(voice.getBeat().getMeasure().getBeats(), voice.getBeat(), voice.getIndex());
            if (next != null) {
                length = next.getBeat().getStart() - start;
            }
            this.moveVoices(voice.getBeat().getMeasure(), start + length, -length, voice.getIndex(), voice.getDuration());
        }
    }

    public void removeVoice(TGMeasure measure, long start, int index, boolean moveNextComponents) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            this.removeVoice(beat.getVoice(index), moveNextComponents);
        }
    }

    public void removeVoicesOutOfTime(TGMeasure measure) {
        ArrayList<TGVoice> voicesToRemove = new ArrayList<TGVoice>();
        long mStart = measure.getStart();
        long mEnd = mStart + measure.getLength();
        for (TGBeat beat : measure.getBeats()) {
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                if (voice.isEmpty() || beat.getStart() >= mStart && beat.getStart() + voice.getDuration().getTime() <= mEnd) continue;
                voicesToRemove.add(voice);
            }
        }
        for (TGVoice voice : voicesToRemove) {
            this.removeVoice(voice);
        }
    }

    public void removeMeasureVoices(TGMeasure measure, int index) {
        boolean hasNotes = false;
        ArrayList<TGVoice> voices = new ArrayList<TGVoice>();
        for (TGBeat beat : measure.getBeats()) {
            TGVoice voice = beat.getVoice(index);
            if (voice.isRestVoice()) {
                voices.add(voice);
                continue;
            }
            if (voice.isEmpty()) continue;
            hasNotes = true;
            break;
        }
        if (!hasNotes) {
            for (TGVoice voice : voices) {
                this.removeVoice(voice);
            }
        }
    }

    public void changeVoiceDirection(TGVoice voice, int direction) {
        voice.setDirection(direction);
    }

    public void changeDuration(TGMeasure measure, TGBeat beat, TGDuration duration, int voice, boolean tryMove) {
        TGDuration oldDuration = beat.getVoice(voice).getDuration().clone(this.getSongManager().getFactory());
        if (this.validateDuration(measure, beat, voice, duration, tryMove, false)) {
            beat.getVoice(voice).setDuration(duration.clone(this.getSongManager().getFactory()));
            this.tryChangeSilenceAfter(measure, beat.getVoice(voice));
        } else {
            beat.getVoice(voice).getDuration().copyFrom(oldDuration);
        }
    }

    public void tryChangeSilenceAfter(TGMeasure measure, TGVoice voice) {
        this.autoCompleteSilences(measure);
        TGVoice nextVoice = this.getNextVoice(measure.getBeats(), voice.getBeat(), voice.getIndex());
        long beatEnd = voice.getBeat().getStart() + voice.getDuration().getTime();
        long measureEnd = measure.getStart() + measure.getLength();
        if (nextVoice != null && !nextVoice.isEmpty() && nextVoice.isRestVoice() && beatEnd <= measureEnd) {
            long theMove = this.getRealStart(measure, beatEnd) - this.getRealStart(measure, nextVoice.getBeat().getStart());
            if (nextVoice.getBeat().getStart() + theMove < measureEnd && nextVoice.getBeat().getStart() + nextVoice.getDuration().getTime() + theMove <= measureEnd) {
                this.moveVoice(nextVoice, theMove);
                this.changeDuration(measure, nextVoice.getBeat(), voice.getDuration().clone(this.getSongManager().getFactory()), nextVoice.getIndex(), false);
            }
        }
    }

    private void moveVoices(List<TGVoice> voices, long theMove) {
        int count = voices.size();
        for (int i = 0; i < count; ++i) {
            TGVoice voice = voices.get(theMove < 0L ? i : count - 1 - i);
            this.moveVoice(voice, theMove);
        }
    }

    public void moveVoice(TGVoice voice, long theMove) {
        long newStart = voice.getBeat().getStart() + theMove;
        TGBeat newBeat = this.getBeat(voice.getBeat().getMeasure(), newStart);
        if (newBeat == null) {
            newBeat = this.getSongManager().getFactory().newBeat();
            newBeat.setStart(newStart);
            this.addBeat(voice.getBeat().getMeasure(), newBeat);
        }
        this.moveVoice(voice, newBeat);
    }

    public void moveVoice(TGVoice voice, TGBeat beat) {
        TGBeat currentBeat = voice.getBeat();
        if (!currentBeat.equals(beat)) {
            if (currentBeat.getVoice(voice.getIndex()).equals(voice)) {
                if (currentBeat.isTextBeat() && this.isUniqueVoice(voice, false)) {
                    beat.setText(currentBeat.getText());
                    currentBeat.removeText();
                }
                if (this.isUniqueVoice(voice, true)) {
                    if (currentBeat.isChordBeat()) {
                        beat.setChord(currentBeat.getChord());
                        currentBeat.removeChord();
                    }
                    if (currentBeat.getStroke().getDirection() != 0) {
                        beat.getStroke().copyFrom(currentBeat.getStroke());
                        currentBeat.getStroke().setDirection(0);
                    }
                }
                TGVoice newVoice = this.getSongManager().getFactory().newVoice(voice.getIndex());
                currentBeat.setVoice(voice.getIndex(), newVoice);
                this.removeVoice(newVoice);
            }
            beat.setVoice(voice.getIndex(), voice);
        }
    }

    public boolean validateDuration(TGMeasure measure, TGBeat beat, int voice, TGDuration duration, boolean moveNextBeats, boolean setCurrentDuration) {
        int errorMargin = 10;
        this.orderBeats(measure);
        long measureStart = measure.getStart();
        long measureEnd = measureStart + measure.getLength();
        long beatStart = beat.getStart();
        long beatLength = duration.getTime();
        long beatEnd = beatStart + beatLength;
        List<TGBeat> beats = measure.getBeats();
        TGBeat currentBeat = this.getBeat(measure, beatStart);
        TGVoice currentVoice = null;
        if (currentBeat != null && !(currentVoice = currentBeat.getVoice(voice)).isEmpty() && beatLength <= currentVoice.getDuration().getTime()) {
            return true;
        }
        TGVoice nextVoice = this.getNextVoice(beats, beat, voice);
        if (currentVoice == null || currentVoice.isEmpty()) {
            if ((nextVoice == null || nextVoice.isEmpty()) && beatEnd < measureEnd + (long)errorMargin) {
                return true;
            }
            if (nextVoice != null && !nextVoice.isEmpty() && beatEnd < nextVoice.getBeat().getStart() + (long)errorMargin) {
                return true;
            }
        }
        if (nextVoice != null && !nextVoice.isEmpty() && nextVoice.isRestVoice()) {
            long nextBeatEnd = 0L;
            ArrayList<TGVoice> nextBeats = new ArrayList<TGVoice>();
            while (nextVoice != null && !nextVoice.isEmpty() && nextVoice.isRestVoice() && !nextVoice.getBeat().isTextBeat()) {
                nextBeats.add(nextVoice);
                nextBeatEnd = nextVoice.getBeat().getStart() + nextVoice.getDuration().getTime();
                nextVoice = this.getNextVoice(beats, nextVoice.getBeat(), voice);
            }
            if (nextVoice == null || nextVoice.isEmpty()) {
                nextBeatEnd = measureEnd;
            } else if (!nextVoice.isRestVoice() || nextVoice.getBeat().isTextBeat()) {
                nextBeatEnd = nextVoice.getBeat().getStart();
            }
            if (beatEnd <= nextBeatEnd + (long)errorMargin) {
                while (!nextBeats.isEmpty()) {
                    TGVoice currVoice = (TGVoice)nextBeats.get(0);
                    nextBeats.remove(currVoice);
                    this.removeVoice(currVoice, false);
                }
                return true;
            }
        }
        if (moveNextBeats && (nextVoice = this.getNextVoice(beats, beat, voice)) != null) {
            long requiredLength = beatLength - (nextVoice.getBeat().getStart() - beatStart);
            long nextSilenceLength = 0L;
            TGVoice nextRestBeat = this.getNextRestVoice(beats, beat.getVoice(voice));
            while (nextRestBeat != null) {
                nextSilenceLength += nextRestBeat.getDuration().getTime();
                nextRestBeat = this.getNextRestVoice(beats, nextRestBeat);
            }
            if (requiredLength <= nextSilenceLength + (long)errorMargin) {
                List<TGVoice> voices = this.getVoicesBeforeEnd(measure.getBeats(), nextVoice.getBeat().getStart(), voice);
                while (!voices.isEmpty()) {
                    TGVoice currVoice = voices.get(0);
                    if (currVoice.isRestVoice()) {
                        requiredLength -= currVoice.getDuration().getTime();
                        this.removeVoice(currVoice, false);
                    } else if (requiredLength > 0L) {
                        this.moveVoice(currVoice, requiredLength);
                    }
                    voices.remove(0);
                }
                return true;
            }
        }
        if (setCurrentDuration && currentVoice != null && !currentVoice.isEmpty()) {
            duration.copyFrom(currentVoice.getDuration());
            return true;
        }
        return false;
    }

    public boolean moveVoices(TGMeasure measure, long start, long theMove, int voiceIndex, TGDuration fillDuration) {
        TGDuration lastDuration;
        if (theMove == 0L) {
            return false;
        }
        boolean success = true;
        long measureStart = measure.getStart();
        long measureEnd = measureStart + measure.getLength();
        List<TGVoice> voicesToMove = this.getVoicesBeforeEnd(measure.getBeats(), start, voiceIndex);
        ArrayList<TGVoice> voicesToRemove = new ArrayList<TGVoice>();
        List<TGBeat> currentBeats = this.getBeatsBeforeEnd(measure.getBeats(), start);
        TGVoice first = this.getFirstVoice(currentBeats, voiceIndex);
        while (!(first == null || !first.isRestVoice() || first.getBeat().isTextBeat() && this.isUniqueVoice(first, false) || first.getBeat().getStart() + theMove >= measureStart)) {
            currentBeats.remove(first.getBeat());
            voicesToRemove.add(first);
            first = this.getNextVoice(currentBeats, first.getBeat(), voiceIndex);
        }
        TGVoice last = this.getLastVoice(currentBeats, voiceIndex);
        TGDuration tGDuration = lastDuration = last != null ? last.getDuration() : null;
        while (!(last == null || lastDuration == null || !last.isRestVoice() || last.getBeat().isTextBeat() && this.isUniqueVoice(last, false) || last.getBeat().getStart() + lastDuration.getTime() + theMove <= measureEnd)) {
            currentBeats.remove(last.getBeat());
            voicesToRemove.add(last);
            last = this.getPreviousVoice(currentBeats, last.getBeat(), voiceIndex);
            lastDuration = last != null ? last.getDuration() : null;
        }
        if (first != null && last != null && lastDuration != null && (first.getBeat().getStart() + theMove < measureStart || last.getBeat().getStart() + lastDuration.getTime() + theMove > measureEnd)) {
            success = false;
        }
        if (success) {
            this.moveVoices(voicesToMove, theMove);
            for (TGVoice beat : voicesToRemove) {
                this.removeVoice(beat);
            }
            if (fillDuration != null) {
                if (theMove < 0L) {
                    long beatStart;
                    last = this.getLastVoice(measure.getBeats(), voiceIndex);
                    lastDuration = last != null ? last.getDuration() : null;
                    long l = beatStart = last != null && lastDuration != null ? last.getBeat().getStart() + lastDuration.getTime() : start;
                    if (beatStart + fillDuration.getTime() <= measureEnd) {
                        boolean beatNew = false;
                        TGBeat beat = this.getBeat(measure, beatStart);
                        if (beat == null) {
                            beat = this.getSongManager().getFactory().newBeat();
                            beat.setStart(beatStart);
                            beatNew = true;
                        }
                        TGVoice voice = beat.getVoice(voiceIndex);
                        voice.setEmpty(false);
                        voice.getDuration().copyFrom(fillDuration);
                        if (beatNew) {
                            this.addBeat(measure, beat);
                        }
                    }
                } else {
                    first = this.getFirstVoice(this.getBeatsBeforeEnd(measure.getBeats(), start), voiceIndex);
                    if (start + fillDuration.getTime() <= (first != null ? first.getBeat().getStart() : measureEnd)) {
                        boolean beatNew = false;
                        TGBeat beat = this.getBeat(measure, start);
                        if (beat == null) {
                            beat = this.getSongManager().getFactory().newBeat();
                            beat.setStart(start);
                            beatNew = true;
                        }
                        TGVoice voice = beat.getVoice(voiceIndex);
                        voice.setEmpty(false);
                        voice.getDuration().copyFrom(fillDuration);
                        if (beatNew) {
                            this.addBeat(measure, beat);
                        }
                    }
                }
            }
            this.removeEmptyBeats(measure);
        }
        return success;
    }

    public boolean isUniqueVoice(TGVoice voice, boolean ignoreRests) {
        TGBeat beat = voice.getBeat();
        for (int v = 0; v < beat.countVoices(); ++v) {
            TGVoice currentVoice;
            if (v == voice.getIndex() || (currentVoice = beat.getVoice(v)).isEmpty() || ignoreRests && currentVoice.isRestVoice()) continue;
            return false;
        }
        return true;
    }

    public void transposeNotes(TGMeasure measure, int transposition, boolean tryKeepString, boolean applyToChords, int applyToString) {
        TGTrack track;
        if (transposition != 0 && measure != null && (track = measure.getTrack()) != null) {
            List<TGString> strings = this.getSortedStringsByValue(track, transposition > 0 ? 1 : -1);
            for (int i = 0; i < measure.countBeats(); ++i) {
                TGBeat beat = measure.getBeat(i);
                this.transposeNotes(beat, strings, transposition, tryKeepString, applyToChords, applyToString, track.getMaxFret());
            }
        }
    }

    public void transposeNotes(TGMeasure measure, int[] transpositionStrings, boolean tryKeepString, boolean applyToChords) {
        TGTrack track;
        if (transpositionStrings != null && transpositionStrings.length > 0 && measure != null && (track = measure.getTrack()) != null) {
            TGNote[] notes = new TGNote[transpositionStrings.length];
            for (int b = 0; b < measure.countBeats(); ++b) {
                TGBeat beat = measure.getBeat(b);
                for (int n = 0; n < notes.length; ++n) {
                    notes[n] = this.getNote(beat, n + 1);
                }
                for (int i = 0; i < notes.length; ++i) {
                    int transposition;
                    if (notes[i] == null || (transposition = transpositionStrings[i]) == 0) continue;
                    int applyToString = notes[i].getString();
                    List<TGString> strings = this.getSortedStringsByValue(track, transposition > 0 ? 1 : -1);
                    this.transposeNotes(beat, strings, transposition, tryKeepString, applyToChords, applyToString, track.getMaxFret());
                }
            }
        }
    }

    public void transposeNotes(TGBeat beat, List<TGString> strings, int transposition, boolean tryKeepString, boolean applyToChord, int applyToString, int maxFret) {
        if (transposition != 0) {
            List<TGNote> notes = this.getNotes(beat);
            int stringCount = strings.size();
            for (int i = 0; i < stringCount; ++i) {
                int chordString;
                TGString string = strings.get(stringCount - i - 1);
                if (applyToString != -1 && string.getNumber() != applyToString) continue;
                TGNote note = null;
                for (int n = 0; n < notes.size(); ++n) {
                    TGNote current = notes.get(n);
                    if (current.getString() != string.getNumber()) continue;
                    note = current;
                }
                if (note != null) {
                    this.transposeNote(note, notes, strings, transposition, tryKeepString, false, maxFret);
                }
                if (!applyToChord || !beat.isChordBeat()) continue;
                TGChord chord = beat.getChord();
                if (chord.getFretValue(chordString = string.getNumber() - 1) >= 0) {
                    this.transposeChordNote(chord, chordString, strings, transposition, tryKeepString, false, maxFret);
                }
                chord.setFirstFret(-1);
            }
        }
    }

    private boolean transposeNote(TGNote note, List<TGNote> notes, List<TGString> strings, int transposition, boolean tryKeepString, boolean forceChangeString, int maxFret) {
        boolean canTransposeFret = false;
        int transposedFret = note.getValue() + transposition;
        if (transposedFret >= 0 && transposedFret <= maxFret) {
            if (!forceChangeString && tryKeepString) {
                note.setValue(transposedFret);
                return true;
            }
            canTransposeFret = true;
        }
        int stringIndex = -1;
        for (int i = 0; i < strings.size(); ++i) {
            TGString string = strings.get(i);
            if (string.getNumber() != note.getString()) continue;
            stringIndex = i;
            break;
        }
        TGString string = strings.get(stringIndex);
        int transposedValue = string.getValue() + note.getValue() + transposition;
        for (int nextStringIndex = stringIndex + 1; nextStringIndex >= 0 && nextStringIndex < strings.size(); ++nextStringIndex) {
            TGString nextString = strings.get(nextStringIndex);
            TGNote nextOwner = null;
            for (int i = 0; i < notes.size(); ++i) {
                TGNote nextNote = notes.get(i);
                if (nextNote.getString() != nextString.getNumber()) continue;
                nextOwner = nextNote;
            }
            int transposedStringFret = transposedValue - nextString.getValue();
            if (transposedStringFret < 0 || transposedStringFret > maxFret) continue;
            if (nextOwner != null && !this.transposeNote(nextOwner, notes, strings, 0, tryKeepString, !canTransposeFret, maxFret)) {
                nextOwner = null;
            }
            if (nextOwner != null && nextOwner.getString() == nextString.getNumber()) continue;
            note.setValue(transposedStringFret);
            note.setString(nextString.getNumber());
            return true;
        }
        if (!forceChangeString && canTransposeFret) {
            note.setValue(transposedFret);
            return true;
        }
        notes.remove(note);
        this.removeNote(note);
        return false;
    }

    private boolean transposeChordNote(TGChord chord, int chordString, List<TGString> strings, int transposition, boolean tryKeepString, boolean forceChangeString, int maximumFret) {
        boolean canTransposeFret = false;
        int noteValue = chord.getFretValue(chordString);
        int noteString = chordString + 1;
        int transposedFret = noteValue + transposition;
        if (transposedFret >= 0 && transposedFret <= maximumFret) {
            if (!forceChangeString && tryKeepString) {
                chord.addFretValue(chordString, transposedFret);
                return true;
            }
            canTransposeFret = true;
        }
        int stringIndex = -1;
        for (int i = 0; i < strings.size(); ++i) {
            TGString string = strings.get(i);
            if (string.getNumber() != noteString) continue;
            stringIndex = i;
            break;
        }
        TGString string = strings.get(stringIndex);
        int transposedValue = string.getValue() + noteValue + transposition;
        for (int nextStringIndex = stringIndex + 1; nextStringIndex >= 0 && nextStringIndex < strings.size(); ++nextStringIndex) {
            TGString nextString = strings.get(nextStringIndex);
            int nextChordString = -1;
            for (int i = 0; i < chord.countStrings(); ++i) {
                if (i + 1 != nextString.getNumber() || chord.getFretValue(i) < 0) continue;
                nextChordString = i;
            }
            int transposedStringFret = transposedValue - nextString.getValue();
            if (transposedStringFret < 0 || transposedStringFret > maximumFret) continue;
            if (nextChordString >= 0) {
                this.transposeChordNote(chord, nextChordString, strings, 0, tryKeepString, !canTransposeFret, maximumFret);
            }
            if (nextChordString >= 0 && chord.getFretValue(nextChordString) >= 0) continue;
            chord.addFretValue(chordString, -1);
            chord.addFretValue(nextString.getNumber() - 1, transposedStringFret);
            return true;
        }
        if (!forceChangeString && canTransposeFret) {
            chord.addFretValue(chordString, transposedFret);
            return true;
        }
        chord.addFretValue(chordString, -1);
        return false;
    }

    public List<TGString> getSortedStringsByValue(TGTrack track, final int direction) {
        ArrayList<TGString> strings = new ArrayList<TGString>();
        for (int number = 1; number <= track.stringCount(); ++number) {
            strings.add(track.getString(number));
        }
        Collections.sort(strings, new Comparator<TGString>(){
            final /* synthetic */ TGMeasureManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int compare(TGString s1, TGString s2) {
                if (s1 != null && s2 != null) {
                    int status = s1.getValue() - s2.getValue();
                    if (status == 0) {
                        return 0;
                    }
                    return status * direction > 0 ? 1 : -1;
                }
                return 0;
            }
        });
        return strings;
    }

    public int getRealNoteValue(TGNote note) {
        TGString string;
        TGTrack track;
        TGMeasure measure;
        TGBeat beat;
        int value = note.getValue();
        TGVoice voice = note.getVoice();
        if (voice != null && (beat = voice.getBeat()) != null && (measure = beat.getMeasure()) != null && (track = measure.getTrack()) != null && (string = track.getString(note.getString())) != null) {
            value += string.getValue();
        }
        return value;
    }

    public void removeOverlappingRestBeats(TGMeasure measure) {
        ArrayList<TGBeat> beatsToRemove = new ArrayList<TGBeat>();
        for (TGBeat refBeat : measure.getBeats()) {
            for (TGBeat beat : measure.getBeats()) {
                if (!beat.isRestBeat() || refBeat.isRestBeat() || beatsToRemove.contains(beat) || beat.getEnd() <= refBeat.getStart() || beat.getStart() >= refBeat.getEnd()) continue;
                beatsToRemove.add(beat);
            }
        }
        while (beatsToRemove.size() > 0) {
            this.removeBeat((TGBeat)beatsToRemove.get(0));
            beatsToRemove.remove(0);
        }
    }
}

