/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.helpers;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGString;

public class TGStoredBeatList {
    private List<TGBeat> beats = new ArrayList<TGBeat>();
    private List<Integer> stringValues;
    private boolean isPercussionTrack;

    public TGStoredBeatList(List<TGBeat> range, List<TGString> strings, boolean isPercussionTrack, TGFactory factory) {
        long first = -1L;
        for (TGBeat beat : range) {
            if (first == -1L) {
                first = beat.getStart();
            }
            beat = beat.clone(factory);
            beat.setStart(beat.getStart() - first);
            beat.setMeasure(null);
            this.beats.add(beat);
        }
        this.stringValues = new ArrayList<Integer>();
        if (strings != null) {
            for (TGString string : strings) {
                this.stringValues.add(string.getValue());
            }
        }
        this.isPercussionTrack = isPercussionTrack;
    }

    public List<TGBeat> getBeats() {
        return this.beats;
    }

    public List<Integer> getStringValues() {
        return this.stringValues;
    }

    public boolean isPercussionTrack() {
        return this.isPercussionTrack;
    }

    public TGStoredBeatList clone(TGFactory factory) {
        TGStoredBeatList clone = new TGStoredBeatList(this.beats, null, this.isPercussionTrack, factory);
        clone.stringValues = new ArrayList<Integer>(this.stringValues);
        return clone;
    }
}

