/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.song.helpers.TGBeatRangeIterator;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGVoice;

public class TGBeatRangeNoteIterator
implements Iterator<TGNote> {
    private final TGBeatRangeIterator beatRangeIterator;
    private TGBeat currentBeat;
    private Collection<Integer> voices;
    private Iterator<Integer> voiceIterator;
    private TGVoice currentVoice;
    private Iterator<TGNote> noteIterator;

    public TGBeatRangeNoteIterator(TGBeat start, TGBeat end, Collection<Integer> voices) {
        this.beatRangeIterator = new TGBeatRangeIterator(start, end);
        this.voices = voices;
        this.updateBeat();
    }

    @Override
    public boolean hasNext() {
        this.moveToActiveNoteIteratorOrEnd();
        return this.noteIterator.hasNext();
    }

    @Override
    public TGNote next() {
        this.moveToActiveNoteIteratorOrEnd();
        return this.noteIterator.next();
    }

    private void moveToActiveNoteIteratorOrEnd() {
        while (!this.noteIterator.hasNext() && !this.isInTheEnd()) {
            if (this.voiceIterator.hasNext()) {
                this.updateVoice();
                continue;
            }
            if (!this.beatRangeIterator.hasNext()) continue;
            this.updateBeat();
        }
    }

    private void updateBeat() {
        this.currentBeat = this.beatRangeIterator.next();
        this.voiceIterator = this.voices.iterator();
        this.updateVoice();
    }

    private void updateVoice() {
        this.currentVoice = this.currentBeat.getVoice(this.voiceIterator.next());
        this.noteIterator = this.currentVoice.getNotes().iterator();
    }

    private boolean isInTheEnd() {
        return !this.noteIterator.hasNext() && !this.beatRangeIterator.hasNext() && !this.voiceIterator.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public List<TGNote> toList() {
        ArrayList<TGNote> selectedNotes = new ArrayList<TGNote>();
        while (this.hasNext()) {
            selectedNotes.add(this.next());
        }
        return selectedNotes;
    }
}

