/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.helpers;

import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.Stream;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;

public class TGBeatRangeIterator
implements Iterator<TGBeat> {
    private final TGMeasure lastMeasure;
    private Iterator<TGMeasure> measureIterator;
    private TGMeasure currentMeasure;
    private Iterator<TGBeat> beatIterator;
    private Stream<TGBeat> currentBeats;
    private final long start;
    private final long end;

    public TGBeatRangeIterator(TGBeat start, TGBeat end) {
        if (start.getMeasure().getTrack() != end.getMeasure().getTrack()) {
            throw new IllegalArgumentException("Beats must be on the same track");
        }
        if (start.getStart() > end.getStart()) {
            throw new IllegalArgumentException("Start beat must be before or equal to last beat");
        }
        this.lastMeasure = end.getMeasure();
        this.start = start.getStart();
        this.end = end.getStart();
        this.measureIterator = start.getMeasure().getTrack().getMeasures();
        while (this.currentMeasure != start.getMeasure()) {
            this.currentMeasure = this.measureIterator.next();
        }
        this.updateBeats();
    }

    @Override
    public boolean hasNext() {
        this.moveToActiveBeatIteratorOrEnd();
        return this.beatIterator.hasNext();
    }

    @Override
    public TGBeat next() {
        this.moveToActiveBeatIteratorOrEnd();
        return this.beatIterator.next();
    }

    private void moveToActiveBeatIteratorOrEnd() {
        while (!this.beatIterator.hasNext() && !this.isInTheEnd()) {
            if (!this.measureIterator.hasNext()) continue;
            this.currentMeasure = this.measureIterator.next();
            this.updateBeats();
        }
    }

    private void updateBeats() {
        this.currentBeats = this.currentMeasure.getBeats().stream().filter(b -> b.getStart() >= this.start && b.getStart() <= this.end).sorted(Comparator.comparingLong(TGBeat::getStart));
        this.beatIterator = this.currentBeats.iterator();
    }

    private boolean isInTheEnd() {
        return this.currentMeasure == this.lastMeasure && !this.beatIterator.hasNext();
    }
}

