/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.sequencer;

public class MidiTickPlayer {
    private static final long SECOND_IN_NANOS = 1000000000L;
    private int tempo;
    private long tick;
    private long time;
    private long lastTime;
    private long tickLength;
    private boolean tickChanged;

    public void process() {
        this.lastTime = this.time;
        this.time = System.nanoTime();
        if (!this.tickChanged) {
            this.tick += Math.round(960.0 * ((double)this.getTempo() * (double)(this.time - this.lastTime) / 60.0) / 1.0E9);
        }
        this.tickChanged = false;
    }

    public void clearTick() {
        this.tickLength = 0L;
    }

    public int getTempo() {
        return this.tempo;
    }

    public void setTempo(int tempo) {
        this.tempo = tempo;
    }

    public long getTick() {
        return this.tick;
    }

    public void setTick(long tick) {
        this.tick = tick;
        this.tickChanged = true;
    }

    public long getTickLength() {
        return this.tickLength;
    }

    public void notifyTick(long tick) {
        this.tickLength = Math.max(this.tickLength, tick);
    }
}

