/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.herac.tuxguitar.player.base.MidiChannel;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.base.MidiReceiver;

public class MidiChannelRouter
implements MidiReceiver {
    private Map<Integer, MidiChannel> midiChannels = new HashMap<Integer, MidiChannel>();

    public String getId() {
        return MidiChannelRouter.class.getName();
    }

    @Override
    public void sendParameter(int channelId, String key, String value) throws MidiPlayerException {
        MidiChannel midiChannel = this.getMidiChannel(channelId);
        if (midiChannel != null) {
            midiChannel.sendParameter(key, value);
        }
    }

    @Override
    public void sendNoteOn(int channelId, int key, int velocity, int voice, boolean bendMode) throws MidiPlayerException {
        MidiChannel midiChannel = this.getMidiChannel(channelId);
        if (midiChannel != null) {
            midiChannel.sendNoteOn(key, velocity, voice, bendMode);
        }
    }

    @Override
    public void sendNoteOff(int channelId, int key, int velocity, int voice, boolean bendMode) throws MidiPlayerException {
        MidiChannel midiChannel = this.getMidiChannel(channelId);
        if (midiChannel != null) {
            midiChannel.sendNoteOff(key, velocity, voice, bendMode);
        }
    }

    @Override
    public void sendPitchBend(int channelId, int value, int voice, boolean bendMode) throws MidiPlayerException {
        MidiChannel midiChannel = this.getMidiChannel(channelId);
        if (midiChannel != null) {
            midiChannel.sendPitchBend(value, voice, bendMode);
        }
    }

    @Override
    public void sendProgramChange(int channelId, int value) throws MidiPlayerException {
        MidiChannel midiChannel = this.getMidiChannel(channelId);
        if (midiChannel != null) {
            midiChannel.sendProgramChange(value);
        }
    }

    @Override
    public void sendControlChange(int channelId, int controller, int value) throws MidiPlayerException {
        MidiChannel midiChannel = this.getMidiChannel(channelId);
        if (midiChannel != null) {
            midiChannel.sendControlChange(controller, value);
        }
    }

    public void sendAllNotesOff(int channelId) throws MidiPlayerException {
        MidiChannel midiChannel = this.getMidiChannel(channelId);
        if (midiChannel != null) {
            midiChannel.sendAllNotesOff();
        }
    }

    @Override
    public void sendAllNotesOff() throws MidiPlayerException {
        List<Integer> midiChannelIds = this.getMidiChannelIds();
        for (int i = 0; i < midiChannelIds.size(); ++i) {
            this.sendAllNotesOff(midiChannelIds.get(i));
        }
    }

    @Override
    public void sendPitchBendReset() throws MidiPlayerException {
        List<Integer> midiChannelIds = this.getMidiChannelIds();
        for (int i = 0; i < midiChannelIds.size(); ++i) {
            this.sendPitchBend(midiChannelIds.get(i), 64, -1, false);
        }
    }

    public MidiChannel getMidiChannel(int channelId) {
        Integer key = channelId;
        if (this.midiChannels.containsKey(key)) {
            return this.midiChannels.get(key);
        }
        return null;
    }

    public void removeMidiChannel(int channelId) {
        Integer key = channelId;
        if (this.midiChannels.containsKey(key)) {
            this.midiChannels.remove(key);
        }
    }

    public void addMidiChannel(int channelId, MidiChannel midiChannel) {
        Integer key = channelId;
        if (this.midiChannels.containsKey(key)) {
            this.midiChannels.remove(key);
        }
        this.midiChannels.put(key, midiChannel);
    }

    public List<Integer> getMidiChannelIds() {
        ArrayList<Integer> midiChannelIds = new ArrayList<Integer>();
        Iterator<Integer> iterator = this.midiChannels.keySet().iterator();
        while (iterator.hasNext()) {
            midiChannelIds.add(iterator.next());
        }
        return midiChannelIds;
    }
}

