/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGSongWriter;
import org.herac.tuxguitar.io.base.TGSongWriterHandle;
import org.herac.tuxguitar.io.tg.TGStream;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChannelParameter;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDivisionType;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGLyric;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGStroke;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import org.herac.tuxguitar.song.models.effects.TGEffectTrill;

public class TGSongWriterImpl
extends TGStream
implements TGSongWriter {
    private DataOutputStream dataOutputStream;

    @Override
    public TGFileFormat getFileFormat() {
        return TG_FORMAT;
    }

    @Override
    public void write(TGSongWriterHandle handle) throws TGFileFormatException {
        try {
            this.dataOutputStream = new DataOutputStream(handle.getOutputStream());
            this.writeVersion();
            this.write(handle.getSong());
            this.dataOutputStream.flush();
            this.dataOutputStream.close();
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }

    private void writeVersion() throws IOException {
        this.writeUnsignedByteString(TG_FORMAT_VERSION);
    }

    private void write(TGSong song) throws IOException {
        this.writeUnsignedByteString(song.getName());
        this.writeUnsignedByteString(song.getArtist());
        this.writeUnsignedByteString(song.getAlbum());
        this.writeUnsignedByteString(song.getAuthor());
        this.writeUnsignedByteString(song.getDate());
        this.writeUnsignedByteString(song.getCopyright());
        this.writeUnsignedByteString(song.getWriter());
        this.writeUnsignedByteString(song.getTranscriber());
        this.writeIntegerString(song.getComments());
        this.writeByte(song.countChannels());
        for (int i = 0; i < song.countChannels(); ++i) {
            this.writeChannel(song.getChannel(i));
        }
        this.writeShort((short)song.countMeasureHeaders());
        TGMeasureHeader lastHeader = null;
        Iterator<TGMeasureHeader> headers = song.getMeasureHeaders();
        while (headers.hasNext()) {
            TGMeasureHeader header = headers.next();
            this.writeMeasureHeader(header, lastHeader);
            lastHeader = header;
        }
        this.writeByte(song.countTracks());
        for (int i = 0; i < song.countTracks(); ++i) {
            this.writeTrack(song.getTrack(i));
        }
    }

    private void writeTrack(TGTrack track) throws IOException {
        int header = 0;
        if (track.isSolo()) {
            header |= 1;
        }
        if (track.isMute()) {
            header |= 2;
        }
        if (!track.getLyrics().isEmpty()) {
            header |= 4;
        }
        this.writeHeader(header);
        this.writeUnsignedByteString(track.getName());
        this.writeShort((short)track.getChannelId());
        TGMeasure lastMeasure = null;
        Iterator<TGMeasure> measures = track.getMeasures();
        while (measures.hasNext()) {
            TGMeasure measure = measures.next();
            this.writeMeasure(measure, lastMeasure);
            lastMeasure = measure;
        }
        this.writeByte(track.getStrings().size());
        for (TGString string : track.getStrings()) {
            this.writeInstrumentString(string);
        }
        this.writeByte(track.getOffset() - -24);
        this.writeRGBColor(track.getColor());
        if ((header & 4) != 0) {
            this.writeLyrics(track.getLyrics());
        }
    }

    private void writeMeasureHeader(TGMeasureHeader measureheader, TGMeasureHeader lastMeasureHeader) throws IOException {
        int header = 0;
        if (lastMeasureHeader == null) {
            header |= 1;
            header |= 2;
            if (measureheader.getTripletFeel() != 1) {
                header |= 0x40;
            }
        } else {
            int numerator = measureheader.getTimeSignature().getNumerator();
            int value = measureheader.getTimeSignature().getDenominator().getValue();
            int prevNumerator = lastMeasureHeader.getTimeSignature().getNumerator();
            int prevValue = lastMeasureHeader.getTimeSignature().getDenominator().getValue();
            if (numerator != prevNumerator || value != prevValue) {
                header |= 1;
            }
            if (measureheader.getTempo().getValue() != lastMeasureHeader.getTempo().getValue()) {
                header |= 2;
            }
            if (measureheader.getTripletFeel() != lastMeasureHeader.getTripletFeel()) {
                header |= 0x40;
            }
        }
        header = measureheader.isRepeatOpen() ? (header = header | 4) : header;
        header = measureheader.getRepeatClose() > 0 ? (header = header | 8) : header;
        header = measureheader.getRepeatAlternative() > 0 ? (header = header | 0x10) : header;
        header = measureheader.hasMarker() ? (header = header | 0x20) : header;
        this.writeHeader(header);
        if ((header & 1) != 0) {
            this.writeTimeSignature(measureheader.getTimeSignature());
        }
        if ((header & 2) != 0) {
            this.writeTempo(measureheader.getTempo());
        }
        if ((header & 8) != 0) {
            this.writeShort((short)measureheader.getRepeatClose());
        }
        if ((header & 0x10) != 0) {
            this.writeByte(measureheader.getRepeatAlternative());
        }
        if ((header & 0x20) != 0) {
            this.writeMarker(measureheader.getMarker());
        }
        if ((header & 0x40) != 0) {
            this.writeByte(measureheader.getTripletFeel());
        }
    }

    private void writeMeasure(TGMeasure measure, TGMeasure lastMeasure) throws IOException {
        int header = 0;
        if (lastMeasure == null) {
            header |= 1;
            header |= 2;
        } else {
            if (measure.getClef() != lastMeasure.getClef()) {
                header |= 1;
            }
            if (measure.getKeySignature() != lastMeasure.getKeySignature()) {
                header |= 2;
            }
        }
        this.writeHeader(header);
        TGStream.TGBeatData data = new TGStream.TGBeatData(measure);
        this.writeBeats(measure, data);
        if ((header & 1) != 0) {
            this.writeByte(measure.getClef());
        }
        if ((header & 2) != 0) {
            this.writeByte(measure.getKeySignature());
        }
    }

    private void writeChannel(TGChannel channel) throws IOException {
        this.writeShort((short)channel.getChannelId());
        this.writeByte(channel.getBank());
        this.writeByte(channel.getProgram());
        this.writeByte(channel.getVolume());
        this.writeByte(channel.getBalance());
        this.writeByte(channel.getChorus());
        this.writeByte(channel.getReverb());
        this.writeByte(channel.getPhaser());
        this.writeByte(channel.getTremolo());
        this.writeUnsignedByteString(channel.getName());
        this.writeChannelParameters(channel);
    }

    private void writeChannelParameters(TGChannel channel) throws IOException {
        this.writeShort((short)channel.countParameters());
        Iterator<TGChannelParameter> iterator = channel.getParameters();
        while (iterator.hasNext()) {
            this.writeChannelParameter(iterator.next());
        }
    }

    private void writeChannelParameter(TGChannelParameter parameter) throws IOException {
        this.writeUnsignedByteString(parameter.getKey());
        this.writeIntegerString(parameter.getValue());
    }

    private void writeBeats(TGMeasure measure, TGStream.TGBeatData data) throws IOException {
        int count = measure.countBeats();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                TGBeat beat = measure.getBeat(i);
                this.writeBeat(beat, data, i + 1 < count);
            }
        } else {
            this.writeBeat(null, data, false);
        }
    }

    private void writeBeat(TGBeat beat, TGStream.TGBeatData data, boolean hasNext) throws IOException {
        int header;
        int n = header = hasNext ? 1 : 0;
        if (beat != null) {
            for (int i = 0; i < 2; ++i) {
                int flags;
                int shift = i * 2;
                if (beat.getVoice(i).isEmpty()) continue;
                header |= 16 << shift;
                int n2 = flags = beat.getVoice(i).isRestVoice() ? 0 : 1;
                if (!beat.getVoice(i).getDuration().isEqual(data.getVoice(i).getDuration())) {
                    flags |= 2;
                    data.getVoice(i).setDuration(beat.getVoice(i).getDuration());
                }
                if (beat.getVoice(i).getDirection() != 0) {
                    if (beat.getVoice(i).getDirection() == 1) {
                        flags |= 4;
                    } else if (beat.getVoice(i).getDirection() == 2) {
                        flags |= 8;
                    }
                }
                if (data.getVoice(i).getFlags() == flags) continue;
                header |= 32 << shift;
                data.getVoice(i).setFlags(flags);
            }
            if (beat.getStroke().getDirection() != 0) {
                header |= 2;
            }
            if (beat.getChord() != null) {
                header |= 4;
            }
            if (beat.getText() != null) {
                header |= 8;
            }
        }
        this.writeHeader(header);
        this.writeVoices(header, beat, data);
        if ((header & 2) != 0) {
            this.writeStroke(beat.getStroke());
        }
        if ((header & 4) != 0) {
            this.writeChord(beat.getChord());
        }
        if ((header & 8) != 0) {
            this.writeText(beat.getText());
        }
    }

    private void writeVoices(int header, TGBeat beat, TGStream.TGBeatData data) throws IOException {
        for (int i = 0; i < 2; ++i) {
            int shift = i * 2;
            if ((header & 16 << shift) == 0) continue;
            if ((header & 32 << shift) != 0) {
                this.writeHeader(data.getVoice(i).getFlags());
            }
            if ((data.getVoice(i).getFlags() & 2) != 0) {
                this.writeDuration(beat.getVoice(i).getDuration());
            }
            if ((data.getVoice(i).getFlags() & 1) == 0) continue;
            this.writeNotes(beat.getVoice(i), data);
        }
    }

    private void writeNotes(TGVoice voice, TGStream.TGBeatData data) throws IOException {
        for (int i = 0; i < voice.countNotes(); ++i) {
            TGNote note = voice.getNote(i);
            int header = i + 1 < voice.countNotes() ? 1 : 0;
            int n = header = note.isTiedNote() ? (header = header | 2) : header;
            if (note.getVelocity() != data.getVoice(voice.getIndex()).getVelocity()) {
                data.getVoice(voice.getIndex()).setVelocity(note.getVelocity());
                header |= 8;
            }
            header = note.getEffect().hasAnyEffect() ? (header = header | 4) : header;
            this.writeHeader(header);
            this.writeNote(header, note);
        }
    }

    private void writeNote(int header, TGNote note) throws IOException {
        this.writeByte(note.getValue());
        this.writeByte(note.getString());
        if ((header & 8) != 0) {
            this.writeByte(note.getVelocity());
        }
        if ((header & 4) != 0) {
            this.writeNoteEffect(note.getEffect());
        }
    }

    private void writeStroke(TGStroke stroke) throws IOException {
        this.writeByte(stroke.getDirection());
        this.writeByte(stroke.getValue());
    }

    private void writeChord(TGChord chord) throws IOException {
        this.writeByte(chord.countStrings());
        this.writeUnsignedByteString(chord.getName());
        this.writeByte(chord.getFirstFret());
        for (int string = 0; string < chord.countStrings(); ++string) {
            this.writeByte(chord.getFretValue(string));
        }
    }

    private void writeText(TGText text) throws IOException {
        this.writeUnsignedByteString(text.getValue());
    }

    private void writeInstrumentString(TGString string) throws IOException {
        this.writeByte(string.getValue());
    }

    private void writeTempo(TGTempo tempo) throws IOException {
        this.writeShort((short)tempo.getValue());
    }

    private void writeTimeSignature(TGTimeSignature timeSignature) throws IOException {
        this.writeByte(timeSignature.getNumerator());
        this.writeDuration(timeSignature.getDenominator());
    }

    private void writeDuration(TGDuration duration) throws IOException {
        int header = 0;
        header = duration.isDotted() ? (header = header | 1) : header;
        header = duration.isDoubleDotted() ? (header = header | 2) : header;
        header = !duration.getDivision().isEqual(TGDivisionType.NORMAL) ? (header = header | 4) : header;
        this.writeHeader(header);
        this.writeByte(duration.getValue());
        if ((header & 4) != 0) {
            this.writeDivisionType(duration.getDivision());
        }
    }

    private void writeDivisionType(TGDivisionType divisionType) throws IOException {
        this.writeByte(divisionType.getEnters());
        this.writeByte(divisionType.getTimes());
    }

    private void writeNoteEffect(TGNoteEffect effect) throws IOException {
        int header = 0;
        header = effect.isBend() ? (header = header | 1) : header;
        header = effect.isTremoloBar() ? (header = header | 2) : header;
        header = effect.isHarmonic() ? (header = header | 4) : header;
        header = effect.isGrace() ? (header = header | 8) : header;
        header = effect.isTrill() ? (header = header | 0x10) : header;
        header = effect.isTremoloPicking() ? (header = header | 0x20) : header;
        header = effect.isVibrato() ? (header = header | 0x40) : header;
        header = effect.isDeadNote() ? (header = header | 0x80) : header;
        header = effect.isSlide() ? (header = header | 0x100) : header;
        header = effect.isHammer() ? (header = header | 0x200) : header;
        header = effect.isGhostNote() ? (header = header | 0x400) : header;
        header = effect.isAccentuatedNote() ? (header = header | 0x800) : header;
        header = effect.isHeavyAccentuatedNote() ? (header = header | 0x1000) : header;
        header = effect.isPalmMute() ? (header = header | 0x2000) : header;
        header = effect.isStaccato() ? (header = header | 0x4000) : header;
        header = effect.isTapping() ? (header = header | 0x8000) : header;
        header = effect.isSlapping() ? (header = header | 0x10000) : header;
        header = effect.isPopping() ? (header = header | 0x20000) : header;
        header = effect.isFadeIn() ? (header = header | 0x40000) : header;
        header = effect.isLetRing() ? (header = header | 0x80000) : header;
        this.writeHeader(header, 3);
        if ((header & 1) != 0) {
            this.writeBendEffect(effect.getBend());
        }
        if ((header & 2) != 0) {
            this.writeTremoloBarEffect(effect.getTremoloBar());
        }
        if ((header & 4) != 0) {
            this.writeHarmonicEffect(effect.getHarmonic());
        }
        if ((header & 8) != 0) {
            this.writeGraceEffect(effect.getGrace());
        }
        if ((header & 0x10) != 0) {
            this.writeTrillEffect(effect.getTrill());
        }
        if ((header & 0x20) != 0) {
            this.writeTremoloPickingEffect(effect.getTremoloPicking());
        }
    }

    private void writeBendEffect(TGEffectBend effect) throws IOException {
        this.writeByte(effect.getPoints().size());
        for (TGEffectBend.BendPoint point : effect.getPoints()) {
            this.writeByte(point.getPosition());
            this.writeByte(point.getValue());
        }
    }

    private void writeTremoloBarEffect(TGEffectTremoloBar effect) throws IOException {
        this.writeByte(effect.getPoints().size());
        for (TGEffectTremoloBar.TremoloBarPoint point : effect.getPoints()) {
            this.writeByte(point.getPosition());
            this.writeByte(point.getValue() + 12);
        }
    }

    private void writeHarmonicEffect(TGEffectHarmonic effect) throws IOException {
        this.writeByte(effect.getType());
        if (effect.getType() != 1) {
            this.writeByte(effect.getData());
        }
    }

    private void writeGraceEffect(TGEffectGrace effect) throws IOException {
        int header = 0;
        header = effect.isDead() ? (header = header | 1) : header;
        header = effect.isOnBeat() ? (header = header | 2) : header;
        this.writeHeader(header);
        this.writeByte(effect.getFret());
        this.writeByte(effect.getDuration());
        this.writeByte(effect.getDynamic());
        this.writeByte(effect.getTransition());
    }

    private void writeTremoloPickingEffect(TGEffectTremoloPicking effect) throws IOException {
        this.writeByte(effect.getDuration().getValue());
    }

    private void writeTrillEffect(TGEffectTrill effect) throws IOException {
        this.writeByte(effect.getFret());
        this.writeByte(effect.getDuration().getValue());
    }

    private void writeMarker(TGMarker marker) throws IOException {
        this.writeUnsignedByteString(marker.getTitle());
        this.writeRGBColor(marker.getColor());
    }

    private void writeRGBColor(TGColor color) throws IOException {
        this.writeByte(color.getR());
        this.writeByte(color.getG());
        this.writeByte(color.getB());
    }

    private void writeLyrics(TGLyric lyrics) throws IOException {
        this.writeShort((short)lyrics.getFrom());
        this.writeIntegerString(lyrics.getLyrics());
    }

    public void writeByte(int v) throws IOException {
        this.dataOutputStream.write(v);
    }

    private void writeUnsignedByteString(String v) throws IOException {
        String byteString = v == null ? new String() : (v.length() > 255 ? v.substring(0, 255) : v);
        this.dataOutputStream.write(byteString.length());
        this.dataOutputStream.writeChars(byteString);
    }

    private void writeIntegerString(String v) throws IOException {
        this.dataOutputStream.writeInt(v.length());
        this.dataOutputStream.writeChars(v);
    }

    public void writeHeader(int v) throws IOException {
        this.dataOutputStream.write(v);
    }

    public void writeHeader(int v, int bCount) throws IOException {
        for (int i = bCount; i > 0; --i) {
            this.writeHeader(v >>> 8 * i - 8 & 0xFF);
        }
    }

    public void writeShort(short v) throws IOException {
        this.dataOutputStream.writeShort(v);
    }
}

