/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.base;

import java.io.IOException;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.io.base.TGSongPersistenceHelper;
import org.herac.tuxguitar.io.base.TGSongWriter;
import org.herac.tuxguitar.io.base.TGSongWriterHandle;
import org.herac.tuxguitar.util.TGContext;

public class TGSongWriterHelper
extends TGSongPersistenceHelper {
    public TGSongWriterHelper(TGContext context) {
        super(context);
    }

    public void write(TGSongWriterHandle handle) throws TGFileFormatException {
        try {
            TGSongWriter writer;
            boolean success = false;
            if (handle.getFormat() == null) {
                handle.setFormat(this.detectFileFormat(handle));
            }
            if (handle.getFormat() != null && (writer = TGFileFormatManager.getInstance(this.getContext()).findSongWriter(handle.getFormat())) != null) {
                writer.write(handle);
                success = true;
            }
            if (!success) {
                throw new TGFileFormatException("error.unsupported-format");
            }
        }
        catch (TGFileFormatException tgFileFormatException) {
            throw tgFileFormatException;
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
        finally {
            try {
                handle.getOutputStream().close();
            }
            catch (IOException e) {
                throw new TGFileFormatException(e);
            }
        }
    }

    public TGFileFormat detectFileFormat(TGSongWriterHandle handle) throws IOException {
        TGFileFormat fileFormat;
        TGFileFormat fileFormat2;
        TGFileFormatManager fileFormatManager = TGFileFormatManager.getInstance(this.getContext());
        String mimeType = (String)handle.getContext().getAttribute("mimeType");
        if (mimeType != null && (fileFormat2 = fileFormatManager.findWriterFileFormatByMimeType(mimeType)) != null) {
            return fileFormat2;
        }
        String formatCode = (String)handle.getContext().getAttribute("formatCode");
        if (formatCode != null && (fileFormat = fileFormatManager.findWriterFileFormatByCode(formatCode)) != null) {
            return fileFormat;
        }
        return null;
    }
}

