/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.base;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatDetector;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.io.base.TGFileFormatUtils;
import org.herac.tuxguitar.io.base.TGSongPersistenceHelper;
import org.herac.tuxguitar.io.base.TGSongReader;
import org.herac.tuxguitar.io.base.TGSongReaderHandle;
import org.herac.tuxguitar.util.TGContext;

public class TGSongReaderHelper
extends TGSongPersistenceHelper {
    public TGSongReaderHelper(TGContext context) {
        super(context);
    }

    public void read(TGSongReaderHandle handle) throws TGFileFormatException {
        try {
            boolean success = false;
            byte[] buffer = TGFileFormatUtils.getBytes(handle.getInputStream());
            if (handle.getFormat() == null) {
                handle.setFormat(this.detectFileFormat(handle, buffer));
            }
            if (handle.getFormat() != null) {
                handle.setInputStream(new ByteArrayInputStream(buffer));
                TGSongReader reader = TGFileFormatManager.getInstance(this.getContext()).findSongReader(handle.getFormat());
                if (reader != null) {
                    reader.read(handle);
                    success = true;
                }
            }
            if (!success) {
                throw new TGFileFormatException("error.unsupported-format");
            }
        }
        catch (TGFileFormatException tgFileFormatException) {
            throw tgFileFormatException;
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
        finally {
            try {
                handle.getInputStream().close();
            }
            catch (IOException e) {
                throw new TGFileFormatException(e);
            }
        }
    }

    public TGFileFormat detectFileFormat(TGSongReaderHandle handle, byte[] buffer) throws IOException {
        TGFileFormat fileFormat;
        TGFileFormat fileFormat2;
        TGFileFormatManager fileFormatManager = TGFileFormatManager.getInstance(this.getContext());
        List<TGFileFormatDetector> detectors = fileFormatManager.getFileFormatDetectors();
        for (TGFileFormatDetector detector : detectors) {
            handle.setInputStream(new ByteArrayInputStream(buffer));
            fileFormat2 = detector.getFileFormat(handle.getInputStream());
            if (fileFormat2 == null) continue;
            return fileFormat2;
        }
        String mimeType = (String)handle.getContext().getAttribute("mimeType");
        if (mimeType != null && (fileFormat = fileFormatManager.findReaderFileFormatByMimeType(mimeType)) != null) {
            return fileFormat;
        }
        String formatCode = (String)handle.getContext().getAttribute("formatCode");
        if (formatCode != null && (fileFormat2 = fileFormatManager.findReaderFileFormatByCode(formatCode)) != null) {
            return fileFormat2;
        }
        return null;
    }
}

