/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.graphics.control;

import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.ui.resource.UIPainter;

public class TGTrackImpl
extends TGTrack {
    private float tabHeight;
    private float scoreHeight;

    public TGTrackImpl(TGFactory factory) {
        super(factory);
    }

    public void update(TGLayout layout) {
        this.calculateTabHeight(layout);
        this.calculateScoreHeight(layout);
    }

    public void calculateTabHeight(TGLayout layout) {
        this.tabHeight = (layout.getStyle() & 8) != 0 ? (float)(this.stringCount() - 1) * layout.getStringSpacing() : 0.0f;
    }

    public void calculateScoreHeight(TGLayout layout) {
        this.scoreHeight = (layout.getStyle() & 4) != 0 ? layout.getScoreLineSpacing() * 4.0f : 0.0f;
    }

    public float getTabHeight() {
        return this.tabHeight;
    }

    public float getScoreHeight() {
        return this.scoreHeight;
    }

    public void setTabHeight(float tabHeight) {
        this.tabHeight = tabHeight;
    }

    public void paintBeatSelection(TGLayout viewLayout, UIPainter painter, TGBeat from, TGBeat to) {
        TGMeasureImpl fromMeasure = (TGMeasureImpl)from.getMeasure();
        TGMeasureImpl toMeasure = (TGMeasureImpl)to.getMeasure();
        if (fromMeasure.getNumber() == toMeasure.getNumber()) {
            fromMeasure.paintInternalSelection(viewLayout, painter, from, to);
        } else {
            fromMeasure.paintSelectionStart(viewLayout, painter, from);
            for (int i = fromMeasure.getNumber(); i < toMeasure.getNumber() - 1; ++i) {
                TGMeasureImpl measure = (TGMeasureImpl)this.getMeasure(i);
                measure.paintFullSelection(viewLayout, painter);
            }
            toMeasure.paintSelectionEnd(viewLayout, painter, to);
        }
    }
}

