/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.graphics.control;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGLayoutStyles;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UIColorModel;
import org.herac.tuxguitar.ui.resource.UIFont;
import org.herac.tuxguitar.ui.resource.UIFontAlignment;
import org.herac.tuxguitar.ui.resource.UIFontModel;
import org.herac.tuxguitar.ui.resource.UIResource;
import org.herac.tuxguitar.ui.resource.UIResourceFactory;

public class TGResources {
    private List<UIResource> resources;
    private TGLayout layout;
    private UIFont defaultFont;
    private UIFont noteFont;
    private UIFont lyricFont;
    private UIFont textFont;
    private UIFont markerFont;
    private UIFont graceFont;
    private UIFont chordFont;
    private UIFont chordFretFont;
    private UIColor foregroundColor;
    private UIColor backgroundColor;
    private UIColor backgroundColorPlaying;
    private UIColor lineColor;
    private UIColor scoreNoteColor;
    private UIColor tabNoteColor;
    private UIColor playNoteColor;
    private UIColor selectionColor;
    private UIColor colorWhite;
    private UIColor colorBlack;
    private UIColor loopSMarkerColor;
    private UIColor loopEMarkerColor;
    private UIColor measureNumberColor;

    public TGResources(TGLayout layout) {
        this.layout = layout;
        this.resources = new ArrayList<UIResource>();
    }

    public void load(TGLayoutStyles styles) {
        this.dispose();
        this.initFonts(styles);
        this.initColors(styles);
    }

    public TGLayout getLayout() {
        return this.layout;
    }

    public UIFont getDefaultFont() {
        return this.defaultFont;
    }

    public UIFont getNoteFont() {
        return this.noteFont;
    }

    public UIFont getLyricFont() {
        return this.lyricFont;
    }

    public UIFont getTextFont() {
        return this.textFont;
    }

    public UIFont getMarkerFont() {
        return this.markerFont;
    }

    public UIFont getChordFont() {
        return this.chordFont;
    }

    public UIFont getChordFretFont() {
        return this.chordFretFont;
    }

    public UIFont getGraceFont() {
        return this.graceFont;
    }

    public UIColor getForegroundColor() {
        return this.foregroundColor;
    }

    public UIColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public UIColor getBackgroundColorPlaying() {
        return this.backgroundColorPlaying;
    }

    public UIColor getLineColor() {
        return this.lineColor;
    }

    public UIColor getPlayNoteColor() {
        return this.playNoteColor;
    }

    public UIColor getScoreNoteColor() {
        return this.scoreNoteColor;
    }

    public UIColor getTabNoteColor() {
        return this.tabNoteColor;
    }

    public UIColor getSelectionColor() {
        return this.selectionColor;
    }

    public UIColor getColorWhite() {
        return this.colorWhite;
    }

    public UIColor getColorBlack() {
        return this.colorBlack;
    }

    public UIColor getLoopSMarkerColor() {
        return this.loopSMarkerColor;
    }

    public UIColor getLoopEMarkerColor() {
        return this.loopEMarkerColor;
    }

    public UIColor getMeasureNumberColor() {
        return this.measureNumberColor;
    }

    private void initFonts(TGLayoutStyles style) {
        float scale = this.layout.getFontScale();
        this.defaultFont = this.getFont(style.getDefaultFont(), scale);
        this.noteFont = this.getFont(style.getNoteFont(), scale);
        this.lyricFont = this.getFont(style.getLyricFont(), scale);
        this.textFont = this.getFont(style.getTextFont(), scale);
        this.markerFont = this.getFont(style.getMarkerFont(), scale);
        this.graceFont = this.getFont(style.getGraceFont(), scale);
        this.chordFont = this.getFont(style.getChordFont(), scale);
        this.chordFretFont = this.getFont(style.getChordFretFont(), scale);
    }

    private void initColors(TGLayoutStyles style) {
        this.foregroundColor = this.getColor(style.getForegroundColor());
        this.backgroundColor = this.getColor(style.getBackgroundColor());
        this.backgroundColorPlaying = this.getColor(style.getBackgroundColorPlaying());
        this.lineColor = this.getColor(style.getLineColor());
        this.scoreNoteColor = this.getColor(style.getScoreNoteColor());
        this.tabNoteColor = this.getColor(style.getTabNoteColor());
        this.playNoteColor = this.getColor(style.getPlayNoteColor());
        this.selectionColor = this.getColor(style.getSelectionColor());
        this.loopSMarkerColor = this.getColor(style.getLoopSMarkerColor());
        this.loopEMarkerColor = this.getColor(style.getLoopEMarkerColor());
        this.measureNumberColor = this.getColor(style.getMeasureNumberColor());
        this.colorWhite = this.getColor(new UIColorModel(255, 255, 255));
        this.colorBlack = this.getColor(new UIColorModel(0, 0, 0));
    }

    private UIFont getFont(UIFontModel model, float scale) {
        UIResourceFactory factory = this.getLayout().getComponent().getResourceFactory();
        UIFontModel fm = new UIFontModel();
        if (model != null) {
            float height = model.getHeight() * scale;
            fm.setHeight(height > 1.0f ? Math.round(height) : 1);
            fm.setName(model.getName());
            fm.setBold(model.isBold());
            fm.setItalic(model.isItalic());
            if (model.getAlignment() != null) {
                fm.setAlignment(new UIFontAlignment());
                fm.getAlignment().setTop(model.getAlignment().getTop() * scale);
                fm.getAlignment().setMiddle(model.getAlignment().getMiddle() * scale);
                fm.getAlignment().setBottom(model.getAlignment().getBottom() * scale);
            }
        }
        return (UIFont)this.addResource(factory.createFont(fm));
    }

    private UIColor getColor(UIColorModel model) {
        UIResourceFactory factory = this.getLayout().getComponent().getResourceFactory();
        UIColorModel cm = model != null ? model : new UIColorModel();
        return (UIColor)this.addResource(factory.createColor(cm));
    }

    private UIResource addResource(UIResource resource) {
        this.resources.add(resource);
        return resource;
    }

    public void dispose() {
        for (UIResource resource : this.resources) {
            resource.dispose();
        }
        this.resources.clear();
    }
}

