/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.graphics.control;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.graphics.control.TGBeatGroup;
import org.herac.tuxguitar.graphics.control.TGBeatImpl;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGMeasureBuffer;
import org.herac.tuxguitar.graphics.control.TGMeasureHeaderImpl;
import org.herac.tuxguitar.graphics.control.TGNoteImpl;
import org.herac.tuxguitar.graphics.control.TGResourceBuffer;
import org.herac.tuxguitar.graphics.control.TGTextImpl;
import org.herac.tuxguitar.graphics.control.TGTrackImpl;
import org.herac.tuxguitar.graphics.control.TGTrackSpacing;
import org.herac.tuxguitar.graphics.control.TGVoiceImpl;
import org.herac.tuxguitar.graphics.control.painters.TGClefPainter;
import org.herac.tuxguitar.graphics.control.painters.TGKeySignaturePainter;
import org.herac.tuxguitar.graphics.control.painters.TGNumberPainter;
import org.herac.tuxguitar.graphics.control.painters.TGTempoPainter;
import org.herac.tuxguitar.graphics.control.painters.TGTripletFeelPainter;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGDivisionType;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UIPainter;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.resource.UIResourceFactory;
import org.herac.tuxguitar.util.TGMusicKeyUtils;

public class TGMeasureImpl
extends TGMeasure {
    public static final int[][] SCORE_KEY_SHARP_POSITIONS = new int[][]{{1, 4, 0, 3, 6, 2, 5}, {3, 6, 2, 5, 8, 4, 7}, {7, 3, 6, 2, 5, 1, 4}, {2, 5, 1, 4, 7, 3, 6}};
    public static final int[][] SCORE_KEY_FLAT_POSITIONS = new int[][]{{5, 2, 6, 3, 7, 4, 8}, {7, 4, 8, 5, 9, 6, 10}, {4, 1, 5, 2, 6, 3, 7}, {6, 3, 7, 4, 8, 5, 9}};
    private static final int SELECTION_ALPHA = 18;
    private static final int DEFAULT_CLEF_WIDTH = 16;
    private float posX;
    private float posY;
    private float quarterSpacing;
    private long divisionLength;
    private boolean paintClef = true;
    private boolean paintKeySignature = true;
    private TGMeasureImpl previousMeasure;
    private boolean outOfBounds;
    private boolean firstOfLine;
    private boolean compactMode;
    private float spacing;
    private TGTrackSpacing ts;
    private float maxY;
    private float minY;
    private int notEmptyVoices;
    private int notEmptyBeats;
    private float widthBeats = 0.0f;
    private List<TGBeatGroup>[] voiceGroups;
    private TGMeasureBuffer buffer;
    private boolean bufferCreated;
    private int lyricBeatIndex;
    private float width;
    private float beatEffectVerticalSpacing;
    private float effectWidth;
    private boolean text;
    private boolean chord;
    private boolean division1;
    private boolean division2;
    private boolean[][] registeredAccidentals = new boolean[11][7];
    private boolean readyToPaint = false;
    private boolean wasPlayingWhenLastPainted;

    public TGMeasureImpl(TGMeasureHeader header) {
        super(header);
        this.voiceGroups = new List[2];
        for (int v = 0; v < 2; ++v) {
            this.voiceGroups[v] = new ArrayList<TGBeatGroup>();
        }
    }

    public void create(TGLayout layout) {
        this.readyToPaint = false;
        this.divisionLength = TGSongManager.getDivisionLength(this.getHeader());
        this.resetSpacing();
        this.autoCompleteSilences(layout.getSongManager());
        this.orderBeats(layout.getSongManager());
        this.checkCompactMode(layout);
        this.clearRegisteredAccidentals();
        this.calculateBeats(layout);
        this.calculateWidth(layout);
        this.setFirstOfLine(false);
    }

    public void update(TGLayout layout) {
        this.registerBuffer(layout);
        this.updateComponents(layout);
        this.setOutOfBounds(true);
        this.setBufferCreated(false);
        this.readyToPaint = true;
    }

    public boolean getCompactMode() {
        return this.compactMode;
    }

    private void checkCompactMode(TGLayout layout) {
        boolean compactMode;
        boolean bl = compactMode = (layout.getStyle() & 1) != 0;
        if (compactMode && (layout.getStyle() & 2) != 0) {
            compactMode = layout.getSong().countTracks() == 1;
        }
        this.compactMode = compactMode;
    }

    private void clearRegisteredAccidentals() {
        for (int i = 0; i < 11; ++i) {
            for (int n = 0; n < 7; ++n) {
                this.registeredAccidentals[i][n] = false;
            }
        }
    }

    public void calculateWidth(TGLayout layout) {
        if (this.compactMode) {
            this.width = this.widthBeats;
        } else {
            this.width = this.getMaxQuarterSpacing(layout) * this.getTimeSignature().getQuartersInSignature();
            this.width += this.getMaxEffectWidth(layout);
        }
        this.width += this.getFirstNoteSpacing(layout);
        this.width += this.getRepeatClose() > 0 ? 20.0f * layout.getScale() : 0.0f;
        this.width += this.getHeaderImpl().getLeftSpacing(layout);
        this.width += this.getHeaderImpl().getRightSpacing(layout);
        this.getHeaderImpl().notifyWidth(this.width);
    }

    private void calculateBeats(TGLayout layout) {
        int v;
        TGChord previousChord = null;
        TGDuration minDuration = null;
        TGBeatImpl previousBeat = null;
        TGVoiceImpl[] previousVoices = new TGVoiceImpl[2];
        TGBeatGroup[] groups = new TGBeatGroup[2];
        int style = layout.getStyle();
        long minimumChordLength = 0L;
        boolean[] notEmptyVoicesChecked = new boolean[2];
        boolean chordEnabled = (style & 0x30) != 0;
        this.widthBeats = 0.0f;
        this.notEmptyBeats = 0;
        this.notEmptyVoices = 0;
        this.effectWidth = 0.0f;
        for (v = 0; v < 2; ++v) {
            this.voiceGroups[v].clear();
        }
        for (int i = 0; i < this.countBeats(); ++i) {
            TGBeatImpl beat = (TGBeatImpl)this.getBeat(i);
            beat.reset();
            if (chordEnabled && beat.getChord() != null) {
                if (previousChord != null) {
                    long length = beat.getStart() - previousChord.getBeat().getStart();
                    minimumChordLength = minimumChordLength > 0L ? Math.min(minimumChordLength, Math.abs(length)) : length;
                }
                previousChord = beat.getChord();
            }
            boolean emptyBeat = true;
            float beatEffectWidth = 0.0f;
            for (int v2 = 0; v2 < 2; ++v2) {
                TGVoiceImpl voice = (TGVoiceImpl)beat.getVoice(v2);
                if (voice.isEmpty()) continue;
                emptyBeat = false;
                voice.reset();
                if (minDuration == null || voice.getDuration().getTime() <= minDuration.getTime()) {
                    minDuration = voice.getDuration();
                }
                if (!notEmptyVoicesChecked[v2]) {
                    notEmptyVoicesChecked[v2] = true;
                    ++this.notEmptyVoices;
                }
                for (TGNoteImpl tGNoteImpl : voice.getNotes()) {
                    voice.check(layout, tGNoteImpl);
                }
                float f = voice.getEffectWidth(layout);
                if (f > beatEffectWidth) {
                    beatEffectWidth = f;
                }
                if (!voice.isRestVoice()) {
                    beat.check(layout, voice.getMinNote());
                    beat.check(layout, voice.getMaxNote());
                    if (groups[v2] == null || !this.canJoin(layout.getSongManager(), voice, previousVoices[v2])) {
                        groups[v2] = new TGBeatGroup(v2);
                        this.voiceGroups[v2].add(groups[v2]);
                    }
                    groups[v2].check(layout, voice);
                } else {
                    for (int v22 = 0; v22 < 2; ++v22) {
                        TGVoiceImpl voice2;
                        if (v22 == voice.getIndex() || (voice2 = beat.getVoiceImpl(v22)).isEmpty() || !voice2.getDuration().isEqual(voice.getDuration()) || voice2.isRestVoice() && voice2.isHiddenSilence()) continue;
                        voice.setHiddenSilence(true);
                        break;
                    }
                }
                this.makeVoice(layout, voice, previousVoices[v2], groups[v2], f);
                previousVoices[v2] = voice;
            }
            beat.setEffectWidth(beatEffectWidth);
            if (emptyBeat) {
                System.out.println("Empty Beat !!!!!! " + beat.getStart() + "  " + i);
            }
            this.effectWidth += beatEffectWidth;
            this.makeBeat(layout, beat, previousBeat, chordEnabled);
            previousBeat = beat;
        }
        this.getHeaderImpl().notifyEffectWidth(this.effectWidth);
        for (v = 0; v < this.voiceGroups.length; ++v) {
            for (TGBeatGroup group : this.voiceGroups[v]) {
                group.finish(layout, this);
            }
        }
        if (!this.compactMode) {
            float f = this.quarterSpacing = minDuration != null ? layout.getSpacingForQuarter(minDuration) : layout.getMinimumDurationWidth();
            if (chordEnabled && minimumChordLength > 0L) {
                float chordWidth = layout.getChordFretIndexSpacing() + layout.getChordStringSpacing() + (float)this.getTrack().stringCount() * layout.getChordStringSpacing();
                float minimumSpacing = 960.0f * chordWidth / (float)minimumChordLength;
                this.quarterSpacing = Math.max(minimumSpacing, this.quarterSpacing);
            }
            this.getHeaderImpl().notifyQuarterSpacing(this.quarterSpacing);
        }
    }

    public boolean canJoin(TGSongManager manager, TGVoiceImpl b1, TGVoiceImpl b2) {
        if (b1 == null || b2 == null || b1.isRestVoice() || b2.isRestVoice()) {
            return false;
        }
        long divisionLength = this.getDivisionLength();
        long start = this.getStart();
        long start1 = manager.getMeasureManager().getRealStart(this, b1.getBeat().getStart()) - start;
        long start2 = manager.getMeasureManager().getRealStart(this, b2.getBeat().getStart()) - start;
        if (b1.getDuration().getValue() < 8 || b2.getDuration().getValue() < 8) {
            return start1 == start2;
        }
        long p1 = (divisionLength + start1) / divisionLength;
        long p2 = (divisionLength + start2) / divisionLength;
        return p1 == p2;
    }

    private void makeVoice(TGLayout layout, TGVoiceImpl voice, TGVoiceImpl previousVoice, TGBeatGroup group, float voiceEffectWidth) {
        voice.setWidth(layout.getDurationWidth(voice.getDuration()) + voiceEffectWidth);
        voice.setBeatGroup(group);
        if (previousVoice != null) {
            voice.setPreviousBeat(previousVoice);
            previousVoice.setNextBeat(voice);
        }
    }

    private void makeBeat(TGLayout layout, TGBeatImpl beat, TGBeatImpl previousBeat, boolean chordEnabled) {
        float minimumWidth = -1.0f;
        boolean restBeat = true;
        for (int v = 0; v < 2; ++v) {
            TGVoiceImpl voice = beat.getVoiceImpl(v);
            if (voice.isEmpty()) continue;
            if (minimumWidth < 0.0f || voice.getWidth() < minimumWidth) {
                minimumWidth = voice.getWidth();
            }
            if (voice.isRestVoice()) continue;
            restBeat = false;
        }
        beat.setWidth(minimumWidth);
        this.notEmptyBeats += restBeat ? 0 : 1;
        this.widthBeats += beat.getMinimumWidth();
        if (previousBeat != null) {
            beat.setPreviousBeat(previousBeat);
            previousBeat.setNextBeat(beat);
            if (chordEnabled && beat.isChordBeat() && previousBeat.isChordBeat()) {
                float previousWidth = previousBeat.getMinimumWidth();
                float chordWidth = layout.getChordFretIndexSpacing() + layout.getChordStringSpacing() + (float)this.getTrack().stringCount() * layout.getChordStringSpacing();
                previousBeat.setWidth(Math.max(chordWidth, previousWidth));
                this.widthBeats -= previousWidth;
                this.widthBeats += previousBeat.getMinimumWidth();
            }
        }
    }

    public void calculateMeasureChanges(TGLayout layout) {
        this.paintClef = false;
        this.paintKeySignature = false;
        TGMeasureImpl tGMeasureImpl = this.previousMeasure = layout.isFirstMeasure(this) ? null : (TGMeasureImpl)layout.getSongManager().getTrackManager().getPrevMeasure(this);
        if ((layout.getStyle() & 4) != 0) {
            if (this.previousMeasure == null || this.getClef() != this.previousMeasure.getClef()) {
                this.paintClef = true;
                this.getHeaderImpl().notifyClefSpacing(this.calculateClefSpacing(layout));
            }
            if (this.previousMeasure == null || this.getKeySignature() != this.previousMeasure.getKeySignature()) {
                this.paintKeySignature = true;
                this.getHeaderImpl().notifyKeySignatureSpacing(this.calculateKeySignatureSpacing(layout));
            }
        }
    }

    private void autoCompleteSilences(TGSongManager manager) {
        manager.getMeasureManager().autoCompleteSilences(this);
    }

    public void registerBuffer(TGLayout layout) {
        TGResourceBuffer buffer = layout.getResourceBuffer();
        this.getBuffer().register(buffer);
        String markerKey = this.getMarkerRegistryKey();
        if (this.hasMarker()) {
            buffer.register(markerKey);
        } else if (buffer.isRegistered(markerKey)) {
            buffer.unregister(markerKey);
        }
    }

    private void updateComponents(TGLayout layout) {
        int i;
        float spacing;
        this.maxY = 0.0f;
        this.minY = 0.0f;
        float tmpX = spacing = this.getFirstNoteSpacing(layout);
        this.effectWidth = 0.0f;
        for (TGBeat beat : this.getBeats()) {
            float beatEffectWidth = 0.0f;
            for (int i2 = 0; i2 < beat.countVoices(); ++i2) {
                float voiceEffectWidth = ((TGVoiceImpl)beat.getVoice(i2)).getEffectWidth(layout);
                beatEffectWidth = voiceEffectWidth > beatEffectWidth ? voiceEffectWidth : beatEffectWidth;
            }
            this.effectWidth += beatEffectWidth;
        }
        float noteEffectOffset = 0.0f;
        for (i = 0; i < this.countBeats(); ++i) {
            float bsSize;
            TGBeatImpl beat = (TGBeatImpl)this.getBeat(i);
            beat.registerBuffer(layout);
            beat.resetEffectsSpacing(layout);
            if (this.compactMode) {
                beat.setPosX(tmpX);
                tmpX += beat.getMinimumWidth();
            } else {
                float quarterWidth = this.getMaxQuarterSpacing(layout) + (this.getMaxEffectWidth(layout) - this.effectWidth) / this.getTimeSignature().getQuartersInSignature();
                float x1 = spacing + this.getDisplayPosition(beat.getStart(), quarterWidth);
                float minimumWidth = -1.0f;
                for (int v = 0; v < beat.countVoices(); ++v) {
                    TGVoiceImpl tGVoiceImpl = beat.getVoiceImpl(v);
                    if (tGVoiceImpl.isEmpty()) continue;
                    float x2 = spacing + this.getDisplayPosition(beat.getStart() + tGVoiceImpl.getDuration().getTime(), quarterWidth);
                    float width = x2 - x1;
                    if (minimumWidth < 0.0f || width < minimumWidth) {
                        minimumWidth = width;
                    }
                    tGVoiceImpl.setWidth(width);
                }
                beat.setPosX(x1 + noteEffectOffset);
                beat.setWidth(minimumWidth);
            }
            float beatEffectWidth = 0.0f;
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGVoiceImpl voice = beat.getVoiceImpl(v);
                if (voice.isEmpty()) continue;
                for (TGNoteImpl tGNoteImpl : voice.getNotes()) {
                    beat.updateEffectsSpacing(layout, tGNoteImpl.getEffect());
                    tGNoteImpl.update(layout);
                }
                float f = voice.getEffectWidth(layout);
                if (!this.compactMode) {
                    voice.setWidth(voice.getWidth() + f);
                    if (f > beatEffectWidth) {
                        beatEffectWidth = f;
                    }
                }
                voice.update(layout);
                if (!this.division1 && v % 2 == 0 && !voice.getDuration().getDivision().isEqual(TGDivisionType.NORMAL)) {
                    this.division1 = true;
                }
                if (!this.division2 && v % 2 == 1 && !voice.getDuration().getDivision().isEqual(TGDivisionType.NORMAL)) {
                    this.division2 = true;
                }
                if ((layout.getStyle() & 4) != 0 && (!voice.isRestVoice() || voice.isHiddenSilence())) continue;
                if (voice.getMaxY() > this.maxY) {
                    this.maxY = voice.getMaxY();
                }
                if (!(voice.getMinY() < this.minY)) continue;
                this.minY = voice.getMinY();
            }
            if (!this.compactMode) {
                beat.setWidth(beat.getMinimumWidth() + beatEffectWidth);
                noteEffectOffset += beatEffectWidth;
            }
            if ((bsSize = beat.getEffectsSpacing(layout)) > this.beatEffectVerticalSpacing) {
                this.beatEffectVerticalSpacing = bsSize;
            }
            if (!this.chord && beat.isChordBeat()) {
                this.chord = true;
            }
            if (this.text || !beat.isTextBeat()) continue;
            this.text = true;
        }
        if ((layout.getStyle() & 4) != 0) {
            for (i = 0; i < this.voiceGroups.length; ++i) {
                for (TGBeatGroup group : this.voiceGroups[i]) {
                    this.checkValue(layout, group.getMinNote(), group.getDirection());
                    this.checkValue(layout, group.getMaxNote(), group.getDirection());
                }
            }
        }
    }

    public float getDisplayPosition(long start, float quarterWidth) {
        long newStart = start - this.getStart();
        float displayPosition = 0.0f;
        if (newStart > 0L) {
            float position = (float)newStart / 960.0f;
            displayPosition = position * quarterWidth;
        }
        return displayPosition;
    }

    public int getNoteAccidental(int noteValue) {
        if (noteValue >= 0 && noteValue < 128) {
            int keySignature = this.getKeySignature();
            int noteIndex = TGMusicKeyUtils.noteIndex(noteValue, keySignature);
            int octave = TGMusicKeyUtils.noteOctave(noteValue, keySignature);
            int accidentalValue = TGMusicKeyUtils.noteAccidental(noteValue, keySignature);
            if (accidentalValue != 0 && !this.registeredAccidentals[octave][noteIndex]) {
                this.registeredAccidentals[octave][noteIndex] = true;
                return accidentalValue;
            }
            if (accidentalValue == 0 && this.registeredAccidentals[octave][noteIndex]) {
                this.registeredAccidentals[octave][noteIndex] = false;
                return TGMusicKeyUtils.noteAlteration(noteValue, keySignature);
            }
        }
        return 0;
    }

    private void checkValue(TGLayout layout, TGNoteImpl note, int direction) {
        float y = note.getScorePosY();
        float upOffset = TGBeatGroup.getUpOffset(layout);
        float downOffset = TGBeatGroup.getDownOffset(layout);
        if (direction == 1 && y > this.maxY) {
            this.maxY = y;
        } else if (direction == 2 && y + downOffset > this.maxY) {
            this.maxY = y + downOffset + 2.0f;
        }
        if (direction == 1 && y - upOffset < this.minY) {
            this.minY = y - upOffset - 2.0f;
        } else if (direction == 2 && y < this.minY) {
            this.minY = y;
        }
    }

    private void resetSpacing() {
        this.text = false;
        this.chord = false;
        this.division1 = false;
        this.division2 = false;
        this.beatEffectVerticalSpacing = 0.0f;
        this.effectWidth = 0.0f;
    }

    public void registerSpacing(TGLayout layout, TGTrackSpacing ts) {
        if (layout.hasLoopMarker(this.getHeader())) {
            ts.setSize(1, layout.getLoopMarkerSpacing());
        }
        if (this.hasMarker()) {
            ts.setSize(2, layout.getMarkerSpacing());
        }
        if (this.chord) {
            ts.setSize(6, layout.getDefaultChordSpacing());
        }
        if (this.text) {
            ts.setSize(3, layout.getTextSpacing());
        }
        if (this.getHeader().getRepeatAlternative() > 0) {
            ts.setSize(5, layout.getRepeatEndingSpacing());
        }
        if (this.division1) {
            ts.setSize(10, layout.getDivisionTypeSpacing());
        }
        if (this.division2) {
            ts.setSize(11, layout.getDivisionTypeSpacing());
        }
        if (this.beatEffectVerticalSpacing > 0.0f) {
            ts.setSize(12, this.beatEffectVerticalSpacing);
        }
    }

    private void orderBeats(TGSongManager manager) {
        manager.getMeasureManager().orderBeats(this);
    }

    public void paintMeasure(TGLayout layout, UIPainter painter) {
        if (this.readyToPaint) {
            this.setOutOfBounds(false);
            boolean bufferEnabled = layout.isBufferEnabled();
            TGResourceBuffer resourceBuffer = layout.getResourceBuffer();
            UIColor background = this.isPlaying(layout) ? layout.getResources().getBackgroundColorPlaying() : layout.getResources().getBackgroundColor();
            painter.setBackground(background);
            if (!bufferEnabled || this.shouldRepaintBuffer(resourceBuffer, this.isPlaying(layout))) {
                float y;
                UIPainter bufferPainter = painter;
                float x = bufferEnabled ? 0.0f : this.getPosX();
                float f = y = bufferEnabled ? 0.0f : this.getPosY();
                if (bufferEnabled) {
                    UIResourceFactory factory = layout.getComponent().getResourceFactory();
                    bufferPainter = this.getBuffer().createBuffer(resourceBuffer, factory, this.getWidth(layout) + this.getSpacing(), this.getTs().getSize(), background);
                }
                layout.paintLines(this.getTrackImpl(), this.getTs(), bufferPainter, x, y, this.getWidth(layout) + this.getSpacing());
                this.paintTimeSignature(layout, bufferPainter, x, y);
                this.paintClef(layout, bufferPainter, x, y);
                this.paintKeySignature(layout, bufferPainter, x, y);
                this.paintComponents(layout, bufferPainter, x, y);
                if (bufferEnabled) {
                    bufferPainter.dispose();
                }
                this.setBufferCreated(true);
            }
            if (bufferEnabled) {
                painter.setBackground(background);
                this.getBuffer().paintBuffer(resourceBuffer, painter, this.getPosX(), this.getPosY());
            }
            this.paintMarker(layout, painter);
            this.paintTexts(layout, painter);
            this.paintTempo(layout, painter);
            this.paintTripletFeel(layout, painter);
            this.paintDivisions(layout, painter);
            this.paintRepeatEnding(layout, painter);
            this.paintLoopMarker(layout, painter);
        }
        this.wasPlayingWhenLastPainted = this.isPlaying(layout);
    }

    private boolean shouldRepaintBuffer(TGResourceBuffer resourceBuffer, boolean isPlaying) {
        return !this.isBufferCreated() || this.getBuffer().isDisposed(resourceBuffer) || isPlaying != this.wasPlayingWhenLastPainted;
    }

    public void paintRepeatEnding(TGLayout layout, UIPainter painter) {
        if (this.getHeader().getRepeatAlternative() > 0) {
            float scale = layout.getScale();
            float x1 = this.getPosX() + this.getHeaderImpl().getLeftSpacing(layout) + this.getFirstNoteSpacing(layout);
            float x2 = this.getPosX() + this.getWidth(layout) + this.getSpacing();
            float y1 = this.getPosY() + this.getTs().getPosition(5);
            float y2 = y1 + layout.getRepeatEndingSpacing() * 0.75f;
            Object string = new String();
            for (int i = 0; i < 8; ++i) {
                if ((this.getHeader().getRepeatAlternative() & 1 << i) == 0) continue;
                string = (String)string + (String)(((String)string).length() > 0 ? ", " + Integer.toString(i + 1) : Integer.toString(i + 1));
            }
            layout.setRepeatEndingStyle(painter);
            painter.initPath();
            painter.setAntialias(false);
            painter.moveTo(x1, y2);
            painter.lineTo(x1, y1);
            painter.moveTo(x1, y1);
            painter.lineTo(x2, y1);
            painter.closePath();
            painter.drawString((String)string, x1 + 5.0f * scale, y1 + painter.getFMTopLine() + 4.0f * scale);
        }
    }

    public void paintComponents(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        float x = fromX + this.getHeaderImpl().getLeftSpacing(layout);
        for (TGBeatImpl tGBeatImpl : this.getBeats()) {
            tGBeatImpl.paint(layout, painter, x, fromY, false);
        }
        this.paintDivisionTypes(layout, painter, x, fromY);
    }

    public void paintDivisionTypes(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        for (int v = 0; v < 2; ++v) {
            if ((!this.division1 || v % 2 != 0) && (!this.division2 || v % 2 != 1)) continue;
            this.paintDivisionTypes(layout, painter, fromX, fromY, v);
        }
    }

    public void paintDivisionTypes(TGLayout layout, UIPainter painter, float fromX, float fromY, int voiceIndex) {
        float x1 = 0.0f;
        float x2 = 0.0f;
        int tupletDuration = 0;
        int tupletShortest = 0;
        TGDivisionType divisionType = null;
        for (TGBeatImpl tGBeatImpl : this.getBeats()) {
            TGVoiceImpl voice = tGBeatImpl.getVoiceImpl(voiceIndex);
            if (!voice.isEmpty()) {
                if (divisionType != null && (!voice.getDuration().getDivision().isEqual(divisionType) || tupletDuration != 0 && tupletDuration == divisionType.getEnters() * divisionType.getTimes() * 64 / tupletShortest)) {
                    this.paintDivisionType(layout, painter, divisionType, x1, x2, fromY, voiceIndex);
                    divisionType = null;
                    tupletDuration = 0;
                    tupletShortest = 0;
                }
                if (!voice.getDuration().getDivision().isEqual(TGDivisionType.NORMAL)) {
                    x2 = fromX + tGBeatImpl.getPosX() + tGBeatImpl.getSpacing(layout);
                    if (divisionType == null) {
                        divisionType = voice.getDuration().getDivision();
                        x1 = x2;
                    }
                }
            }
            if (divisionType == null) continue;
            int voiceDuration = voice.getDuration().getValue();
            tupletDuration += 64 * divisionType.getTimes() / voiceDuration;
            tupletShortest = voiceDuration > tupletShortest ? voiceDuration : tupletShortest;
        }
        if (divisionType != null) {
            this.paintDivisionType(layout, painter, divisionType, x1, x2, fromY, voiceIndex);
        }
    }

    public void paintDivisionType(TGLayout layout, UIPainter painter, TGDivisionType divisionType, float beatX1, float beatX2, float fromY, int voice) {
        layout.setDivisionTypeStyle(painter);
        String label = Integer.toString(divisionType.getEnters());
        float scale = layout.getScale();
        float labelWidth = painter.getFMWidth(label);
        float y = fromY + this.getTs().getPosition(voice % 2 == 0 ? 10 : 11);
        float yMove = layout.getDivisionTypeSpacing() / 2.0f - scale;
        float xMove = ((layout.getStyle() & 4) != 0 ? layout.getScoreNoteWidth() : layout.getStringSpacing()) / 2.0f + scale;
        float y1 = y + yMove + yMove * (float)(voice % 2 == 0 ? 1 : -1);
        float y2 = y + yMove;
        float x1 = beatX1 - xMove;
        float x2 = beatX2 + xMove * 2.0f;
        float xCenter = x1 + (x2 - x1) / 2.0f;
        if (beatX2 > beatX1) {
            painter.setLineWidth(layout.getLineWidth(1));
            painter.initPath(1);
            painter.moveTo(x1, y1);
            painter.lineTo(x1, y2);
            painter.lineTo(xCenter - labelWidth / 2.0f - scale, y2);
            painter.moveTo(x2, y1);
            painter.lineTo(x2, y2);
            painter.lineTo(xCenter + labelWidth / 2.0f + scale, y2);
            painter.closePath();
        }
        painter.drawString(label, xCenter - labelWidth / 2.0f, y2 + painter.getFMMiddleLine());
    }

    private void paintDivisions(TGLayout layout, UIPainter painter) {
        float x1 = this.getPosX();
        float x2 = this.getPosX() + this.getWidth(layout);
        float y1 = 0.0f;
        float y2 = 0.0f;
        float offsetY = 0.0f;
        int style = layout.getStyle();
        boolean addInfo = false;
        if ((style & 4) != 0) {
            y1 = this.getPosY() + this.getTs().getPosition(8);
            y2 = y1 + layout.getScoreLineSpacing() * 4.0f;
            addInfo = true;
            if ((style & 8) != 0 && (layout.isFirstMeasure(this) || this.isFirstOfLine())) {
                offsetY = this.getPosY() + this.getTs().getPosition(14) - y2;
            }
            this.paintDivisions(layout, painter, x1, y1, x2, y2, offsetY, addInfo);
        }
        if ((style & 8) != 0) {
            y1 = this.getPosY() + this.getTs().getPosition(14);
            if (y1 == (y2 = y1 + (this.getTrack().stringCount() > 1 ? (float)(this.getTrack().stringCount() - 1) * layout.getStringSpacing() : 0.0f))) {
                y1 -= layout.getStringSpacing();
                y2 += layout.getStringSpacing();
            }
            addInfo = (style & 4) == 0;
            offsetY = 0.0f;
            this.paintDivisions(layout, painter, x1, y1, x2, y2, offsetY, addInfo);
        }
    }

    private void paintDivisions(TGLayout layout, UIPainter painter, float x1, float y1, float x2, float y2, float offsetY, boolean addInfo) {
        float yMove;
        float xMove;
        float scale = layout.getScale();
        float lineWidthSmall = layout.getLineWidth(1);
        float lineWidthBig = layout.getLineWidth(3);
        if (addInfo) {
            String number = Integer.toString(this.getNumber());
            layout.setMeasureNumberStyle(painter);
            painter.drawString(number, this.getPosX() + scale, y1 + painter.getFMBaseLine() - 2.0f * scale);
        }
        layout.setDivisionsStyle(painter, true);
        if (this.isRepeatOpen() || layout.isFirstMeasure(this)) {
            painter.setLineWidth(layout.getLineWidth(0));
            painter.initPath(3);
            painter.setAntialias(false);
            painter.addRectangle(x1, y1, lineWidthBig, y2 + offsetY - y1);
            painter.closePath();
            painter.setLineWidth(layout.getLineWidth(0));
            painter.initPath(3);
            painter.setAntialias(false);
            painter.addRectangle(x1 + lineWidthBig + 2.0f * scale, y1, lineWidthSmall, y2 + offsetY - y1);
            painter.closePath();
            if (this.isRepeatOpen()) {
                float size = layout.getLineWidth(4);
                xMove = lineWidthBig + scale + lineWidthSmall + 2.0f * scale + size;
                yMove = size;
                painter.setLineWidth(lineWidthSmall);
                painter.initPath(2);
                painter.moveTo(x1 + xMove, y1 + (y2 - y1) / 2.0f - yMove);
                painter.addCircle(x1 + xMove, y1 + (y2 - y1) / 2.0f - yMove, size);
                painter.moveTo(x1 + xMove, y1 + (y2 - y1) / 2.0f + yMove);
                painter.addCircle(x1 + xMove, y1 + (y2 - y1) / 2.0f + yMove, size);
                painter.closePath();
            }
        } else {
            painter.setLineWidth(layout.getLineWidth(0));
            painter.initPath(3);
            painter.setAntialias(false);
            painter.moveTo(x1, y1);
            painter.lineTo(x1, y2 + offsetY);
            painter.closePath();
        }
        if (this.getRepeatClose() > 0 || layout.isLastMeasure(this)) {
            painter.setLineWidth(layout.getLineWidth(0));
            painter.initPath(3);
            painter.setAntialias(false);
            painter.addRectangle(x2 + this.getSpacing() - (lineWidthBig + lineWidthSmall + 2.0f * scale), y1, lineWidthSmall, y2 - y1);
            painter.closePath();
            painter.setLineWidth(layout.getLineWidth(0));
            painter.initPath(3);
            painter.setAntialias(false);
            painter.addRectangle(x2 + this.getSpacing() - lineWidthBig, y1, lineWidthBig, y2 - y1);
            painter.closePath();
            if (this.getRepeatClose() > 0) {
                float size = layout.getLineWidth(4);
                xMove = lineWidthBig + scale + lineWidthSmall + 2.0f * scale + size;
                yMove = size;
                painter.setLineWidth(lineWidthSmall);
                painter.initPath(2);
                painter.moveTo(x2 - xMove + this.getSpacing(), y1 + (y2 - y1) / 2.0f - yMove);
                painter.addCircle(x2 - xMove + this.getSpacing(), y1 + (y2 - y1) / 2.0f - yMove, size);
                painter.moveTo(x2 - xMove + this.getSpacing(), y1 + (y2 - y1) / 2.0f + yMove);
                painter.addCircle(x2 - xMove + this.getSpacing(), y1 + (y2 - y1) / 2.0f + yMove, size);
                painter.closePath();
                if (addInfo) {
                    layout.setDivisionsStyle(painter, false);
                    String repetitions = "x" + this.getRepeatClose();
                    painter.drawString(repetitions, x2 - painter.getFMWidth(repetitions) + this.getSpacing() - size, y1 + painter.getFMBaseLine() - 2.0f * scale);
                }
            }
        } else {
            painter.setLineWidth(layout.getLineWidth(0));
            painter.initPath(3);
            painter.setAntialias(false);
            painter.moveTo(x2 + this.getSpacing(), y1);
            painter.lineTo(x2 + this.getSpacing(), y2);
            painter.closePath();
        }
        painter.setLineWidth(lineWidthSmall);
    }

    private void paintClef(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        if ((layout.getStyle() & 4) != 0 && this.paintClef) {
            float x = fromX + this.getHeaderImpl().getLeftSpacing(layout);
            float y = fromY + this.getTs().getPosition(8);
            layout.setClefStyle(painter);
            painter.initPath(2);
            if (this.getTrack().isPercussion()) {
                TGClefPainter.paintNeutral(painter, x, y, layout.getScoreLineSpacing());
            } else if (this.getClef() == 1) {
                TGClefPainter.paintTreble(painter, x, y, layout.getScoreLineSpacing());
            } else if (this.getClef() == 2) {
                TGClefPainter.paintBass(painter, x, y, layout.getScoreLineSpacing());
            } else if (this.getClef() == 3) {
                TGClefPainter.paintTenor(painter, x, y, layout.getScoreLineSpacing());
            } else if (this.getClef() == 4) {
                TGClefPainter.paintAlto(painter, x, y, layout.getScoreLineSpacing());
            }
            painter.closePath();
        }
    }

    private void paintKeySignature(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        block7: {
            int i;
            int currentKey;
            int clefIndex;
            float y;
            float x;
            float scale;
            block8: {
                float offset;
                int naturalFrom;
                int i2;
                if ((layout.getStyle() & 4) == 0 || !this.paintKeySignature) break block7;
                scale = layout.getScoreLineSpacing();
                x = fromX + this.getHeaderImpl().getLeftSpacing(layout) + this.getClefSpacing(layout);
                y = fromY + this.getTs().getPosition(8);
                clefIndex = this.getClef() - 1;
                currentKey = this.getKeySignature();
                int previousKey = this.previousMeasure != null ? this.previousMeasure.getKeySignature() : 0;
                layout.setKeySignatureStyle(painter);
                if (previousKey >= 1 && previousKey <= 7) {
                    for (i2 = naturalFrom = currentKey >= 1 && currentKey <= 7 ? currentKey : 0; i2 < previousKey; ++i2) {
                        offset = scale / 2.0f * (float)SCORE_KEY_SHARP_POSITIONS[clefIndex][i2] - scale / 2.0f;
                        painter.initPath(2);
                        TGKeySignaturePainter.paintNatural(painter, x, y + offset, scale);
                        painter.closePath();
                        x += scale - scale / 4.0f;
                    }
                } else if (previousKey >= 8 && previousKey <= 14) {
                    for (i2 = naturalFrom = currentKey >= 8 && currentKey <= 14 ? currentKey : 7; i2 < previousKey; ++i2) {
                        offset = scale / 2.0f * (float)SCORE_KEY_FLAT_POSITIONS[clefIndex][i2 - 7] - scale / 2.0f;
                        painter.initPath(2);
                        TGKeySignaturePainter.paintNatural(painter, x, y + offset, scale);
                        painter.closePath();
                        x += scale - scale / 4.0f;
                    }
                }
                if (currentKey < 1 || currentKey > 7) break block8;
                for (i = 0; i < currentKey; ++i) {
                    float offset2 = scale / 2.0f * (float)SCORE_KEY_SHARP_POSITIONS[clefIndex][i] - scale / 2.0f;
                    painter.initPath(2);
                    TGKeySignaturePainter.paintSharp(painter, x, y + offset2, scale);
                    painter.closePath();
                    x += scale - scale / 4.0f;
                }
                break block7;
            }
            if (currentKey < 8 || currentKey > 14) break block7;
            for (i = 7; i < currentKey; ++i) {
                float offset = scale / 2.0f * (float)SCORE_KEY_FLAT_POSITIONS[clefIndex][i - 7] - scale / 2.0f;
                painter.initPath(2);
                TGKeySignaturePainter.paintFlat(painter, x, y + offset, scale);
                painter.closePath();
                x += scale - scale / 4.0f;
            }
        }
    }

    private void paintTimeSignature(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        if (this.getHeaderImpl().shouldPaintTimeSignature()) {
            int style = layout.getStyle();
            float x = fromX + this.getHeaderImpl().getLeftSpacing(layout) + this.getClefSpacing(layout) + this.getKeySignatureSpacing(layout);
            float y = 0.0f;
            float y1 = 0.0f;
            float y2 = 0.0f;
            float height = 0.0f;
            if ((style & 4) != 0) {
                y1 = y = this.getTs().getPosition(8);
                y2 = y + this.getTrackImpl().getScoreHeight();
                height = layout.getScoreLineSpacing() * 2.0f - layout.getScale();
            } else if ((style & 8) != 0) {
                y1 = y = this.getTs().getPosition(14);
                y2 = y + this.getTrackImpl().getTabHeight();
                height = layout.getStringSpacing() * 3.0f / 2.0f;
            }
            if (y2 - y1 < height * 2.0f) {
                float yMove = (height * 2.0f - (y2 - y1)) / 2.0f;
                y1 -= yMove;
                y2 += yMove;
            }
            float w1 = TGNumberPainter.getDigitsWidth(this.getTimeSignature().getNumerator(), height);
            float w2 = TGNumberPainter.getDigitsWidth(this.getTimeSignature().getDenominator().getValue(), height);
            float wMove1 = w2 > w1 ? (w2 - w1) / 2.0f : 0.0f;
            float wMove2 = w1 > w2 ? (w1 - w2) / 2.0f : 0.0f;
            layout.setTimeSignatureStyle(painter);
            TGNumberPainter.paintDigits(this.getTimeSignature().getNumerator(), painter, x + wMove1, fromY + y1, height);
            TGNumberPainter.paintDigits(this.getTimeSignature().getDenominator().getValue(), painter, x + wMove2, fromY + y2 - height, height);
        }
    }

    private void paintTempo(TGLayout layout, UIPainter painter) {
        if (this.getHeaderImpl().shouldPaintTempo()) {
            float scale = 5.0f * layout.getScale();
            float x = this.getPosX() + this.getHeaderImpl().getLeftSpacing(layout);
            float y = this.getPosY();
            float lineSpacing = Math.max(layout.getScoreLineSpacing(), layout.getStringSpacing());
            int style = layout.getStyle();
            if ((style & 4) != 0) {
                y += this.getTs().getPosition(8) - lineSpacing;
            } else if ((style & 8) != 0) {
                y += this.getTs().getPosition(14) - (this.getTrack().stringCount() > 1 ? lineSpacing : lineSpacing * 2.0f);
            }
            layout.setTempoStyle(painter, false);
            float imgX = x;
            float imgY = y - (float)(Math.round(scale * 3.5f) + 2);
            TGTempoPainter.paintTempo(painter, imgX, imgY, scale);
            layout.setTempoStyle(painter, true);
            String value = " = " + this.getTempo().getValue();
            float fontX = x + (float)(Math.round(1.33f * scale) + 1);
            float fontY = y - 0.75f * scale + painter.getFMBaseLine();
            painter.drawString(value, fontX, fontY);
        }
    }

    private void paintTripletFeel(TGLayout layout, UIPainter painter) {
        if (this.getHeaderImpl().shouldPaintTripletFeel()) {
            float scale = 5.0f * layout.getScale();
            float x = this.getPosX() + this.getHeaderImpl().getLeftSpacing(layout) + this.getHeaderImpl().getTempoSpacing(layout);
            float y = this.getPosY();
            float lineSpacing = Math.max(layout.getScoreLineSpacing(), layout.getStringSpacing());
            int style = layout.getStyle();
            if ((style & 4) != 0) {
                y += this.getTs().getPosition(8) - lineSpacing;
            } else if ((style & 8) != 0) {
                y += this.getTs().getPosition(14) - (this.getTrack().stringCount() > 1 ? lineSpacing : lineSpacing * 2.0f);
            }
            layout.setTripletFeelStyle(painter, true);
            String equal = " = ";
            float fontX = x + 3.2f * scale;
            float fontY = y - 0.75f * scale + painter.getFMBaseLine();
            painter.drawString(equal, fontX, fontY);
            layout.setTripletFeelStyle(painter, false);
            float x1 = x;
            float x2 = x + (3.2f * scale + painter.getFMWidth(equal));
            float y1 = y - (1.0f * scale + 2.5f * scale + 2.0f);
            float y2 = y - (1.0f * scale + 2.5f * scale + 1.0f * scale + 2.0f);
            if (this.getTripletFeel() == 1 && this.previousMeasure != null) {
                int previous = this.previousMeasure.getTripletFeel();
                if (previous == 2) {
                    TGTripletFeelPainter.paintTripletFeel8(painter, x1, y2, scale);
                    TGTripletFeelPainter.paintTripletFeelNone8(painter, x2, y1, scale);
                } else if (previous == 3) {
                    TGTripletFeelPainter.paintTripletFeel16(painter, x1, y2, scale);
                    TGTripletFeelPainter.paintTripletFeelNone16(painter, x2, y1, scale);
                }
            } else if (this.getTripletFeel() == 2) {
                TGTripletFeelPainter.paintTripletFeelNone8(painter, x1, y1, scale);
                TGTripletFeelPainter.paintTripletFeel8(painter, x2, y2, scale);
            } else if (this.getTripletFeel() == 3) {
                TGTripletFeelPainter.paintTripletFeelNone16(painter, x1, y1, scale);
                TGTripletFeelPainter.paintTripletFeel16(painter, x2, y2, scale);
            }
        }
    }

    private void paintLoopMarker(TGLayout layout, UIPainter painter) {
        if (layout.hasLoopMarker(this)) {
            float y;
            float x;
            int size = Math.round(layout.getLoopMarkerSpacing() - 1.0f * layout.getScale());
            if (layout.getComponent().isLoopSHeader(this.getHeader())) {
                x = this.getPosX() + (float)Math.round((float)size / 2.0f);
                y = this.getPosY() + this.getTs().getPosition(1);
                layout.setLoopSMarkerStyle(painter);
                this.paintLoopMarker(painter, x, y, size);
            }
            if (layout.getComponent().isLoopEHeader(this.getHeader())) {
                x = this.getPosX() + this.getWidth(layout) + this.getSpacing() - (float)size;
                y = this.getPosY() + this.getTs().getPosition(1);
                layout.setLoopEMarkerStyle(painter);
                this.paintLoopMarker(painter, x, y, size);
            }
        }
    }

    private void paintLoopMarker(UIPainter painter, float x, float y, float size) {
        painter.initPath(2);
        painter.addRectangle(x, y, size, size);
        painter.closePath();
    }

    private void paintMarker(TGLayout layout, UIPainter painter) {
        if (this.hasMarker()) {
            float x = this.getPosX() + this.getHeaderImpl().getLeftSpacing(layout) + this.getFirstNoteSpacing(layout);
            float y = this.getPosY() + this.getTs().getPosition(2);
            layout.setMarkerStyle(painter, this.getMarkerColor(layout.getResourceBuffer(), layout.getComponent().getResourceFactory()));
            painter.drawString(this.getMarker().getTitle(), x, y);
        }
    }

    private void paintTexts(TGLayout layout, UIPainter painter) {
        for (TGBeat beat : this.getBeats()) {
            if (!beat.isTextBeat()) continue;
            TGTextImpl text = (TGTextImpl)beat.getText();
            text.paint(layout, painter, this.getPosX() + this.getHeaderImpl().getLeftSpacing(layout), this.getPosY());
        }
    }

    public UIRectangle getVerticalPosition(TGLayout layout) {
        float y1;
        float y2 = y1 = this.getPosY();
        int style = layout.getStyle();
        if ((style & 0xC) == 12) {
            y1 += this.getTs().getPosition(8) - layout.getScoreLineSpacing();
            y2 += this.getTs().getPosition(14) + this.getTrackImpl().getTabHeight() + layout.getStringSpacing();
        } else if ((style & 4) != 0) {
            y1 += this.getTs().getPosition(8) - layout.getScoreLineSpacing();
            y2 += this.getTs().getPosition(8) + layout.getScoreLineSpacing() * 5.0f;
        } else if ((style & 8) != 0) {
            y1 += this.getTs().getPosition(14) - layout.getStringSpacing();
            y2 += this.getTs().getPosition(14) + this.getTrackImpl().getTabHeight() + layout.getStringSpacing();
        }
        return new UIRectangle(0.0f, y1, 0.0f, y2 - y1);
    }

    public boolean isPlaying(TGLayout layout) {
        return layout.getComponent().isRunning(this);
    }

    public float getBeatSpacing(TGLayout layout, TGBeatImpl beat) {
        float minimumDurationWidth;
        float bMargin = this.getFirstNoteSpacing(layout);
        float mPadding = bMargin + this.getHeaderImpl().getLeftSpacing(layout) + this.getHeaderImpl().getRightSpacing(layout);
        float mWidth = this.getWidth(layout) - mPadding;
        float mWidthWithSpacing = mWidth + this.getSpacing();
        if (mWidthWithSpacing < (minimumDurationWidth = layout.getMinimumDurationWidth())) {
            mWidthWithSpacing = minimumDurationWidth;
        }
        float beatX = beat.getPosX() - bMargin;
        float moveX = mWidthWithSpacing * beatX / mWidth;
        return moveX - beatX;
    }

    public boolean hasTrack(int number) {
        return this.getTrack().getNumber() == number;
    }

    public float getWidth(TGLayout layout) {
        return (layout.getStyle() & 2) != 0 ? this.getHeaderImpl().getMaxWidth() : this.width;
    }

    private float calculateClefSpacing(TGLayout layout) {
        return Math.round(16.0f * layout.getScale()) + Math.round(layout.getClefSpacing());
    }

    private float calculateKeySignatureSpacing(TGLayout layout) {
        float spacing = 0.0f;
        if (this.paintKeySignature) {
            spacing = this.getKeySignature() <= 7 ? (spacing += (float)Math.round(6.0f * layout.getScale() * (float)this.getKeySignature())) : (spacing += (float)Math.round(6.0f * layout.getScale() * (float)(this.getKeySignature() - 7)));
            if (this.previousMeasure != null) {
                spacing = this.previousMeasure.getKeySignature() <= 7 ? (spacing += (float)Math.round(6.0f * layout.getScale() * (float)this.previousMeasure.getKeySignature())) : (spacing += (float)Math.round(6.0f * layout.getScale() * (float)(this.previousMeasure.getKeySignature() - 7)));
            }
            if (spacing > 0.0f) {
                spacing += layout.getKeySignatureSpacing();
            }
        }
        return spacing;
    }

    public float getFirstNoteSpacing(TGLayout layout) {
        return this.getHeaderImpl().getFirstNoteSpacing(layout, this);
    }

    public float getClefSpacing(TGLayout layout) {
        return this.getHeaderImpl().getClefSpacing(layout, this);
    }

    public float getKeySignatureSpacing(TGLayout layout) {
        return this.getHeaderImpl().getKeySignatureSpacing(layout, this);
    }

    public long getDivisionLength() {
        return this.divisionLength;
    }

    public boolean isBufferCreated() {
        return this.bufferCreated;
    }

    public void setBufferCreated(boolean bufferCreated) {
        this.bufferCreated = bufferCreated;
    }

    public float getPosX() {
        return this.posX;
    }

    public void setPosX(float posX) {
        this.posX = posX;
    }

    public float getPosY() {
        return this.posY;
    }

    public void setPosY(float posY) {
        this.posY = posY;
    }

    private float getMaxQuarterSpacing(TGLayout layout) {
        return (layout.getStyle() & 2) != 0 ? this.getHeaderImpl().getMaxQuarterSpacing() : this.quarterSpacing;
    }

    private float getMaxEffectWidth(TGLayout layout) {
        return (layout.getStyle() & 2) != 0 ? this.getHeaderImpl().getMaxEffectWidth() : this.effectWidth;
    }

    public TGMeasureHeaderImpl getHeaderImpl() {
        return (TGMeasureHeaderImpl)super.getHeader();
    }

    public float getSpacing() {
        return this.spacing;
    }

    public void setSpacing(float spacing) {
        if (spacing != this.spacing) {
            this.setBufferCreated(false);
        }
        this.spacing = spacing;
    }

    public boolean isOutOfBounds() {
        return this.outOfBounds;
    }

    public void setOutOfBounds(boolean outOfBounds) {
        this.outOfBounds = outOfBounds;
    }

    public boolean isFirstOfLine() {
        return this.firstOfLine;
    }

    public void setFirstOfLine(boolean firstOfLine) {
        this.firstOfLine = firstOfLine;
    }

    public TGTrackImpl getTrackImpl() {
        return (TGTrackImpl)super.getTrack();
    }

    public TGTrackSpacing getTs() {
        return this.ts;
    }

    public void setTs(TGTrackSpacing ts) {
        if (this.getTs() == null) {
            this.setBufferCreated(false);
        } else if (this.getTs().getPosition(8) != ts.getPosition(8)) {
            this.setBufferCreated(false);
        } else if (this.getTs().getPosition(14) != ts.getPosition(14)) {
            this.setBufferCreated(false);
        } else if (this.getTs().getPosition(12) != ts.getPosition(12)) {
            this.setBufferCreated(false);
        }
        this.ts = ts;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public float getMinY() {
        return this.minY;
    }

    public int getNotEmptyBeats() {
        return this.notEmptyBeats;
    }

    public int getNotEmptyVoices() {
        return this.notEmptyVoices;
    }

    public int getLyricBeatIndex() {
        return this.lyricBeatIndex;
    }

    public void setLyricBeatIndex(int lyricBeatIndex) {
        this.lyricBeatIndex = lyricBeatIndex;
    }

    public boolean isPaintClef() {
        return this.paintClef;
    }

    public boolean isPaintKeySignature() {
        return this.paintKeySignature;
    }

    public TGMeasureBuffer getBuffer() {
        if (this.buffer == null) {
            this.buffer = new TGMeasureBuffer();
        }
        return this.buffer;
    }

    public TGMeasureImpl getPreviousMeasure() {
        return this.previousMeasure;
    }

    public String getMarkerRegistryKey() {
        return TGMarker.class.getName() + "-" + this.getHeader().getNumber();
    }

    public UIColor getMarkerColor(TGResourceBuffer buffer, UIResourceFactory factory) {
        String resourceKey = this.getMarkerRegistryKey();
        TGMarker m = this.getMarker();
        UIColor markerColor = (UIColor)buffer.getResource(resourceKey);
        if (!(markerColor == null || markerColor.isDisposed() || markerColor.getRed() == m.getColor().getR() && markerColor.getGreen() == m.getColor().getG() && markerColor.getBlue() == m.getColor().getB())) {
            buffer.disposeResource(resourceKey);
        }
        if (markerColor == null || markerColor.isDisposed()) {
            markerColor = factory.createColor(m.getColor().getR(), m.getColor().getG(), m.getColor().getB());
            buffer.setResource(resourceKey, markerColor);
        }
        return markerColor;
    }

    public void paintInternalSelection(TGLayout layout, UIPainter painter, TGBeat from, TGBeat to) {
        float x = this.getBeatLeftEdge(layout, (TGBeatImpl)from);
        float y = this.getTopEdge(layout);
        float width = this.getBeatRightEdge(layout, (TGBeatImpl)to) - x;
        float height = this.getBottomEdge(layout) - y;
        for (int style : new int[]{2, 1}) {
            this.initSelectionPath(layout, painter, style);
            painter.setAlpha(style == 2 ? 18 : 255);
            painter.addRectangle(x, y, width, height);
            painter.closePath();
        }
    }

    public void paintSelectionStart(TGLayout layout, UIPainter painter, TGBeat from) {
        float x1 = this.getBeatLeftEdge(layout, (TGBeatImpl)from);
        float x2 = this.getRightEdge(layout);
        float y1 = this.getTopEdge(layout);
        float y2 = this.getBottomEdge(layout);
        this.initSelectionPath(layout, painter, 2);
        painter.setAlpha(18);
        painter.addRectangle(x1, y1, x2 - x1, y2 - y1);
        painter.closePath();
        this.initSelectionPath(layout, painter, 1);
        painter.setAlpha(255);
        painter.moveTo(x2, y2);
        painter.lineTo(x1, y2);
        painter.lineTo(x1, y1);
        painter.lineTo(x2, y1);
        painter.closePath();
    }

    private float getBeatLeftEdge(TGLayout layout, TGBeatImpl beat) {
        return this.getPosX() + beat.getPosX() + beat.getSpacing(layout) + this.getHeaderImpl().getLeftSpacing(layout) * 0.5f;
    }

    public void paintSelectionEnd(TGLayout layout, UIPainter painter, TGBeat to) {
        float x1 = this.getPosX();
        float x2 = this.getBeatRightEdge(layout, (TGBeatImpl)to);
        float y1 = this.getTopEdge(layout);
        float y2 = this.getBottomEdge(layout);
        this.initSelectionPath(layout, painter, 2);
        painter.setAlpha(18);
        painter.addRectangle(x1, y1, x2 - x1, y2 - y1);
        painter.closePath();
        this.initSelectionPath(layout, painter, 1);
        painter.setAlpha(255);
        painter.moveTo(x1, y2);
        painter.lineTo(x2, y2);
        painter.lineTo(x2, y1);
        painter.lineTo(x1, y1);
        painter.closePath();
    }

    private float getBeatRightEdge(TGLayout layout, TGBeatImpl beat) {
        return this.getPosX() + beat.getPosX() + beat.getSpacing(layout) + beat.getMinimumWidth() + this.getHeaderImpl().getLeftSpacing(layout) * 0.5f;
    }

    public void paintFullSelection(TGLayout layout, UIPainter painter) {
        float x1 = this.getPosX();
        float x2 = this.getRightEdge(layout);
        float y1 = this.getTopEdge(layout);
        float y2 = this.getBottomEdge(layout);
        this.initSelectionPath(layout, painter, 2);
        painter.setAlpha(18);
        painter.addRectangle(x1, y1, x2 - x1, y2 - y1);
        painter.closePath();
        this.initSelectionPath(layout, painter, 1);
        painter.setAlpha(255);
        painter.moveTo(x1, y1);
        painter.lineTo(x2, y1);
        painter.moveTo(x1, y2);
        painter.lineTo(x2, y2);
        painter.closePath();
    }

    private void initSelectionPath(TGLayout layout, UIPainter painter, int style) {
        float scale = layout.getScale();
        painter.setLineWidth(1.0f * scale);
        painter.setForeground(layout.getResources().getSelectionColor());
        painter.setBackground(layout.getResources().getSelectionColor());
        painter.initPath(style);
        painter.setAntialias(false);
    }

    private float getRightEdge(TGLayout layout) {
        return this.getPosX() + this.getWidth(layout) + this.getSpacing();
    }

    private float getTopEdge(TGLayout layout) {
        int style = layout.getStyle();
        if ((style & 0xC) == 12) {
            return this.getPosY() + (this.getTs().getPosition(8) - layout.getScoreLineSpacing());
        }
        if ((style & 4) != 0) {
            return this.getPosY() + (this.getTs().getPosition(8) - layout.getScoreLineSpacing());
        }
        if ((style & 8) != 0) {
            return this.getPosY() + (this.getTs().getPosition(14) - layout.getStringSpacing());
        }
        return this.getPosY();
    }

    private float getBottomEdge(TGLayout layout) {
        int style = layout.getStyle();
        if ((style & 0xC) == 12) {
            return this.getPosY() + (this.getTs().getPosition(14) + this.getTrackImpl().getTabHeight() + layout.getStringSpacing());
        }
        if ((style & 4) != 0) {
            return this.getPosY() + (this.getTs().getPosition(8) + layout.getScoreLineSpacing() * 5.0f);
        }
        if ((style & 8) != 0) {
            return this.getPosY() + (this.getTs().getPosition(14) + this.getTrackImpl().getTabHeight() + layout.getStringSpacing());
        }
        return this.getPosY();
    }
}

