/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.graphics.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.herac.tuxguitar.graphics.control.TGBeatImpl;
import org.herac.tuxguitar.graphics.control.TGChordImpl;
import org.herac.tuxguitar.graphics.control.TGController;
import org.herac.tuxguitar.graphics.control.TGDrumMap;
import org.herac.tuxguitar.graphics.control.TGLayoutStyles;
import org.herac.tuxguitar.graphics.control.TGLyricImpl;
import org.herac.tuxguitar.graphics.control.TGMeasureHeaderImpl;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.graphics.control.TGResourceBuffer;
import org.herac.tuxguitar.graphics.control.TGResources;
import org.herac.tuxguitar.graphics.control.TGTrackImpl;
import org.herac.tuxguitar.graphics.control.TGTrackSpacing;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UIPainter;
import org.herac.tuxguitar.ui.resource.UIRectangle;

public abstract class TGLayout {
    public static final int MODE_VERTICAL = 1;
    public static final int MODE_HORIZONTAL = 2;
    public static final int DEFAULT_MODE = 2;
    public static final int DISPLAY_COMPACT = 1;
    public static final int DISPLAY_MULTITRACK = 2;
    public static final int DISPLAY_SCORE = 4;
    public static final int DISPLAY_TABLATURE = 8;
    public static final int DISPLAY_CHORD_NAME = 16;
    public static final int DISPLAY_CHORD_DIAGRAM = 32;
    public static final int DISPLAY_MODE_BLACK_WHITE = 64;
    public static final int HIGHLIGHT_PLAYED_BEAT = 128;
    private int style;
    private float scale;
    private float fontScale;
    private float width;
    private float height;
    private float minBufferSeparator;
    private float minTopSpacing;
    private float minScoreTabSpacing;
    private float stringSpacing;
    private float scoreLineSpacing;
    private float trackSpacing;
    private float firstTrackSpacing;
    private float firstMeasureSpacing;
    private float firstNoteSpacing;
    private float measureLeftSpacing;
    private float measureRightSpacing;
    private float clefSpacing;
    private float keySignatureSpacing;
    private float timeSignatureSpacing;
    private float chordFretIndexSpacing;
    private float chordStringSpacing;
    private float chordFretSpacing;
    private float chordNoteSize;
    private float chordLineWidth;
    private float repeatEndingSpacing;
    private float effectSpacing;
    private float divisionTypeSpacing;
    private float textSpacing;
    private float markerSpacing;
    private float loopMarkerSpacing;
    private float[] lineWidths;
    private float[] durationWidths;
    private boolean bufferEnabled;
    private boolean playModeEnabled;
    private boolean tabNotePathRendererEnabled;
    private List<TrackPosition> trackPositions;
    private TGController controller;
    private TGResources resources;
    private TGDrumMap drumMap;
    private Map<TGMeasureHeader, List<TGMeasureHeader>> updateDependants;

    public void addUpdateDependant(TGMeasureHeader header, TGMeasureHeader dependant) {
        List<TGMeasureHeader> updateDependants;
        if (!this.updateDependants.containsKey(header)) {
            this.updateDependants.put(header, new ArrayList());
        }
        if (!(updateDependants = this.updateDependants.get(header)).contains(dependant)) {
            updateDependants.add(dependant);
        }
    }

    public TGLayout(TGController controller, int style) {
        this.controller = controller;
        this.trackPositions = new ArrayList<TrackPosition>();
        this.playModeEnabled = false;
        this.resources = new TGResources(this);
        this.drumMap = new TGDrumMap();
        this.updateDependants = new HashMap<TGMeasureHeader, List<TGMeasureHeader>>();
        this.style = style;
        if ((this.style & 8) == 0 && (this.style & 4) == 0) {
            this.style |= 8;
        }
    }

    public void loadStyles() {
        this.loadStyles(1.0f);
    }

    public void loadStyles(float scale) {
        this.loadStyles(scale, scale);
    }

    public void loadStyles(float scale, float fontScale) {
        int i;
        TGLayoutStyles styles = this.getComponent().getStyles();
        this.scale = scale;
        this.fontScale = fontScale;
        this.bufferEnabled = styles.isBufferEnabled();
        this.tabNotePathRendererEnabled = styles.isTabNotePathRendererEnabled();
        this.stringSpacing = styles.getStringSpacing() * this.getScale();
        this.scoreLineSpacing = styles.getScoreLineSpacing() * this.getScale();
        this.minBufferSeparator = styles.getMinBufferSeparator() * this.getScale();
        this.minTopSpacing = styles.getMinTopSpacing() * this.getScale();
        this.minScoreTabSpacing = styles.getMinScoreTabSpacing() * this.getScale();
        this.firstTrackSpacing = styles.getFirstTrackSpacing() * this.getScale();
        this.firstMeasureSpacing = styles.getFirstMeasureSpacing() * this.getScale();
        this.firstNoteSpacing = styles.getFirstNoteSpacing() * this.getScale();
        this.measureLeftSpacing = styles.getMeasureLeftSpacing() * this.getScale();
        this.measureRightSpacing = styles.getMeasureRightSpacing() * this.getScale();
        this.clefSpacing = styles.getClefSpacing() * this.getScale();
        this.keySignatureSpacing = styles.getKeySignatureSpacing() * this.getScale();
        this.timeSignatureSpacing = styles.getTimeSignatureSpacing() * this.getScale();
        this.trackSpacing = styles.getTrackSpacing() * this.getScale();
        this.chordFretIndexSpacing = styles.getChordFretIndexSpacing() * this.getScale();
        this.chordStringSpacing = styles.getChordStringSpacing() * this.getScale();
        this.chordFretSpacing = styles.getChordFretSpacing() * this.getScale();
        this.chordNoteSize = styles.getChordNoteSize() * this.getScale();
        this.chordLineWidth = styles.getChordLineWidth() * this.getScale();
        this.repeatEndingSpacing = styles.getRepeatEndingSpacing() * this.getScale();
        this.textSpacing = styles.getTextSpacing() * this.getScale();
        this.markerSpacing = styles.getMarkerSpacing() * this.getScale();
        this.loopMarkerSpacing = styles.getLoopMarkerSpacing() * this.getScale();
        this.divisionTypeSpacing = styles.getDivisionTypeSpacing() * this.getScale();
        this.effectSpacing = styles.getEffectSpacing() * this.getScale();
        this.lineWidths = new float[styles.getLineWidths() != null ? styles.getLineWidths().length : 0];
        for (i = 0; i < this.lineWidths.length; ++i) {
            this.lineWidths[i] = styles.getLineWidths()[i] * this.getScale();
        }
        this.durationWidths = new float[styles.getDurationWidths() != null ? styles.getDurationWidths().length : 0];
        for (i = 0; i < this.durationWidths.length; ++i) {
            this.durationWidths[i] = styles.getDurationWidths()[i] * this.getScale();
        }
        this.getResources().load(styles);
    }

    public abstract void paintSong(UIPainter var1, UIRectangle var2, float var3, float var4);

    public abstract int getMode();

    public void paint(UIPainter painter, UIRectangle clientArea, float fromX, float fromY) {
        this.playModeEnabled = false;
        this.paintSong(painter, clientArea, fromX, fromY);
    }

    public void paintMeasure(TGMeasureImpl measure, UIPainter painter, float spacing) {
        measure.setSpacing(spacing);
        measure.paintMeasure(this, painter);
    }

    public void updateSong() {
        this.getResourceBuffer().clearRegistry();
        this.updateMeasures();
    }

    public void updateMeasures() {
        int measureCount = this.getSong().countMeasureHeaders();
        for (int measureIdx = 0; measureIdx < measureCount; ++measureIdx) {
            this.updateMeasureIndex(measureIdx);
        }
    }

    public void updateMeasureNumber(Integer number) {
        this.updateMeasureNumbers(Collections.singletonList(number));
    }

    public void updateMeasureNumbers(List<Integer> numbers) {
        ArrayList<TGMeasureHeader> headersToUpdate = new ArrayList<TGMeasureHeader>();
        for (Integer number : numbers) {
            TGMeasureHeader header = this.getSongManager().getMeasureHeader(this.getSong(), number);
            if (header != null && !headersToUpdate.contains(header)) {
                headersToUpdate.add(header);
            }
            if (!this.updateDependants.containsKey(header)) continue;
            List<TGMeasureHeader> dependants = this.updateDependants.get(header);
            for (TGMeasureHeader dependant : dependants) {
                if (headersToUpdate.contains(dependant)) continue;
                headersToUpdate.add(dependant);
            }
            this.updateDependants.remove(header);
        }
        Collections.sort(headersToUpdate, new Comparator<TGMeasureHeader>(){

            @Override
            public int compare(TGMeasureHeader o1, TGMeasureHeader o2) {
                return Integer.valueOf(o1.getNumber()).compareTo(o2.getNumber());
            }
        });
        for (TGMeasureHeader header : headersToUpdate) {
            int index = this.getSongManager().getMeasureHeaderIndex(this.getSong(), header);
            if (index < 0) continue;
            this.updateMeasureIndex(index);
        }
    }

    private void updateMeasureIndex(int index) {
        if (index >= 0 && index < this.getSong().countMeasureHeaders()) {
            TGMeasureImpl measure;
            TGTrackImpl track;
            int trackIdx;
            ((TGMeasureHeaderImpl)this.getSong().getMeasureHeader(index)).update(this, index);
            int trackCount = this.getSong().countTracks();
            for (trackIdx = 0; trackIdx < trackCount; ++trackIdx) {
                track = (TGTrackImpl)this.getSong().getTrack(trackIdx);
                measure = (TGMeasureImpl)track.getMeasure(index);
                measure.create(this);
            }
            for (trackIdx = 0; trackIdx < trackCount; ++trackIdx) {
                track = (TGTrackImpl)this.getSong().getTrack(trackIdx);
                measure = (TGMeasureImpl)track.getMeasure(index);
                track.update(this);
                measure.update(this);
            }
        }
    }

    public void paintLines(TGTrackImpl track, TGTrackSpacing ts, UIPainter painter, float x, float y, float width) {
        if (width > 0.0f) {
            this.setLineStyle(painter);
            float tempX = x < 0.0f ? 0.0f : x;
            float tempY = y;
            if ((this.style & 4) != 0) {
                float posY = tempY + ts.getPosition(8);
                painter.initPath();
                painter.setAntialias(false);
                for (int i = 1; i <= 5; ++i) {
                    painter.moveTo(tempX, posY);
                    painter.lineTo(tempX + width, posY);
                    posY += this.getScoreLineSpacing();
                }
                painter.closePath();
            }
            if ((this.style & 8) != 0) {
                tempY += ts.getPosition(14);
                painter.initPath();
                painter.setAntialias(false);
                for (int i = 0; i < track.stringCount(); ++i) {
                    painter.moveTo(tempX, tempY);
                    painter.lineTo(tempX + width, tempY);
                    tempY += this.getStringSpacing();
                }
                painter.closePath();
            }
        }
    }

    public void paintPlayMode(UIPainter painter, TGMeasureImpl measure, TGBeatImpl beat) {
        this.playModeEnabled = true;
        measure.paintMeasure(this, painter);
        if (beat != null) {
            beat.paint(this, painter, measure.getPosX() + measure.getHeaderImpl().getLeftSpacing(this), measure.getPosY(), (this.style & 0x80) != 0);
        }
        ((TGLyricImpl)measure.getTrackImpl().getLyrics()).paintCurrentNoteBeats(painter, this, measure, measure.getPosX(), measure.getPosY());
        this.playModeEnabled = false;
    }

    public void fillBackground(UIPainter painter, UIRectangle area) {
        this.fillBackground(painter, area, false);
    }

    public void fillBackground(UIPainter painter, UIRectangle area, boolean isPlaying) {
        UIColor background = isPlaying ? this.getResources().getBackgroundColorPlaying() : this.getResources().getBackgroundColor();
        painter.setBackground(this.getLightColor(background));
        painter.initPath(2);
        painter.addRectangle(area.getX(), area.getY(), area.getWidth(), area.getHeight());
        painter.closePath();
    }

    protected float checkScale() {
        float v1 = (this.style & 4) != 0 ? this.getScoreLineSpacing() * 1.25f : 0.0f;
        float v2 = (this.style & 8) != 0 ? this.getStringSpacing() : 0.0f;
        float scale = Math.max(v1, v2) / 10.0f;
        return scale;
    }

    protected void checkDefaultSpacing(TGTrackSpacing ts) {
        float checkPosition = -1.0f;
        float minBufferSeparator = this.getMinBufferSeparator();
        if ((this.style & 4) != 0) {
            float bufferSeparator = ts.getPosition(7) - ts.getPosition(4);
            if (bufferSeparator < minBufferSeparator) {
                ts.setSize(4, minBufferSeparator - bufferSeparator);
            }
            checkPosition = ts.getPosition(8);
        } else if ((this.style & 8) != 0) {
            float bufferSeparator = ts.getPosition(14) - ts.getPosition(4);
            if (bufferSeparator < minBufferSeparator) {
                ts.setSize(4, minBufferSeparator - bufferSeparator);
            }
            checkPosition = ts.getPosition(14);
        }
        if (checkPosition >= 0.0f && checkPosition < this.getMinTopSpacing()) {
            ts.setSize(0, this.getMinTopSpacing() - checkPosition);
        }
    }

    public float getSpacingForQuarter(TGDuration duration) {
        return 960.0f / (float)duration.getTime() * this.getDurationWidth(duration);
    }

    public float getDurationWidth(TGDuration duration) {
        float durationWidth = 0.0f;
        if (this.durationWidths != null) {
            int index = 0;
            for (int value = 1; value <= duration.getValue(); value *= 2) {
                if (this.durationWidths.length <= index) continue;
                durationWidth = this.durationWidths[index++];
            }
        }
        return durationWidth;
    }

    public float getMinimumDurationWidth() {
        Float minimumWidth = null;
        if (this.durationWidths != null) {
            for (int i = 0; i < this.durationWidths.length; ++i) {
                if (minimumWidth != null && !(minimumWidth.floatValue() > this.durationWidths[i])) continue;
                minimumWidth = Float.valueOf(this.durationWidths[i]);
            }
        }
        return minimumWidth != null ? minimumWidth.floatValue() : 0.0f;
    }

    public float getLineWidth(int level) {
        if (this.lineWidths != null) {
            return this.lineWidths[this.lineWidths.length > level ? level : this.lineWidths.length - 1];
        }
        return 0.0f;
    }

    public float getScoreNoteWidth() {
        return this.getScoreLineSpacing() * 1.085f;
    }

    public boolean isPlayModeEnabled() {
        return this.playModeEnabled;
    }

    public void setMeasureNumberStyle(UIPainter painter) {
        painter.setFont(this.getResources().getDefaultFont());
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setForeground(this.getDarkColor(this.getResources().getMeasureNumberColor()));
    }

    public void setDivisionsStyle(UIPainter painter, boolean fill) {
        painter.setFont(this.getResources().getDefaultFont());
        painter.setBackground(fill ? this.getDarkColor(this.getResources().getForegroundColor()) : this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setForeground(this.getDarkColor(this.getResources().getForegroundColor()));
    }

    public void setTempoStyle(UIPainter painter, boolean fontStyle) {
        painter.setFont(this.getResources().getDefaultFont());
        painter.setForeground(this.getDarkColor(this.getResources().getForegroundColor()));
        painter.setBackground(fontStyle ? this.getLightColor(this.getResources().getBackgroundColor()) : this.getDarkColor(this.getResources().getForegroundColor()));
    }

    public void setTripletFeelStyle(UIPainter painter, boolean fontStyle) {
        painter.setFont(this.getResources().getDefaultFont());
        painter.setForeground(this.getDarkColor(this.getResources().getForegroundColor()));
        painter.setBackground(fontStyle ? this.getLightColor(this.getResources().getBackgroundColor()) : this.getDarkColor(this.getResources().getForegroundColor()));
    }

    public void setLyricStyle(UIPainter painter, boolean playMode) {
        painter.setFont(this.getResources().getLyricFont());
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setForeground(playMode ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getForegroundColor()));
    }

    public void setMarkerStyle(UIPainter painter, UIColor color) {
        painter.setFont(this.getResources().getMarkerFont());
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setForeground(this.getDarkColor(color));
    }

    public void setTextStyle(UIPainter painter) {
        painter.setFont(this.getResources().getTextFont());
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setForeground(this.getDarkColor(this.getResources().getForegroundColor()));
    }

    public void setTimeSignatureStyle(UIPainter painter) {
        painter.setForeground(this.getDarkColor(this.getResources().getForegroundColor()));
        painter.setBackground(this.getDarkColor(this.getResources().getForegroundColor()));
    }

    public void setKeySignatureStyle(UIPainter painter) {
        painter.setBackground(this.getDarkColor(this.getResources().getForegroundColor()));
    }

    public void setClefStyle(UIPainter painter) {
        painter.setBackground(this.getDarkColor(this.getResources().getForegroundColor()));
    }

    public void setLineStyle(UIPainter painter) {
        painter.setLineWidth(this.getLineWidth(0));
        painter.setForeground(this.getDarkColor(this.getResources().getLineColor()));
    }

    public void setScoreSilenceStyle(UIPainter painter, boolean playMode) {
        painter.setForeground(playMode ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getScoreNoteColor()));
        painter.setBackground(playMode ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getScoreNoteColor()));
    }

    public void setTabSilenceStyle(UIPainter painter, boolean playMode) {
        painter.setForeground(playMode ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getTabNoteColor()));
        painter.setBackground(playMode ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getTabNoteColor()));
    }

    public void setScoreNoteStyle(UIPainter painter, boolean playing) {
        painter.setForeground(playing ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getScoreNoteColor()));
        painter.setBackground(playing ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getScoreNoteColor()));
    }

    public void setScoreNoteFooterStyle(UIPainter painter) {
        painter.setForeground(this.getDarkColor(this.getResources().getScoreNoteColor()));
        painter.setBackground(this.getDarkColor(this.getResources().getScoreNoteColor()));
    }

    public void setScoreEffectStyle(UIPainter painter) {
        painter.setForeground(this.getDarkColor(this.getResources().getScoreNoteColor()));
        painter.setBackground(this.getDarkColor(this.getResources().getScoreNoteColor()));
    }

    public void setTabNotePathStyle(UIPainter painter, boolean playMode) {
        painter.setForeground(playMode ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getTabNoteColor()));
        painter.setBackground(playMode ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getTabNoteColor()));
    }

    public void setTabNoteFontStyle(UIPainter painter, boolean playMode) {
        painter.setForeground(playMode ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getTabNoteColor()));
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setFont(this.getResources().getNoteFont());
    }

    public void setTabNoteFooterStyle(UIPainter painter) {
        painter.setForeground(this.getDarkColor(this.getResources().getTabNoteColor()));
        painter.setBackground(this.getDarkColor(this.getResources().getTabNoteColor()));
    }

    public void setTiedStyle(UIPainter painter, boolean playing) {
        painter.setForeground(playing ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getScoreNoteColor()));
        painter.setBackground(playing ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getScoreNoteColor()));
    }

    public void setTabTiedStyle(UIPainter painter, boolean playing) {
        painter.setForeground(playing ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getTabNoteColor()));
        painter.setBackground(playing ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getTabNoteColor()));
    }

    public void setTabEffectStyle(UIPainter painter) {
        painter.setForeground(this.getDarkColor(this.getResources().getTabNoteColor()));
        painter.setBackground(this.getDarkColor(this.getResources().getTabNoteColor()));
    }

    public void setTabGraceStyle(UIPainter painter) {
        painter.setFont(this.getResources().getGraceFont());
        painter.setForeground(this.getDarkColor(this.getResources().getTabNoteColor()));
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
    }

    public void setPlayNoteColor(UIPainter painter) {
        painter.setForeground(this.getResources().getPlayNoteColor());
        painter.setBackground(this.getResources().getPlayNoteColor());
    }

    public void setOfflineEffectStyle(UIPainter painter) {
        painter.setForeground(this.getDarkColor((this.getStyle() & 4) != 0 ? this.getResources().getScoreNoteColor() : this.getResources().getTabNoteColor()));
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setFont(this.getResources().getDefaultFont());
    }

    public void setDotStyle(UIPainter painter) {
        painter.setForeground(this.getDarkColor((this.getStyle() & 4) != 0 ? this.getResources().getScoreNoteColor() : this.getResources().getTabNoteColor()));
        painter.setBackground(this.getDarkColor((this.getStyle() & 4) != 0 ? this.getResources().getScoreNoteColor() : this.getResources().getTabNoteColor()));
    }

    public void setDivisionTypeStyle(UIPainter painter) {
        painter.setForeground(this.getDarkColor((this.getStyle() & 4) != 0 ? this.getResources().getScoreNoteColor() : this.getResources().getTabNoteColor()));
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setFont(this.getResources().getDefaultFont());
    }

    public void setRepeatEndingStyle(UIPainter painter) {
        painter.setForeground(this.getDarkColor(this.getResources().getForegroundColor()));
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setFont(this.getResources().getDefaultFont());
    }

    public void setChordStyle(TGChordImpl chord, boolean isPlaying) {
        chord.setFont(this.getResources().getChordFont());
        chord.setForegroundColor(this.getDarkColor(this.getResources().getForegroundColor()));
        if (isPlaying) {
            chord.setBackgroundColor(this.getResources().getBackgroundColorPlaying());
        } else {
            chord.setBackgroundColor(this.getLightColor(this.getResources().getBackgroundColor()));
        }
        chord.setColor(this.getDarkColor(this.getResources().getLineColor()));
        chord.setNoteColor(this.getDarkColor(this.getResources().getTabNoteColor()));
        chord.setTonicColor(this.getDarkColor(this.getResources().getTabNoteColor()));
        chord.setStyle(this.style);
        chord.setFretSpacing(this.getChordFretSpacing());
        chord.setStringSpacing(this.getChordStringSpacing());
        chord.setNoteSize(this.getChordNoteSize());
        chord.setLineWidth(this.getChordLineWidth());
        chord.setFirstFretSpacing(this.getChordFretIndexSpacing());
        chord.setFirstFretFont(this.getResources().getChordFretFont());
    }

    public void setLoopSMarkerStyle(UIPainter painter) {
        painter.setBackground(this.getResources().getLoopSMarkerColor());
    }

    public void setLoopEMarkerStyle(UIPainter painter) {
        painter.setBackground(this.getResources().getLoopEMarkerColor());
    }

    public UIColor getDarkColor(UIColor color) {
        return (this.getStyle() & 0x40) != 0 ? this.getResources().getColorBlack() : color;
    }

    public UIColor getLightColor(UIColor color) {
        return (this.getStyle() & 0x40) != 0 ? this.getResources().getColorWhite() : color;
    }

    public TGSongManager getSongManager() {
        return this.getComponent().getSongManager();
    }

    public TGSong getSong() {
        return this.getComponent().getSong();
    }

    public TGResourceBuffer getResourceBuffer() {
        return this.getComponent().getResourceBuffer();
    }

    public TGController getComponent() {
        return this.controller;
    }

    public TGResources getResources() {
        return this.resources;
    }

    public TGDrumMap getDrumMap() {
        return this.drumMap;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public float getScale() {
        return this.scale;
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public boolean isBufferEnabled() {
        return this.bufferEnabled;
    }

    public boolean isTabNotePathRendererEnabled() {
        return this.tabNotePathRendererEnabled;
    }

    public float getFirstMeasureSpacing() {
        return this.firstMeasureSpacing;
    }

    public float getFirstNoteSpacing() {
        return this.firstNoteSpacing;
    }

    public float getMeasureLeftSpacing() {
        return this.measureLeftSpacing;
    }

    public float getMeasureRightSpacing() {
        return this.measureRightSpacing;
    }

    public float getClefSpacing() {
        return this.clefSpacing;
    }

    public float getKeySignatureSpacing() {
        return this.keySignatureSpacing;
    }

    public float getTimeSignatureSpacing() {
        return this.timeSignatureSpacing;
    }

    public float getMinBufferSeparator() {
        return this.minBufferSeparator;
    }

    public float getMinTopSpacing() {
        return this.minTopSpacing;
    }

    public float getMinScoreTabSpacing() {
        return this.minScoreTabSpacing;
    }

    public float getScoreLineSpacing() {
        return this.scoreLineSpacing;
    }

    public float getFirstTrackSpacing() {
        return this.firstTrackSpacing;
    }

    public float getTrackSpacing() {
        return this.trackSpacing;
    }

    public float getStringSpacing() {
        return this.stringSpacing;
    }

    public float getChordFretIndexSpacing() {
        return this.chordFretIndexSpacing;
    }

    public float getChordStringSpacing() {
        return this.chordStringSpacing;
    }

    public float getChordFretSpacing() {
        return this.chordFretSpacing;
    }

    public float getChordNoteSize() {
        return this.chordNoteSize;
    }

    public float getChordLineWidth() {
        return this.chordLineWidth;
    }

    public float getRepeatEndingSpacing() {
        return this.repeatEndingSpacing;
    }

    public float getDivisionTypeSpacing() {
        return this.divisionTypeSpacing;
    }

    public float getTextSpacing() {
        return this.textSpacing;
    }

    public float getMarkerSpacing() {
        return this.markerSpacing;
    }

    public float getLoopMarkerSpacing() {
        return this.loopMarkerSpacing;
    }

    public float getEffectSpacing() {
        return this.effectSpacing;
    }

    public float getDefaultChordSpacing() {
        float spacing = 0.0f;
        if ((this.style & 0x20) != 0) {
            spacing += 6.0f * this.getChordFretSpacing() + this.getChordFretSpacing();
        }
        if ((this.style & 0x10) != 0) {
            spacing += (float)Math.round(15.0f * this.getScale());
        }
        return spacing;
    }

    public boolean isFirstMeasure(TGMeasureHeader mh) {
        return mh.getNumber() == 1;
    }

    public boolean isFirstMeasure(TGMeasure measure) {
        return this.isFirstMeasure(measure.getHeader());
    }

    public boolean isLastMeasure(TGMeasureHeader mh) {
        return mh.getNumber() == this.getSong().countMeasureHeaders();
    }

    public boolean isLastMeasure(TGMeasure measure) {
        return this.isLastMeasure(measure.getHeader());
    }

    public boolean hasLoopMarker(TGMeasureHeader mh) {
        return this.getComponent().isLoopSHeader(mh) || this.getComponent().isLoopEHeader(mh);
    }

    public boolean hasLoopMarker(TGMeasure measure) {
        return this.hasLoopMarker(measure.getHeader());
    }

    protected void clearTrackPositions() {
        this.trackPositions.clear();
    }

    protected void addTrackPosition(int track, float posY, float height) {
        this.trackPositions.add(new TrackPosition(track, posY, height));
    }

    public int getTrackNumberAt(float y) {
        TrackPosition trackPos = this.getTrackPositionAt(y);
        return trackPos != null ? trackPos.getTrack() : -1;
    }

    public TrackPosition getTrackPositionAt(float y) {
        TrackPosition trackPos = null;
        float minorDistance = 0.0f;
        for (TrackPosition pos : this.trackPositions) {
            float distanceY = Math.min(Math.abs(y - pos.getPosY()), Math.abs(y - (pos.getPosY() + pos.getHeight() - 10.0f)));
            if (trackPos != null && !(distanceY < minorDistance)) continue;
            trackPos = pos;
            minorDistance = distanceY;
        }
        return trackPos;
    }

    public void disposeLayout() {
        this.getResources().dispose();
    }

    public class TrackPosition {
        private int track;
        private float posY;
        private float height;

        public TrackPosition(int track, float posY, float height) {
            this.track = track;
            this.posY = posY;
            this.height = height;
        }

        public float getPosY() {
            return this.posY;
        }

        public float getHeight() {
            return this.height;
        }

        public int getTrack() {
            return this.track;
        }
    }
}

