/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventException;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.util.TGAbstractContext;

public class TGEventHandler {
    private Object lock = new Object();
    private List<TGEventListener> listeners = new ArrayList<TGEventListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(TGEvent event) throws TGEventException {
        Iterator listener;
        ArrayList<Object> listeners = new ArrayList<Object>();
        TGAbstractContext sourceContext = (TGAbstractContext)event.getAttribute("sourceContext");
        if (sourceContext != null && (listener = (TGEventListener)sourceContext.getAttribute(TGEventListener.class.getName())) != null) {
            listeners.add(listener);
        }
        listener = this.lock;
        synchronized (listener) {
            listeners.addAll(this.listeners);
        }
        try {
            for (TGEventListener tGEventListener : listeners) {
                tGEventListener.processEvent(event);
            }
        }
        catch (Throwable e) {
            throw new TGEventException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TGEventListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TGEventListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.listeners.contains(listener)) {
                this.listeners.remove(listener);
            }
        }
    }
}

