/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.midi.synth.remote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.herac.tuxguitar.midi.synth.TGSynthSettings;
import org.herac.tuxguitar.midi.synth.remote.TGClientProcess;
import org.herac.tuxguitar.midi.synth.remote.TGClientStarter;
import org.herac.tuxguitar.midi.synth.remote.TGConnection;
import org.herac.tuxguitar.midi.synth.remote.TGRemoteException;
import org.herac.tuxguitar.midi.synth.remote.TGSession;
import org.herac.tuxguitar.midi.synth.remote.TGStartSessionCommand;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGRemoteHost {
    private TGContext context;
    private Object lock;
    private ServerSocket serverSocket;
    private Map<Integer, TGSession> connections;

    public TGRemoteHost(TGContext context) {
        this.context = context;
        this.lock = new Object();
        this.connections = new HashMap<Integer, TGSession>();
    }

    public TGSession getSession(Integer sessionId) {
        if (this.connections.containsKey(sessionId)) {
            return this.connections.get(sessionId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getNextSessionId() {
        Object object = this.lock;
        synchronized (object) {
            Integer maximum = 0;
            for (Integer sessionId : this.connections.keySet()) {
                if (maximum >= sessionId) continue;
                maximum = sessionId;
            }
            return maximum + 1;
        }
    }

    public TGSession createSession(TGClientStarter starter) throws TGRemoteException {
        Integer sessionId = this.getNextSessionId();
        this.fireServerSocket();
        TGClientProcess tgClientProcess = new TGClientProcess(this.context);
        tgClientProcess.startSession(starter, sessionId, this.serverSocket.getLocalPort());
        while (this.getSession(sessionId) == null) {
            Thread.yield();
            if (tgClientProcess.isAlive()) continue;
            throw new TGRemoteException("Process ended!");
        }
        return this.getSession(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireServerSocket() throws TGRemoteException {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isServerSocketOpen()) {
                    int tries = 0;
                    int defaultPort = this.getDefaultSocketPort();
                    while (!this.isServerSocketOpen()) {
                        try {
                            this.serverSocket = new ServerSocket(defaultPort + tries, 10, this.getSocketHost());
                        }
                        catch (IOException e) {
                            if (tries++ < 10) continue;
                            throw new TGRemoteException(e);
                        }
                    }
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            TGRemoteHost.this.processServerSocket();
                        }
                    }).start();
                }
            }
        }
        catch (IOException e) {
            throw new TGRemoteException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processServerSocket() {
        try {
            boolean closed = true;
            Object object = this.lock;
            synchronized (object) {
                closed = this.serverSocket.isClosed();
            }
            while (!closed) {
                final Socket clientSocket = this.serverSocket.accept();
                new Thread(new Runnable(){
                    final /* synthetic */ TGRemoteHost this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        this.this$0.processClientSocket(clientSocket);
                    }
                }).start();
                Object object2 = this.lock;
                synchronized (object2) {
                    closed = this.serverSocket.isClosed();
                }
            }
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void processClientSocket(Socket clientSocket) {
        try {
            TGConnection connection = new TGConnection(clientSocket);
            TGStartSessionCommand startSessionCommand = new TGStartSessionCommand(connection);
            TGSession session = (TGSession)startSessionCommand.safeProcess();
            if (session != null) {
                if (!this.connections.containsKey(session.getId())) {
                    this.connections.put(session.getId(), session);
                }
                while (!session.isClosed()) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e) {
                        session.close();
                    }
                }
                this.connections.remove(session.getId());
            }
            if (!clientSocket.isClosed()) {
                clientSocket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isServerSocketOpen() {
        return this.serverSocket != null && !this.serverSocket.isClosed();
    }

    public InetAddress getSocketHost() throws UnknownHostException {
        return InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
    }

    public Integer getDefaultSocketPort() throws UnknownHostException {
        return new TGSynthSettings(this.context).getRemoteHostServerPort();
    }

    public static TGRemoteHost getInstance(TGContext context) {
        return (TGRemoteHost)TGSingletonUtil.getInstance((TGContext)context, (String)TGRemoteHost.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGRemoteHost>(){

            public TGRemoteHost createInstance(TGContext context) {
                return new TGRemoteHost(context);
            }
        });
    }
}

