/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.midi.synth;

public class TGAudioBuffer {
    public static final int CHANNELS = 2;
    public static final int BUFFER_SIZE = 1024;
    public static final float SAMPLE_RATE = 44100.0f;
    public static final boolean BIGENDIAN = false;
    private int buffers;
    private byte[] buffer = new byte[2048];

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getLength() {
        return this.buffer.length;
    }

    public void clear() {
        this.buffers = 0;
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = 0;
        }
    }

    public void write(TGAudioBuffer buffer) {
        this.write(buffer.getBuffer());
    }

    public void write(byte[] sample) {
        if (this.buffer.length == sample.length) {
            for (int i = 0; i < this.buffer.length; ++i) {
                this.buffer[i] = sample[i];
            }
        }
    }

    public void write(float[][] sample) {
        int index = 0;
        short sampleValue = 0;
        for (int i = 0; i < 512; ++i) {
            for (int j = 0; j < 2; ++j) {
                sampleValue = (short)(sample[j % sample.length][i] * 32767.0f);
                this.buffer[index++] = (byte)((sampleValue & 0xFF) >> 0);
                this.buffer[index++] = (byte)((sampleValue & 0xFF00) >> 8);
            }
        }
    }

    public void read(float[][] bufferToFill) {
        int index = 0;
        int bufferValue = 0;
        for (int i = 0; i < 512; ++i) {
            for (int j = 0; j < 2; ++j) {
                bufferValue = 0;
                for (int n = 0; n < 2; ++n) {
                    bufferValue = (short)(bufferValue | (this.buffer[index++] & 0xFF) << 8 * n);
                }
                bufferToFill[j % bufferToFill.length][i] = (float)bufferValue / 32767.0f;
            }
        }
    }

    public void mix(TGAudioBuffer buffer) {
        this.mix(buffer.getBuffer());
    }

    public void mix(byte[] sample) {
        if (this.buffer.length == sample.length) {
            ++this.buffers;
            int index = 0;
            int s1Value = 0;
            int s2Value = 0;
            short mixedValue = 0;
            float mixAmp = 1.0f / (float)this.buffers;
            for (int i = 0; i < 512; ++i) {
                for (int j = 0; j < 2; ++j) {
                    s1Value = 0;
                    s2Value = 0;
                    for (int n = 0; n < 2; ++n) {
                        s1Value = (short)(s1Value | (this.buffer[index + n] & 0xFF) << 8 * n);
                        s2Value = (short)(s2Value | (sample[index + n] & 0xFF) << 8 * n);
                    }
                    float f1 = (float)s1Value / 32767.0f * (1.0f - mixAmp);
                    float f2 = (float)s2Value / 32767.0f * mixAmp;
                    mixedValue = (short)((f1 + f2) * 32767.0f);
                    this.buffer[index++] = (byte)((mixedValue & 0xFF) >> 0 & 0xFF);
                    this.buffer[index++] = (byte)((mixedValue & 0xFF00) >> 8 & 0xFF);
                }
            }
        }
    }

    public void clip() {
        if (this.buffers > 1) {
            int index = 0;
            int sampleValue = 0;
            short ampValue = 0;
            int maxValue = Short.MAX_VALUE;
            int minValue = Short.MIN_VALUE;
            for (int i = 0; i < 512; ++i) {
                for (int j = 0; j < 2; ++j) {
                    sampleValue = 0;
                    for (int n = 0; n < 2; ++n) {
                        sampleValue = (short)(sampleValue | (this.buffer[index + n] & 0xFF) << 8 * n);
                    }
                    ampValue = (short)(Math.max(Math.min(sampleValue * this.buffers, maxValue), minValue) & 0xFFFF);
                    this.buffer[index++] = (byte)((ampValue & 0xFF) >> 0 & 0xFF);
                    this.buffer[index++] = (byte)((ampValue & 0xFF00) >> 8 & 0xFF);
                }
            }
        }
    }

    public void balance(float[] volumes) {
        int index = 0;
        int sample = 0;
        for (int i = 0; i < 512; ++i) {
            for (int c = 0; c < 2; ++c) {
                if (c >= volumes.length) continue;
                sample = 0;
                for (int n = 0; n < 2; ++n) {
                    sample = (short)(sample | (this.buffer[index + n] & 0xFF) << 8 * n);
                }
                sample = (short)(Math.round(Math.max(Math.min((float)sample * volumes[c], 32767.0f), -32768.0f)) & 0xFFFF);
                this.buffer[index++] = (byte)((sample & 0xFF) >> 0 & 0xFF);
                this.buffer[index++] = (byte)((sample & 0xFF00) >> 8 & 0xFF);
            }
        }
    }
}

