/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.pdf;

import org.herac.tuxguitar.app.action.impl.view.TGOpenViewAction;
import org.herac.tuxguitar.app.io.persistence.TGPersistenceSettingsHandler;
import org.herac.tuxguitar.app.io.persistence.TGPersistenceSettingsMode;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.system.plugins.TGPluginSettingsHandler;
import org.herac.tuxguitar.app.view.dialog.printer.TGPrintSettingsDialog;
import org.herac.tuxguitar.app.view.dialog.printer.TGPrintSettingsDialogController;
import org.herac.tuxguitar.app.view.dialog.printer.TGPrintSettingsHandler;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.graphics.control.TGLayoutStyles;
import org.herac.tuxguitar.graphics.control.print.TGPrintSettings;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGSongStreamContext;
import org.herac.tuxguitar.io.pdf.PDFLayoutStylesUI;
import org.herac.tuxguitar.io.pdf.PDFSettingsDialog;
import org.herac.tuxguitar.io.pdf.PDFSongWriter;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

public class PDFSettingsHandler
implements TGPersistenceSettingsHandler,
TGPluginSettingsHandler {
    private TGContext context;

    public PDFSettingsHandler(TGContext context) {
        this.context = context;
    }

    public TGFileFormat getFileFormat() {
        return PDFSongWriter.FILE_FORMAT;
    }

    public TGPersistenceSettingsMode getMode() {
        return TGPersistenceSettingsMode.WRITE;
    }

    public void handleSettings(final TGSongStreamContext context, final Runnable callback) {
        PDFLayoutStylesUI tgLayoutStyles = new PDFLayoutStylesUI(TGConfigManager.getInstance((TGContext)this.context), this.context);
        context.setAttribute(TGLayoutStyles.class.getName(), (Object)tgLayoutStyles);
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.gui.open-view");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG));
        tgActionProcessor.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGPrintSettingsDialogController());
        tgActionProcessor.setAttribute(TGPrintSettingsDialog.ATTRIBUTE_HANDLER, (Object)new TGPrintSettingsHandler(){
            final /* synthetic */ PDFSettingsHandler this$0;
            {
                this.this$0 = this$0;
            }

            public void updatePrintSettings(TGPrintSettings styles, int zoomValue) {
                context.setAttribute("attribute.print.settings.styles", (Object)styles);
                context.setAttribute("attribute.print.settings.zoom", (Object)zoomValue);
                callback.run();
            }
        });
        tgActionProcessor.process();
    }

    public void openSettingsDialog(UIWindow parent) {
        new PDFSettingsDialog(this.context).configure(parent);
    }
}

