/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.musicxml;

import java.util.ArrayList;
import java.util.Arrays;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGTrack;

public class MusicXMLLyricWriter {
    private String[] lyrics;
    private int lyricIndex;
    private int lyricFrom;
    private Syllabic syllabicState;

    private static String removeLastChar(String string) {
        return string == null || string.length() == 0 ? null : string.substring(0, string.length() - 1);
    }

    private static String[] getLyricSlice(String[] lyricStrings, int start, int number) {
        try {
            return (String[])Arrays.stream(lyricStrings, start, start + number).toArray(String[]::new);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            String[] empty = new String[]{""};
            return empty;
        }
    }

    public MusicXMLLyricWriter(TGTrack track) {
        this.lyricFrom = track.getLyrics().getFrom();
        this.lyrics = track.getLyrics().getLyricBeats();
        this.lyricIndex = 0;
        this.syllabicState = Syllabic.NONE;
    }

    public MusicXMLMeasureLyric[] generateLyricList(TGMeasure measure) {
        if (measure.getNumber() < this.lyricFrom) {
            return null;
        }
        int number = 0;
        for (TGBeat beat : measure.getBeats()) {
            if (beat.isRestBeat()) continue;
            ++number;
        }
        ArrayList<MusicXMLMeasureLyric> measureLyrics = new ArrayList<MusicXMLMeasureLyric>();
        String[] measureLyricStrings = MusicXMLLyricWriter.getLyricSlice(this.lyrics, this.lyricIndex, number);
        this.lyricIndex += number;
        Syllabic syllabic = Syllabic.NONE;
        for (int i = 0; i < measureLyricStrings.length; ++i) {
            switch (this.syllabicState.ordinal()) {
                case 0: {
                    if (measureLyricStrings[i].endsWith("-")) {
                        measureLyricStrings[i] = MusicXMLLyricWriter.removeLastChar(measureLyricStrings[i]);
                        syllabic = Syllabic.BEGIN;
                        this.syllabicState = Syllabic.BEGIN;
                        break;
                    }
                    syllabic = Syllabic.SINGLE;
                    this.syllabicState = Syllabic.NONE;
                    break;
                }
                case 1: {
                    syllabic = Syllabic.END;
                    this.syllabicState = Syllabic.NONE;
                    break;
                }
                case 2: {
                    if (measureLyricStrings[i].endsWith("-")) {
                        measureLyricStrings[i] = MusicXMLLyricWriter.removeLastChar(measureLyricStrings[i]);
                        syllabic = Syllabic.MIDDLE;
                        this.syllabicState = Syllabic.MIDDLE;
                        break;
                    }
                    syllabic = Syllabic.END;
                    this.syllabicState = Syllabic.NONE;
                    break;
                }
                case 3: {
                    if (measureLyricStrings[i].endsWith("-")) {
                        measureLyricStrings[i] = MusicXMLLyricWriter.removeLastChar(measureLyricStrings[i]);
                        syllabic = Syllabic.MIDDLE;
                        this.syllabicState = Syllabic.MIDDLE;
                        break;
                    }
                    syllabic = Syllabic.END;
                    this.syllabicState = Syllabic.NONE;
                    break;
                }
                case 4: {
                    syllabic = Syllabic.NONE;
                    this.syllabicState = Syllabic.NONE;
                }
            }
            measureLyrics.add(new MusicXMLMeasureLyric(syllabic, measureLyricStrings[i]));
        }
        MusicXMLMeasureLyric[] measureLyricArray = new MusicXMLMeasureLyric[measureLyrics.size()];
        measureLyrics.toArray(measureLyricArray);
        return measureLyricArray;
    }

    public static enum Syllabic {
        NONE,
        SINGLE,
        BEGIN,
        MIDDLE,
        END;


        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "none";
                }
                case 1: {
                    return "single";
                }
                case 2: {
                    return "begin";
                }
                case 3: {
                    return "middle";
                }
                case 4: {
                    return "end";
                }
            }
            return "single";
        }
    }

    public class MusicXMLMeasureLyric {
        public Syllabic syllabic;
        public String text;

        public MusicXMLMeasureLyric(Syllabic syllabic, String text) {
            this.syllabic = syllabic;
            this.text = text;
        }
    }
}

