/*
 * Decompiled with CFR 0.152.
 */
package media.sound;

import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.Patch;
import media.sound.ModelInstrument;
import media.sound.ModelPatch;
import media.sound.ModelPerformer;

public class SimpleInstrument
extends ModelInstrument {
    protected int preset = 0;
    protected int bank = 0;
    protected boolean percussion = false;
    protected String name = "";
    protected List<SimpleInstrumentPart> parts = new ArrayList<SimpleInstrumentPart>();

    public SimpleInstrument() {
        super(null, null, null, null);
    }

    public void clear() {
        this.parts.clear();
    }

    public void add(ModelPerformer[] performers, int keyFrom, int keyTo, int velFrom, int velTo, int exclusiveClass) {
        SimpleInstrumentPart part = new SimpleInstrumentPart();
        part.performers = performers;
        part.keyFrom = keyFrom;
        part.keyTo = keyTo;
        part.velFrom = velFrom;
        part.velTo = velTo;
        part.exclusiveClass = exclusiveClass;
        this.parts.add(part);
    }

    public void add(ModelPerformer[] performers, int keyFrom, int keyTo, int velFrom, int velTo) {
        this.add(performers, keyFrom, keyTo, velFrom, velTo, -1);
    }

    public void add(ModelPerformer[] performers, int keyFrom, int keyTo) {
        this.add(performers, keyFrom, keyTo, 0, 127, -1);
    }

    public void add(ModelPerformer[] performers) {
        this.add(performers, 0, 127, 0, 127, -1);
    }

    public void add(ModelPerformer performer, int keyFrom, int keyTo, int velFrom, int velTo, int exclusiveClass) {
        this.add(new ModelPerformer[]{performer}, keyFrom, keyTo, velFrom, velTo, exclusiveClass);
    }

    public void add(ModelPerformer performer, int keyFrom, int keyTo, int velFrom, int velTo) {
        this.add(new ModelPerformer[]{performer}, keyFrom, keyTo, velFrom, velTo);
    }

    public void add(ModelPerformer performer, int keyFrom, int keyTo) {
        this.add(new ModelPerformer[]{performer}, keyFrom, keyTo);
    }

    public void add(ModelPerformer performer) {
        this.add(new ModelPerformer[]{performer});
    }

    public void add(ModelInstrument ins, int keyFrom, int keyTo, int velFrom, int velTo, int exclusiveClass) {
        this.add(ins.getPerformers(), keyFrom, keyTo, velFrom, velTo, exclusiveClass);
    }

    public void add(ModelInstrument ins, int keyFrom, int keyTo, int velFrom, int velTo) {
        this.add(ins.getPerformers(), keyFrom, keyTo, velFrom, velTo);
    }

    public void add(ModelInstrument ins, int keyFrom, int keyTo) {
        this.add(ins.getPerformers(), keyFrom, keyTo);
    }

    public void add(ModelInstrument ins) {
        this.add(ins.getPerformers());
    }

    @Override
    public ModelPerformer[] getPerformers() {
        int percount = 0;
        for (SimpleInstrumentPart part : this.parts) {
            if (part.performers == null) continue;
            percount += part.performers.length;
        }
        ModelPerformer[] performers = new ModelPerformer[percount];
        int px = 0;
        for (SimpleInstrumentPart part : this.parts) {
            if (part.performers == null) continue;
            for (ModelPerformer mperfm : part.performers) {
                ModelPerformer performer = new ModelPerformer();
                performer.setName(this.getName());
                performers[px++] = performer;
                performer.setDefaultConnectionsEnabled(mperfm.isDefaultConnectionsEnabled());
                performer.setKeyFrom(mperfm.getKeyFrom());
                performer.setKeyTo(mperfm.getKeyTo());
                performer.setVelFrom(mperfm.getVelFrom());
                performer.setVelTo(mperfm.getVelTo());
                performer.setExclusiveClass(mperfm.getExclusiveClass());
                performer.setSelfNonExclusive(mperfm.isSelfNonExclusive());
                performer.setReleaseTriggered(mperfm.isReleaseTriggered());
                if (part.exclusiveClass != -1) {
                    performer.setExclusiveClass(part.exclusiveClass);
                }
                if (part.keyFrom > performer.getKeyFrom()) {
                    performer.setKeyFrom(part.keyFrom);
                }
                if (part.keyTo < performer.getKeyTo()) {
                    performer.setKeyTo(part.keyTo);
                }
                if (part.velFrom > performer.getVelFrom()) {
                    performer.setVelFrom(part.velFrom);
                }
                if (part.velTo < performer.getVelTo()) {
                    performer.setVelTo(part.velTo);
                }
                performer.getOscillators().addAll(mperfm.getOscillators());
                performer.getConnectionBlocks().addAll(mperfm.getConnectionBlocks());
            }
        }
        return performers;
    }

    @Override
    public Object getData() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ModelPatch getPatch() {
        return new ModelPatch(this.bank, this.preset, this.percussion);
    }

    public void setPatch(Patch patch) {
        if (patch instanceof ModelPatch && ((ModelPatch)patch).isPercussion()) {
            this.percussion = true;
            this.bank = patch.getBank();
            this.preset = patch.getProgram();
        } else {
            this.percussion = false;
            this.bank = patch.getBank();
            this.preset = patch.getProgram();
        }
    }

    private static class SimpleInstrumentPart {
        ModelPerformer[] performers;
        int keyFrom;
        int keyTo;
        int velFrom;
        int velTo;
        int exclusiveClass;

        private SimpleInstrumentPart() {
        }
    }
}

