/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.tray;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.ui.swt.resource.SWTImage;
import org.herac.tuxguitar.ui.swt.widget.SWTWindow;
import org.herac.tuxguitar.util.TGContext;

public class TGTrayMenu {
    private TGContext context;
    private Menu menu;
    private MenuItem play;
    private MenuItem stop;
    private MenuItem exit;

    public TGTrayMenu(TGContext context) {
        this.context = context;
    }

    public void make() {
        this.menu = new Menu((Decorations)((SWTWindow)TGWindow.getInstance((TGContext)this.context).getWindow()).getControl(), 8);
        this.play = new MenuItem(this.menu, 8);
        this.play.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new TGActionProcessor(TGTrayMenu.this.context, "action.transport.play").process();
            }
        });
        this.stop = new MenuItem(this.menu, 8);
        this.stop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new TGActionProcessor(TGTrayMenu.this.context, "action.transport.stop").process();
            }
        });
        new MenuItem(this.menu, 2);
        this.exit = new MenuItem(this.menu, 8);
        this.exit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new TGActionProcessor(TGTrayMenu.this.context, "action.file.exit").process();
            }
        });
    }

    public void loadProperties() {
        if (this.menu != null && !this.menu.isDisposed()) {
            if (TuxGuitar.getInstance().getPlayer().isRunning()) {
                this.play.setText(TuxGuitar.getProperty((String)"transport.pause"));
            } else {
                this.play.setText(TuxGuitar.getProperty((String)"transport.start"));
            }
            this.stop.setText(TuxGuitar.getProperty((String)"transport.stop"));
            this.exit.setText(TuxGuitar.getProperty((String)"file.exit"));
        }
    }

    public void loadIcons() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.stop.setImage(((SWTImage)TuxGuitar.getInstance().getIconManager().getTransportIconStop()).getHandle());
            if (TuxGuitar.getInstance().getPlayer().isRunning()) {
                this.play.setImage(((SWTImage)TuxGuitar.getInstance().getIconManager().getTransportIconPause()).getHandle());
            } else {
                this.play.setImage(((SWTImage)TuxGuitar.getInstance().getIconManager().getTransportIconPlay()).getHandle());
            }
        }
    }

    public void show() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.loadProperties();
            this.loadIcons();
            this.menu.setVisible(true);
        }
    }

    public void dispose() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
    }
}

