/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.util;

import org.herac.tuxguitar.editor.util.TGProcess;
import org.herac.tuxguitar.thread.TGThreadLoop;
import org.herac.tuxguitar.thread.TGThreadManager;
import org.herac.tuxguitar.util.TGContext;

public class TGDelayedProcess
implements TGProcess {
    private TGContext context;
    private Runnable runnable;
    private Integer timeOut;
    private Long timeIn;
    private boolean processing;

    public TGDelayedProcess(TGContext context, Integer timeOut, Runnable runnable) {
        this.context = context;
        this.runnable = runnable;
        this.timeOut = timeOut;
        this.timeIn = null;
    }

    @Override
    public void process() {
        this.timeIn = System.currentTimeMillis();
        if (!this.processing) {
            this.processing = true;
            this.processLater();
        }
    }

    private void processRunnable() {
        TGThreadManager.getInstance((TGContext)this.context).loop(new TGThreadLoop(){

            public Long process() {
                TGDelayedProcess.this.processing = true;
                long remainingTime = TGDelayedProcess.this.timeIn + (long)TGDelayedProcess.this.timeOut.intValue() - System.currentTimeMillis();
                if (remainingTime <= 0L) {
                    TGDelayedProcess.this.runnable.run();
                    TGDelayedProcess.this.processing = false;
                    return BREAK;
                }
                return remainingTime;
            }
        });
    }

    private void processLater() {
        TGThreadManager.getInstance((TGContext)this.context).start(new Runnable(){

            @Override
            public void run() {
                TGDelayedProcess.this.processRunnable();
            }
        });
    }
}

