/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl;

import java.util.ArrayList;
import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.TGUndoableEdit;

public class TGUndoableEditComposite
implements TGUndoableEdit {
    private ArrayList<TGUndoableEdit> edits = new ArrayList();

    public void addEdit(TGUndoableEdit edit) {
        this.edits.add(edit);
    }

    public ArrayList<TGUndoableEdit> getEdits() {
        return this.edits;
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        for (TGUndoableEdit edit : this.edits) {
            edit.redo(actionContext);
        }
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        for (TGUndoableEdit edit : this.edits) {
            edit.undo(actionContext);
        }
    }

    @Override
    public boolean canRedo() {
        for (TGUndoableEdit edit : this.edits) {
            if (edit.canRedo()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canUndo() {
        for (TGUndoableEdit edit : this.edits) {
            if (edit.canUndo()) continue;
            return false;
        }
        return true;
    }
}

