/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.action.note;

import java.util.Iterator;
import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.song.managers.TGMeasureManager;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGNoteRange;

public abstract class TGTransposeNoteSemitoneAction
extends TGActionBase {
    public TGTransposeNoteSemitoneAction(TGContext context, String name) {
        super(context, name);
    }

    protected abstract boolean transposeSemiTone(TGMeasureManager var1, TGMeasure var2, TGBeat var3, TGNote var4);

    protected abstract boolean canTransposeSemiTone(TGMeasureManager var1, TGMeasure var2, TGBeat var3, TGNote var4);

    @Override
    protected void processAction(TGActionContext context) {
        TGNoteRange noteRange = (TGNoteRange)context.getAttribute("note-range");
        TGSongManager songManager = this.getSongManager(context);
        if (noteRange != null && !noteRange.isEmpty()) {
            boolean success;
            TGNote note;
            TGBeat beat;
            TGMeasure measure;
            Iterator it = noteRange.getNotes().iterator();
            for (success = true; it.hasNext() && success; success &= this.canTransposeSemiTone(songManager.getMeasureManager(), measure, beat, note)) {
                note = (TGNote)it.next();
                beat = note.getVoice().getBeat();
                measure = beat.getMeasure();
            }
            if (success) {
                boolean moreThanOneBeat = false;
                TGBeat refBeat = null;
                for (TGNote note2 : noteRange.getNotes()) {
                    TGBeat beat2 = note2.getVoice().getBeat();
                    TGMeasure measure2 = beat2.getMeasure();
                    moreThanOneBeat |= refBeat != null && beat2 != refBeat;
                    refBeat = beat2;
                    this.transposeSemiTone(songManager.getMeasureManager(), measure2, beat2, note2);
                }
                if (!moreThanOneBeat) {
                    context.setAttribute("success", (Object)Boolean.TRUE);
                }
            }
        }
    }
}

