/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.action.note;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.song.managers.TGMeasureManager;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGNoteRange;

public class TGChangeVelocityAction
extends TGActionBase {
    public static final String NAME = "action.note.general.velocity";

    public TGChangeVelocityAction(TGContext context) {
        super(context, NAME);
    }

    @Override
    protected void processAction(TGActionContext context) {
        Integer velocity = (Integer)context.getAttribute("velocity");
        if (velocity != null) {
            TGMeasureManager measureManager = this.getSongManager(context).getMeasureManager();
            TGNoteRange noteRange = (TGNoteRange)context.getAttribute("note-range");
            if (noteRange != null && !noteRange.isEmpty()) {
                for (TGNote note : noteRange.getNotes()) {
                    measureManager.changeVelocity(velocity.intValue(), note);
                }
                context.setAttribute("success", (Object)Boolean.TRUE);
            }
        }
    }
}

