/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.action.effect;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGNoteRange;

public class TGChangeSlappingAction
extends TGActionBase {
    public static final String NAME = "action.note.effect.change-slapping";

    public TGChangeSlappingAction(TGContext context) {
        super(context, NAME);
    }

    @Override
    protected void processAction(TGActionContext context) {
        TGNoteRange noteRange = (TGNoteRange)context.getAttribute("note-range");
        TGTrack track = (TGTrack)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
        if (noteRange != null && !noteRange.isEmpty() && !track.isPercussion()) {
            boolean newValue = true;
            if (noteRange.getNotes().stream().allMatch(n -> n.getEffect().isSlapping())) {
                newValue = false;
            }
            for (TGNote note : noteRange.getNotes()) {
                this.getSongManager(context).getMeasureManager().setSlapping(note, newValue);
            }
        }
    }
}

