/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.action.effect;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGNoteRange;

public class TGChangeDeadNoteAction
extends TGActionBase {
    public static final String NAME = "action.note.effect.change-dead";

    public TGChangeDeadNoteAction(TGContext context) {
        super(context, NAME);
    }

    @Override
    protected void processAction(TGActionContext context) {
        TGSongManager songManager = this.getSongManager(context);
        TGNote note = (TGNote)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE);
        TGNoteRange noteRange = (TGNoteRange)context.getAttribute("note-range");
        TGTrack track = (TGTrack)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
        if (noteRange != null && !noteRange.isEmpty() && !track.isPercussion()) {
            boolean newValue = true;
            if (noteRange.getNotes().stream().allMatch(n -> n.getEffect().isDeadNote())) {
                newValue = false;
            }
            for (TGNote n2 : noteRange.getNotes()) {
                songManager.getMeasureManager().setDeadNote(n2, newValue);
            }
        } else if (note == null && !track.isPercussion()) {
            TGMeasure measure = (TGMeasure)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
            TGBeat beat = (TGBeat)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
            TGVoice voice = (TGVoice)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_VOICE);
            TGDuration duration = (TGDuration)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_DURATION);
            TGString string = (TGString)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING);
            int velocity = (Integer)context.getAttribute("velocity");
            note = songManager.getFactory().newNote();
            note.setValue(0);
            note.setVelocity(velocity);
            note.setString(string.getNumber());
            TGDuration noteDuration = duration.clone(songManager.getFactory());
            songManager.getMeasureManager().addNote(measure, beat.getStart(), note, noteDuration, voice.getIndex());
            songManager.getMeasureManager().changeDeadNote(note);
        }
    }
}

